/*
 * Decompiled with CFR 0.152.
 */
package daevil.term;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import daevil.Daevil;
import daevil.OSType;
import daevil.term.Gobbler;
import daevil.term.ProcessResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Console {
    public static List<String> setRunWIthWineCmd(PtyProcessBuilder processBuilder, String executeThis) {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.put("TERM", "xterm-mono");
        env.put("WINEDEBUG", "-all");
        processBuilder.setEnvironment(env);
        String wincmdline = "wine " + (executeThis.contains(".bat") ? "cmd.exe /c " : "") + String.join((CharSequence)" ", executeThis);
        String[] cmd = new String[]{"/bin/sh", "-c", wincmdline};
        processBuilder.setCommand(cmd);
        return List.of(cmd);
    }

    public static Gobbler startStdoutGobbler(PtyProcess process) {
        return new Gobbler(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8), null, process);
    }

    public static Gobbler startStderrGobbler(PtyProcess process) {
        return new Gobbler(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8), null, process);
    }

    public static Gobbler startReader(InputStream in, CountDownLatch latch) {
        return new Gobbler(new InputStreamReader(in, StandardCharsets.UTF_8), latch, null);
    }

    public static String convertInvisibleChars(String s) {
        return s.replace("\n", "\\n").replace("\r", "\\r").replace("\b", "\\b").replace("\u001b", "ESC").replace(String.valueOf('\u0007'), "BEL");
    }

    public static void writeToStdinAndFlush(PtyProcess process, String input, boolean hitEnter) throws IOException {
        String text = hitEnter ? input + (char)process.getEnterKeyCode() : input;
        process.getOutputStream().write(text.getBytes(StandardCharsets.UTF_8));
        process.getOutputStream().flush();
    }

    public static String getProcessStatus(PtyProcess process) {
        boolean running = process.isAlive();
        Integer exitCode = Console.getExitCode(process);
        if (running && exitCode == null) {
            return "alive process";
        }
        return "process running:" + running + ", exit code:" + (Serializable)(exitCode != null ? exitCode : "N/A");
    }

    private static Integer getExitCode(PtyProcess process) {
        Integer exitCode = null;
        try {
            exitCode = process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        return exitCode;
    }

    private void interactWithProcess(PtyProcess process, Gobbler stdout, Map<String, String> input) {
        input.forEach((findInOutput, thenReplyWith) -> {
            if (stdout.awaitTextEndsWith((String)findInOutput, 10000L)) {
                try {
                    Console.writeToStdinAndFlush(process, thenReplyWith, true);
                    stdout.readLine(1000L);
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public ProcessResult execute(OSType host, OSType osType, String executeThis, List<String> arguments, Map<String, String> input, int timeoutSeconds, boolean haltOnFailure) {
        AtomicInteger exitCode = new AtomicInteger();
        ProcessResult result = new ProcessResult(executeThis, "", -1);
        File scriptFile = Paths.get(executeThis, new String[0]).toFile();
        File processDirectory = scriptFile.exists() ? scriptFile.getParentFile() : Paths.get(".", new String[0]).toFile();
        ArrayList<String> arrayList = arguments = arguments == null ? new ArrayList<String>() : arguments;
        if (osType.typeOf(OSType.WINDOWS)) {
            arguments.add(0, "cmd.exe");
            arguments.add(1, "/c");
        } else {
            arguments.add(0, "sh");
            arguments.add(1, "-c");
        }
        arguments.add(2, executeThis);
        PtyProcessBuilder processBuilder = new PtyProcessBuilder().setDirectory(processDirectory.getAbsolutePath()).setRedirectErrorStream(false).setConsole(true).setCommand((String[])arguments.toArray(String[]::new));
        if (host.typeOf(OSType.NIX) && osType.typeOf(OSType.WINDOWS)) {
            arguments = Console.setRunWIthWineCmd(processBuilder, executeThis);
        }
        String processCommand = String.join((CharSequence)" ", arguments);
        Daevil.log.debug("Executing (" + processDirectory + "): " + processCommand);
        try {
            PtyProcess process = processBuilder.start();
            Gobbler stdout = Console.startStdoutGobbler(process);
            Gobbler stderr = Console.startStderrGobbler(process);
            if (input != null) {
                this.interactWithProcess(process, stdout, input);
            } else {
                stdout.awaitFinish();
            }
            stdout.awaitFinish();
            stderr.awaitFinish();
            if (!process.waitFor((long)timeoutSeconds, TimeUnit.SECONDS)) {
                Daevil.log.error("Took more than " + timeoutSeconds + " seconds to run command");
                Daevil.log.error(stderr.getPlainOutput());
                process.getOutputStream().flush();
                process.destroy();
            }
            if (!process.isAlive()) {
                exitCode.set(process.exitValue());
            }
            process.destroy();
            String output = stdout.getPlainOutput() + stderr.getPlainOutput();
            result = new ProcessResult(processCommand, output, exitCode.get());
            if (exitCode.get() == 0) {
                Daevil.log.info(output.trim());
            } else {
                Daevil.log.error(output.trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (exitCode.get() != 0 && haltOnFailure) {
            throw new RuntimeException("Encountered an error (" + exitCode.get() + "), halting further commands.");
        }
        return result;
    }
}

