/*
 * Decompiled with CFR 0.152.
 */
package daevil.term;

import com.pty4j.PtyProcess;
import com.sun.jna.Platform;
import daevil.term.Console;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Gobbler
implements Runnable {
    private static final int WAIT_TIMEOUT_SECONDS = 10;
    private final Reader myReader;
    private final CountDownLatch myLatch;
    private final PtyProcess myProcess;
    private final StringBuffer myOutput;
    private final Thread myThread;
    private final BlockingQueue<String> myLineQueue = new LinkedBlockingQueue<String>();
    private final ReentrantLock myNewTextLock = new ReentrantLock();
    private final Condition myNewTextCondition = this.myNewTextLock.newCondition();

    Gobbler(Reader reader, CountDownLatch latch, PtyProcess process) {
        this.myReader = reader;
        this.myLatch = latch;
        this.myProcess = process;
        this.myOutput = new StringBuffer();
        this.myThread = new Thread((Runnable)this, "Stream gobbler");
        this.myThread.start();
    }

    public static String cleanWinText(String text) {
        if (Platform.isWindows()) {
            return Gobbler.cleanWinTextAnsi(text);
        }
        return text;
    }

    public static String cleanWinTextAnsi(String text) {
        text = ((String)text).replace("\u001b[0m", "").replace("\u001b[m", "").replace("\u001b[0K", "").replace("\u001b[K", "").replace("\u001b[?25l", "").replace("\u001b[?25h", "").replaceAll("\u001b\\[\\d*G", "").replace("\u001b[2J", "").replaceAll("\u001b\\[\\d*;?\\d*H", "").replaceAll("\u001b\\[\\d*X", "").replaceAll(" *\\r\\n", "\r\n").replaceAll(" *$", "").replaceAll("(\\r\\n)+\\r\\n$", "\r\n");
        int oscInd = 0;
        do {
            int bellInd;
            int n = bellInd = (oscInd = ((String)text).indexOf("\u001b]0;", oscInd)) >= 0 ? ((String)text).indexOf(7, oscInd) : -1;
            if (bellInd < 0) continue;
            text = ((String)text).substring(0, oscInd) + ((String)text).substring(bellInd + 1);
        } while (oscInd >= 0);
        int backspaceInd = ((String)text).indexOf(8);
        while (backspaceInd >= 0) {
            text = ((String)text).substring(0, Math.max(0, backspaceInd - 1)) + ((String)text).substring(backspaceInd + 1);
            backspaceInd = ((String)text).indexOf(8);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            char[] buf = new char[32768];
            String linePrefix = "";
            while (true) {
                int count;
                if ((count = this.myReader.read(buf)) <= 0) {
                    this.myReader.close();
                    return;
                }
                this.myOutput.append(buf, 0, count);
                linePrefix = this.processLines(linePrefix + new String(buf, 0, count));
                this.myNewTextLock.lock();
                try {
                    this.myNewTextCondition.signalAll();
                    continue;
                }
                finally {
                    this.myNewTextLock.unlock();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.myLatch != null) {
                this.myLatch.countDown();
            }
        }
    }

    private String processLines(String text) {
        int start = 0;
        int end;
        while ((end = text.indexOf(10, start)) >= 0) {
            this.myLineQueue.add(text.substring(start, end + 1));
            start = end + 1;
        }
        return text.substring(start);
    }

    public String getOutput() {
        return this.myOutput.toString();
    }

    public String getPlainOutput() {
        return Gobbler.cleanWinTextAnsi(this.myOutput.toString()).replaceAll("[\r|\n]+", "\n").trim();
    }

    public void awaitFinish() throws InterruptedException {
        this.myThread.join(TimeUnit.SECONDS.toMillis(10L));
    }

    public String readLine() throws InterruptedException {
        return this.readLine(TimeUnit.SECONDS.toMillis(10L));
    }

    public String readLine(long awaitTimeoutMillis) throws InterruptedException {
        String line = this.myLineQueue.poll(awaitTimeoutMillis, TimeUnit.MILLISECONDS);
        if (line != null) {
            line = Gobbler.cleanWinText(line);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitTextEndsWith(String suffix, long timeoutMillis) {
        long startTimeMillis = System.currentTimeMillis();
        long nextTimeoutMillis = timeoutMillis;
        do {
            this.myNewTextLock.lock();
            try {
                if (this.endsWith(suffix)) {
                    boolean bl = true;
                    return bl;
                }
                this.myNewTextCondition.await(nextTimeoutMillis, TimeUnit.MILLISECONDS);
                if (this.endsWith(suffix)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.myNewTextLock.unlock();
            }
        } while ((nextTimeoutMillis = startTimeMillis + timeoutMillis - System.currentTimeMillis()) >= 0L);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitTextContains(String string, long timeoutMillis) {
        long startTimeMillis = System.currentTimeMillis();
        long nextTimeoutMillis = timeoutMillis;
        do {
            this.myNewTextLock.lock();
            try {
                if (this.contains(string)) {
                    boolean bl = true;
                    return bl;
                }
                this.myNewTextCondition.await(nextTimeoutMillis, TimeUnit.MILLISECONDS);
                if (this.contains(string)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.myNewTextLock.unlock();
            }
        } while ((nextTimeoutMillis = startTimeMillis + timeoutMillis - System.currentTimeMillis()) >= 0L);
        return false;
    }

    private boolean endsWith(String suffix) {
        String text = Gobbler.cleanWinText(this.myOutput.toString());
        return text.trim().toLowerCase().endsWith(suffix.toLowerCase().trim());
    }

    private boolean contains(String searchTerm) {
        String text = Gobbler.cleanWinText(this.myOutput.toString());
        return text.toLowerCase().contains(searchTerm.toLowerCase());
    }

    public void assertEndsWith(String expectedSuffix) {
        this.assertEndsWith(expectedSuffix, TimeUnit.SECONDS.toMillis(10L));
    }

    private void assertEndsWith(String expectedSuffix, long timeoutMillis) {
        boolean ok = this.awaitTextEndsWith(expectedSuffix, timeoutMillis);
        if (!ok) {
            String output = this.getOutput();
            String cleanOutput = Gobbler.cleanWinText(output);
            String actual = cleanOutput.substring(Math.max(0, cleanOutput.length() - expectedSuffix.length()));
            if (expectedSuffix.equals(actual)) {
                throw new RuntimeException("awaitTextEndsWith could detect suffix within timeout, but it is there");
            }
            expectedSuffix = Console.convertInvisibleChars(expectedSuffix);
            actual = Console.convertInvisibleChars(actual);
            int lastTextSize = 1000;
            Object lastText = output.substring(Math.max(0, output.length() - lastTextSize));
            if (output.length() > lastTextSize) {
                lastText = "..." + (String)lastText;
            }
            if (expectedSuffix.equals(actual)) {
                throw new RuntimeException("Unmatched suffix (trailing text: " + Console.convertInvisibleChars((String)lastText) + (String)(this.myProcess != null ? ", " + Console.getProcessStatus(this.myProcess) : "") + ")");
            }
        }
    }
}

