/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu;

import daevil.Daevil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchFileBuilder {
    StringBuilder content;
    HashSet<String> functionBucket;

    public BatchFileBuilder() {
        this(false);
    }

    public BatchFileBuilder(Boolean echo) {
        String echoVar = Optional.ofNullable(echo).filter(p -> p).map(m -> "on").orElse("off");
        this.content = new StringBuilder("@echo " + echoVar + "\nsetLocal EnableDelayedExpansion\nIF \"x%SCRIPT_DIR%\" == \"x\" SET SCRIPT_DIR=%~dp0%\nIF \"!SCRIPT_DIR:~-1!\"==\"\\\\\" SET SCRIPT_DIR=!SCRIPT_DIR:~,-1!\nSET BASE_SCRIPT_DIR=%SCRIPT_DIR%\n");
        this.functionBucket = new HashSet();
    }

    public static String powerShellString(String scriptPath, Object ... args) {
        String out = Daevil.render("daevil/script/windows/powershell/" + scriptPath + ".jte", args);
        String script = out.trim().replaceAll("[\r|\n]+(\\s*)", "; ").replace("\"", "\\\"");
        script = script.replace("{;", "{").replace("};", "}");
        return "powershell.exe -Noninteractive -NoProfile -command \"" + script + "\"";
    }

    public static String powerShellVariable(String scriptPath, String variableName, Object ... args) {
        String out = Daevil.render("daevil/script/windows/powershell/" + scriptPath + ".jte", args);
        String script = out.trim().replaceAll("[\r|\n]", "; ^\n");
        return "set \"ps_" + scriptPath + "_Command=powershell -executionpolicy remotesigned -Noninteractive -NoProfile -command \"" + script + "\"\"\n    for /f \"usebackq delims=\" %%G in (`%ps_" + scriptPath + "_Command%`) do (set \"" + variableName + "=%%G\")";
    }

    public HashSet<String> getFunctionBucket() {
        return this.functionBucket;
    }

    public StringBuilder append(String string) {
        return this.content.append(string);
    }

    public String call(String function, String ... args) {
        String out = Daevil.render("daevil/script/windows/batch/function/" + function + ".jte", Collections.singletonMap("builder", this));
        this.getFunctionBucket().add(out);
        return "CALL :" + function + " \"" + String.join((CharSequence)"\" \"", args) + "\"";
    }

    public String toString() {
        return this.content.append("\nendlocal\nEXIT /B 0\n\n::*** FUNCTIONS ***\n").append(String.join((CharSequence)"\n", this.getFunctionBucket())).toString();
    }

    public boolean write(Path filePath) {
        try {
            Daevil.log.info("Writing " + filePath);
            Files.write(filePath, this.toString().getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeDebug(Path filePath) {
        try {
            Daevil.log.info("Writing " + filePath);
            StringBuilder debugVersion = new StringBuilder();
            AtomicInteger count = new AtomicInteger();
            Arrays.stream(this.toString().split("\n")).forEach(line -> {
                try {
                    debugVersion.append("\necho.Line ").append(count.incrementAndGet()).append(System.lineSeparator()).append((String)line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            Files.write(filePath, debugVersion.toString().getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

