/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu.dependency;

import daevil.Daevil;
import daevil.OSType;
import daevil.menu.Menu;
import daevil.menu.dependency.Resolver;
import daevil.property.Property;
import java.util.HashMap;

public class commandboxResolver
extends Resolver {
    private String _urlPrefix = "https://www.ortussolutions.com/parent/download/commandbox/type/windows-jre";
    public final Property<String> urlPrefix = Property.get(() -> this._urlPrefix).set(value -> {
        this._urlPrefix = value;
        return this._urlPrefix;
    });
    private String _version = "latest";
    public final Property<String> version = Property.get(() -> this._version).set(value -> {
        this._version = value;
        return this._version;
    });
    private String _prompt = "COMMANDBOX_HOME not set, and not detected in path.  Download CommandBox? [Y/n]";
    public final Property<String> prompt = Property.get(() -> this._prompt).set(value -> {
        this._prompt = value;
        return this._prompt;
    });

    commandboxResolver(Menu menu) {
        super(menu);
    }

    private String url() {
        return this.urlPrefix.get() + this.version.get() + "-";
    }

    @Override
    public String generate(OSType osType) {
        if (OSType.NIX.typeOf(osType)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("urlPrefix", this.urlPrefix.get());
            map.put("prompt", this.prompt.get());
            return Daevil.render("daevil/script/nix/bash/JavaResolver", map);
        }
        if (OSType.WINDOWS.typeOf(osType)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("urlPrefix", this.urlPrefix.get());
            map.put("prompt", this.prompt.get());
            return Daevil.render("daevil/script/windows/batch/JavaResolver", map);
        }
        throw new IllegalArgumentException("Don't know how to handle osType of " + osType);
    }
}

