/*
 * Decompiled with CFR 0.152.
 */
package daevil.property;

import daevil.property.ExplicitName;
import daevil.property.GuessesName;
import daevil.property.Named;
import daevil.property.Readonly;
import daevil.property.Writeonly;
import java.util.function.Function;
import java.util.function.Supplier;

public class Property<T> {
    private final Function<T, T> setter;
    private Supplier<T> getter;

    public Property(Supplier<T> getter, Function<T, T> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public static <T> Writeonly<T> set(Function<T, T> setter) {
        Property<Object> prop = new Property<Object>(() -> {
            throw new UnsupportedOperationException();
        }, setter);
        return prop::set;
    }

    public static <T> PropertyBuilder<T> get(final Supplier<T> getter) {
        return new PropertyBuilder<T>(){

            @Override
            public Property<T> set(Function<T, T> setter) {
                return new Property(getter, setter);
            }

            @Override
            public Readonly<T> readonly() {
                Property prop = new Property(getter, Function.identity());
                return prop::get;
            }
        };
    }

    public T set(T value) {
        return this.setter.apply(value);
    }

    public T get() {
        return this.getter.get();
    }

    public Named<T> named() {
        return new GuessesName<T>(this.getter, this.setter);
    }

    public Named<T> named(String name) {
        return new ExplicitName<T>(this.getter, this.setter, name);
    }

    public String toString() {
        T value = this.getter.get();
        if (value instanceof String) {
            return value.toString();
        }
        return this.getter.get().toString();
    }

    public static interface PropertyBuilder<T> {
        public Property<T> set(Function<T, T> var1);

        public Readonly<T> readonly();
    }
}

