/*
 * Decompiled with CFR 0.152.
 */
package daevil;

import daevil.OS;
import daevil.OSType;
import daevil.ResourceUtil;
import daevil.iconexe.IconExe;
import daevil.menu.Menu;
import daevil.menu.MenuOption;
import daevil.menu.MultiOSMenu;
import daevil.menu.dependency.JavaResolver;
import daevil.property.Property;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Daevil {
    public static final String LOGLEVEL_PROPERTY = "daevil.loglevel";
    private HashMap<String, String> tokens = new HashMap();
    private Path _dest;
    public final Property<Path> dest = Property.get(() -> this._dest).set(value -> {
        this._dest = value;
        return this._dest;
    });
    private String _name;
    public final Property<String> name = Property.get(() -> this._name).set(value -> {
        this._name = value;
        return this._name;
    });
    private String _title;
    public final Property<String> title = Property.get(() -> this._title).set(value -> {
        this._title = value;
        return this._title;
    });
    private String _user;
    public final Property<String> user = Property.get(() -> this._user).set(value -> {
        this._user = value;
        return this._user;
    });
    private String _description;
    public final Property<String> description = Property.get(() -> this._description).set(value -> {
        this._description = value;
        return this._description;
    });
    private String _consoleSuccessOutput;
    public final Property<String> consoleSuccessOutput = Property.get(() -> this._consoleSuccessOutput).set(value -> {
        this._consoleSuccessOutput = value;
        return this._consoleSuccessOutput;
    });
    private String _ctlScript;
    public final Property<String> ctlScript = Property.get(() -> this._ctlScript).set(value -> {
        this._ctlScript = value;
        return this._ctlScript;
    });
    private String _argStart = "start";
    public final Property<String> argStart = Property.get(() -> this._argStart).set(value -> {
        this._argStart = value;
        return this._argStart;
    });
    private String _argStartDarwin = "start-foreground";
    public final Property<String> argStartDarwin = Property.get(() -> this._argStartDarwin).set(value -> {
        this._argStartDarwin = value;
        return this._argStartDarwin;
    });
    private String _argStop = "stop";
    public final Property<String> argStop = Property.get(() -> this._argStop).set(value -> {
        this._argStop = value;
        return this._argStop;
    });
    private String _logFileOut;
    public final Property<String> logFileOut = Property.get(() -> this._logFileOut).set(value -> {
        this._logFileOut = value;
        return this._logFileOut;
    });
    private String _logFileErr;
    public final Property<String> logFileErr = Property.get(() -> this._logFileErr).set(value -> {
        this._logFileErr = value;
        return this._logFileErr;
    });
    private String _serviceImg;
    public final Property<String> serviceImg = Property.get(() -> this._serviceImg).set(value -> {
        this._serviceImg = value;
        return this._serviceImg;
    });
    private String _pidFile;
    public final Property<String> pidFile = Property.get(() -> this._pidFile).set(value -> {
        this._pidFile = value;
        return this._pidFile;
    });
    private String _grepSuccessFile;
    public final Property<String> grepSuccessFile = Property.get(() -> this._grepSuccessFile).set(value -> {
        this._grepSuccessFile = value;
        return this._grepSuccessFile;
    });
    private String _grepSuccessString;
    public final Property<String> grepSuccessString = Property.get(() -> this._grepSuccessString).set(value -> {
        this._grepSuccessString = value;
        return this._grepSuccessString;
    });
    private String _additional;
    public final Property<String> additional = Property.get(() -> this._additional).set(value -> {
        this._additional = value;
        return this._additional;
    });
    private OS os = OS.getOs();
    private String osName = this.os.getName();
    private String osPlatformName = this.os.getPlatformName();
    private MultiOSMenu controlScript;

    public Daevil() {
        this("service");
    }

    public Daevil(String name) {
        log.debug(this.osName);
        log.debug(this.osPlatformName);
        this.name.set(name);
        this.ctlScript.set(name + "-ctl");
        this.controlScript = new MultiOSMenu(name + " Control Script");
        this.controlScript.fileName.set(name + "-ctl");
        this.addMenuOptions(this.controlScript);
    }

    Daevil(Path destination, String name, String title, String description, String consoleSuccessOutput, String ctlScript, String commandStart, String commandStop, String logFileOut, String logFileErr, String serviceImg) {
        this(name);
        this.dest.set(destination);
        this.title.set(title);
        this.description.set(description);
        this.consoleSuccessOutput.set(consoleSuccessOutput);
        this.ctlScript.set(ctlScript);
        this.argStart.set(commandStart);
        this.argStop.set(commandStop);
        this.logFileOut.set(logFileOut);
        this.logFileErr.set(logFileErr);
        this.serviceImg.set(serviceImg);
    }

    public MultiOSMenu controlScript() {
        return this.controlScript;
    }

    public Menu controlScript(OSType osType) {
        return this.controlScript.menu(osType);
    }

    private void addMenuOptions(MultiOSMenu menu) {
        menu.addOption("install-" + this.name.get(), "install the " + this.name.get() + " daemon").command(OSType.WINDOWS, "CALL \"%SCRIPT_DIR%\\bin\\service\\\"install-service.bat install").command(OSType.WINDOWS, "CALL \"%SCRIPT_DIR%\\bin\\service\\\"install-service.bat start").command(OSType.NIX, "\"$SCRIPT_DIR/bin/daemon/\"install");
        menu.addOption("remove-" + this.name.get(), "remove the " + this.name.get() + " daemon").command(OSType.WINDOWS, "CALL \"%SCRIPT_DIR%\\bin\\service\\\"install-service.bat uninstall").command(OSType.NIX, "\"$SCRIPT_DIR/bin/daemon/\"remove");
    }

    public MenuOption addOption(String name, String description) {
        return this.controlScript.addOption(name, description);
    }

    public JavaResolver javaResolver() {
        JavaResolver resolver = new JavaResolver(this.controlScript);
        this.controlScript.resolver(resolver);
        log.debug("Added java resolver");
        return resolver;
    }

    private void updateTokens() {
        this.tokens.put("user", this.user.get());
        this.tokens.put("name", this.name.get());
        this.tokens.put("title", this.title.get());
        this.tokens.put("description", this.description.get());
        this.tokens.put("ctl-script", this.ctlScript.get());
        this.tokens.put("arg-start", this.argStart.get());
        this.tokens.put("arg-start-darwin", this.argStartDarwin.get());
        this.tokens.put("arg-stop", this.argStop.get());
        this.tokens.put("console-success-output", this.consoleSuccessOutput.get());
        this.tokens.put("log-file-out", this.logFileOut.get());
        this.tokens.put("log-file-err", this.logFileErr.get());
        this.tokens.put("pid-file", this.pidFile.get());
        this.tokens.put("grep-success-file", this.grepSuccessFile.get());
        this.tokens.put("grep-success-string", this.grepSuccessString.get());
        this.tokens.put("additional", this.additional.get());
    }

    public void generateScripts(OSType osType, Path dest) {
        if (osType.typeOf(OSType.NIX)) {
            this.generateNixScripts(dest);
        } else if (osType.typeOf(OSType.WINDOWS)) {
            this.generateWindowsScripts(dest);
        } else {
            throw new IllegalArgumentException("OSType is of unknown kind, cannot generate: " + osType.type());
        }
    }

    public void generateScriptsForHostOS(Path dest) {
        this.generateScripts(OSType.host(), dest);
    }

    void generateNixScripts(Path dest) {
        this.updateTokens();
        this.controlScript.generate(OSType.NIX, dest);
        String nixFiles = "/script/nix/";
        String nixTmplFiles = "/script/nix/tmpl";
        log.info("Generating *nix service scripts");
        ResourceUtil.copyResourcesReplaceTokens(nixFiles, Paths.get(dest.toString() + "/bin/daemon", new String[0]), this.tokens, false, ".*", "");
        ResourceUtil.copyResources(nixTmplFiles, Paths.get(dest.toString() + "/bin/daemon/tmpl", new String[0]), ".*", "");
    }

    void generateWindowsScripts(Path dest) {
        this.updateTokens();
        this.controlScript.generate(OSType.WINDOWS, dest);
        String windowsFiles = "/script/windows/";
        String procrunFiles = "/script/windows/procrun/";
        log.info("Generating windows service scripts");
        ResourceUtil.copyResourcesReplaceTokens(windowsFiles, dest, this.tokens, false, "install.*bat|README.txt", "");
        ResourceUtil.copyResources(procrunFiles + "amd64/", Paths.get(dest.toString(), "amd64/"), "prunsrv.*", "prunsrv," + this.name.get());
        ResourceUtil.copyResources(procrunFiles, dest, "prunsrv.*", "prunsrv," + this.name.get());
        ResourceUtil.copyResources(procrunFiles, dest, "prunmgr.*", "prunmgr," + this.name.get() + "w");
        log.info("setting image icon if present");
        if (this.serviceImg.get() != null && !this.serviceImg.get().isEmpty()) {
            log.info("Loading image for windows service file: " + this.serviceImg.get());
            try {
                IconExe.setIcon(new File(dest.toFile(), this.name.get() + ".exe"), this.serviceImg.get());
                IconExe.setIcon(new File(dest.toFile(), this.name.get() + "w.exe"), this.serviceImg.get());
                IconExe.setIcon(new File(dest.toFile(), "amd64/" + this.name.get() + ".exe"), this.serviceImg.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            log.info("No image for windows service file.");
        }
        log.info("done with service scripts");
    }

    static Path getJarPath() {
        try {
            return Paths.get(Daevil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String render(String scriptPath, Map<String, Object> args) {
        TemplateEngine engine = TemplateEngine.createPrecompiled((Path)Daevil.getJarPath(), (ContentType)ContentType.Plain, (ClassLoader)Daevil.class.getClassLoader(), (String)"daevil");
        StringOutput out = new StringOutput();
        engine.render(scriptPath, args, (TemplateOutput)out);
        return out.toString();
    }

    public static String render(String scriptPath, Object ... args) {
        TemplateEngine engine = TemplateEngine.createPrecompiled((Path)Daevil.getJarPath(), (ContentType)ContentType.Plain, (ClassLoader)Daevil.class.getClassLoader(), (String)"daevil");
        StringOutput out = new StringOutput();
        engine.render(scriptPath, (Object)args, (TemplateOutput)out);
        return out.toString();
    }

    public static class log {
        static final String logLevel;
        static final Logger LOGGER;
        static final Level LEVEL;

        public static void debug(String message) {
            LOGGER.log(Level.CONFIG, message);
        }

        public static void trace(String message) {
            LOGGER.log(Level.FINER, message);
        }

        public static void info(String message) {
            LOGGER.log(Level.INFO, message);
        }

        public static void info(Path path) {
            log.info(path.toString());
        }

        public static void debug(Path path) {
            log.debug(path.toString());
        }

        public static void error(String message) {
            LOGGER.log(Level.SEVERE, message);
        }

        public static void setLevel(Level targetLevel) {
            Logger root = Logger.getLogger("");
            root.setLevel(targetLevel);
            for (Handler handler : root.getHandlers()) {
                handler.setLevel(targetLevel);
            }
            System.out.println("level set: " + targetLevel.getName());
        }

        static {
            System.setProperty("java.util.logging.SimpleFormatter.format", "%5$s%6$s%n");
            logLevel = System.getProperty(Daevil.LOGLEVEL_PROPERTY, "INFO");
            LOGGER = Logger.getLogger(Daevil.class.getName());
            LEVEL = logLevel.equalsIgnoreCase("trace") ? Level.FINEST : Level.parse(logLevel);
            LOGGER.setLevel(LEVEL);
            LOGGER.setUseParentHandlers(false);
            LOGGER.addHandler(new Handler(){

                @Override
                public void publish(LogRecord record) {
                    if (this.getFormatter() == null) {
                        this.setFormatter(new SimpleFormatter());
                    }
                    try {
                        String message = this.getFormatter().format(record);
                        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                            System.err.write(message.getBytes());
                            System.err.flush();
                        } else {
                            System.out.write(message.getBytes());
                            System.out.flush();
                        }
                    }
                    catch (Exception exception) {
                        this.reportError(null, exception, 5);
                    }
                }

                @Override
                public void close() throws SecurityException {
                }

                @Override
                public void flush() {
                }
            });
        }
    }

    static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

