/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu;

import daevil.OSType;
import daevil.menu.BatchFileBuilder;
import daevil.menu.Menu;
import daevil.menu.MenuOption;
import java.util.List;

public class BashMenu
extends Menu {
    public BashMenu(String title) {
        super(title);
    }

    BashMenu(String title, List<MenuOption> options) {
        super(title, options);
    }

    @Override
    public String generate() {
        String usage = this.usageString("usage: $(basename $0) [", "|");
        StringBuilder menuText = new StringBuilder();
        menuText.append("#!/usr/bin/env sh\n# Resolve links: $0 may be a link\nPRG=\"$0\"\n# Need this for relative symlinks.\nwhile [ -h \"$PRG\" ]; do\n\tls=$(ls -ld \"$PRG\")\n\tlink=$(expr \"$ls\" : '.*-> \\(.*\\)$')\n\tif expr \"$link\" : '/.*' >/dev/null; then\n\t\tPRG=\"$link\"\n\telse\n\t\tPRG=$(dirname \"$PRG\")\"/$link\"\n\tfi\ndone\nSAVED=\"$(pwd)\"\ncd \"$(dirname \"$PRG\")/\" || exit 1\nSCRIPT_DIR=\"$(pwd -P)\"\nPROJECT_ROOT=\"$( cd \"$SCRIPT_DIR\" && pwd )\"\ncd \"$SAVED\" || exit 1\nexport EXIT_CODE=0\n");
        menuText.append(this.generateResolverText(OSType.NIX));
        this._options.forEach(option -> {
            menuText.append(this.safeName(option.name.get()) + "() {\n");
            menuText.append("    " + option.commandLines(OSType.NIX) + " \"$@\"\n");
            menuText.append("    export EXIT_CODE=$?\n");
            menuText.append("}\n");
        });
        menuText.append("#skip menu if arguments are passed\nif [ -z \"$1\" ]; then\nwhile [ answer != \"0\" ]\ndo\nclear\ncd \"$SCRIPT_DIR\"\necho  \"" + (String)this.title.get() + "\"\necho \"  " + usage + "\"\necho\necho \"Select from the following options\"\necho\necho \"  0  EXIT\"\n");
        this._options.forEach(option -> {
            if (option.name.get().equals("separator")) {
                menuText.append("echo \"  ************************************************************\"\n");
            } else {
                menuText.append("echo \"  " + option.number.get() + "  " + option.name.get() + " (" + option.description.get() + ")\"\n");
            }
        });
        menuText.append("echo\n");
        menuText.append("echo \"Option number: \"\n");
        menuText.append("IFS='' read -r answer\n");
        menuText.append("  case $answer in\n");
        menuText.append("    0) break ;;\n");
        this._options.forEach(option -> {
            if (!option.name.get().equals("separator")) {
                menuText.append("    " + option.number.get() + ") " + this.safeName(option.name.get()) + "\n");
                menuText.append("    ;;\n");
            }
        });
        menuText.append("    *) break ;;\n");
        menuText.append("    esac\n");
        menuText.append(" echo \"press RETURN for menu\"\n");
        menuText.append(" read key\n");
        menuText.append("done\n");
        menuText.append("exit 0\n");
        menuText.append("fi\n");
        menuText.append("#arguments were passed in\n");
        this._options.forEach(option -> {
            if (!option.name.get().equals("separator")) {
                menuText.append("if [ $1 = " + option.name.get() + " ]; then\n");
                menuText.append("   " + this.safeName(option.name.get()) + " \"${@:2}\"\n");
                menuText.append("   exit $EXIT_CODE\n");
                menuText.append("fi\n");
            }
        });
        return menuText.toString();
    }

    @Override
    public BatchFileBuilder batchFileBuilder() {
        throw new UnsupportedOperationException("This is a bash file, not a batch file.");
    }
}

