/*
 * Decompiled with CFR 0.152.
 */
package daevil.property;

import daevil.property.ExceptionalFunction;
import daevil.property.ExceptionalSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Result<T> {
    public static <R, E extends Exception> Supplier<Result<R>> wrapReturn(ExceptionalSupplier<R, E> f) {
        return () -> {
            try {
                return new Success(f.supply());
            }
            catch (Exception e) {
                return new Failure(e);
            }
        };
    }

    public static <T> Consumer<Result<T>> wrapConsumer(Consumer<T> f) {
        Function<Object, Object> f2 = t -> {
            f.accept(t);
            return t;
        };
        return t -> {
            try {
                t.map(f2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, Result<R>> wrapReturn(ExceptionalFunction<T, R, E> f) {
        return t -> {
            try {
                return new Success(f.apply(t));
            }
            catch (Exception e) {
                return new Failure(e);
            }
        };
    }

    public static <T, R> Function<Result<T>, Result<R>> wrap(Function<T, R> f) {
        return t -> {
            try {
                return t.map(f);
            }
            catch (Exception e) {
                return new Failure(e);
            }
        };
    }

    public static <T, R, E extends Exception> Function<Result<T>, Result<R>> wrapExceptional(ExceptionalFunction<T, R, E> f) {
        return t -> {
            try {
                return t.mapExceptional(f);
            }
            catch (Exception e) {
                return new Failure(e);
            }
        };
    }

    public static <T, R> ResultMapper<T, R> onSuccess(Function<T, R> f) {
        return new ResultMapper<T, R>(f);
    }

    public T unwrap();

    public boolean success();

    public <R> Result<R> map(Function<T, R> var1);

    public <R, E extends Exception> Result<R> mapExceptional(ExceptionalFunction<T, R, E> var1);

    public <R, E extends Exception> Result<R> map(Class<E> var1, Function<E, R> var2);

    public static class ExceptionHandler<R> {
        final Class type;
        final Function<Exception, R> function;

        public ExceptionHandler(Class type, Function<Exception, R> function) {
            this.type = type;
            this.function = function;
        }
    }

    public static class ResultMapper<T, R> {
        private Function<T, R> successMapper;
        private List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();

        public ResultMapper(Function<T, R> successMapper) {
            this.successMapper = successMapper;
        }

        public Function<Result<T>, Result<R>> mapper() {
            return t -> {
                if (t instanceof Success) {
                    return t.map(this.successMapper);
                }
                for (ExceptionHandler handler : this.exceptionHandlers) {
                    Result r = t.map(handler.type, handler.function);
                    if (!(r instanceof Success)) continue;
                    return r;
                }
                return new Failure(t);
            };
        }

        public <E extends Exception> ResultMapper<T, R> on(Class<E> eCls, Function<E, R> f) {
            this.exceptionHandlers.add(new ExceptionHandler<R>(eCls, f));
            return this;
        }
    }

    public static class Failure<T>
    implements Result<T> {
        private Exception e;

        public Failure(Exception e) {
            this.e = e;
        }

        public <R> Failure(Result<R> t) {
            this.e = t instanceof Failure ? ((Failure)t).e : new IllegalStateException();
        }

        @Override
        public T unwrap() {
            throw this.e instanceof RuntimeException ? (RuntimeException)this.e : new RuntimeException(this.e);
        }

        @Override
        public boolean success() {
            return false;
        }

        @Override
        public <R> Result<R> map(Function<T, R> f) {
            return new Failure<T>(this.e);
        }

        @Override
        public <R, E extends Exception> Result<R> mapExceptional(ExceptionalFunction<T, R, E> f) {
            return new Failure<T>(this.e);
        }

        @Override
        public <R, E extends Exception> Result<R> map(Class<E> cls, Function<E, R> f) {
            if (this.e.getClass().isAssignableFrom(cls)) {
                return new Success<R>(f.apply(this.e));
            }
            return new Failure<T>(this.e);
        }
    }

    public static class Success<T>
    implements Result<T> {
        private T value;

        public Success(T value) {
            this.value = value;
        }

        @Override
        public T unwrap() {
            return this.value;
        }

        @Override
        public boolean success() {
            return true;
        }

        @Override
        public <R> Result<R> map(Function<T, R> f) {
            return new Success<R>(f.apply(this.value));
        }

        @Override
        public <R, E extends Exception> Result<R> mapExceptional(ExceptionalFunction<T, R, E> f) {
            try {
                return new Success<R>(f.apply(this.value));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return new Failure(e);
            }
        }

        @Override
        public <R, E extends Exception> Result<R> map(Class<E> cls, Function<E, R> f) {
            return new Failure(new IllegalStateException());
        }
    }
}

