/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.util.LazyValue;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.platform.win32.VersionUtil;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsVersion {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsVersion.class);
    private static LazyValue<Version> myVersionValue = new LazyValue<Version>(new Callable<Version>(){

        @Override
        public Version call() throws Exception {
            return WindowsVersion.getVersion();
        }
    });

    WindowsVersion() {
    }

    @NotNull
    public static Version getVersion() {
        try {
            VerRsrc.VS_FIXEDFILEINFO x = VersionUtil.getFileVersionInfo("kernel32.dll");
            Version version = new Version(x.getProductVersionMajor(), x.getProductVersionMinor(), x.getProductVersionRevision());
            LOG.info("Windows version: " + version);
            return version;
        }
        catch (Exception e) {
            LOG.info("Cannot get Windows version", (Throwable)e);
            return new Version(-1L, -1L, -1L);
        }
    }

    static boolean isEqualTo(long majorVersion, long minorVersion, long buildNumber) {
        Version version;
        try {
            version = myVersionValue.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return majorVersion == version.myMajorVersion && minorVersion == version.myMinorVersion && buildNumber == version.myBuildNumber;
    }

    private static class Version {
        private final long myMajorVersion;
        private final long myMinorVersion;
        private final long myBuildNumber;

        Version(long majorVersion, long minorVersion, long buildNumber) {
            this.myMajorVersion = majorVersion;
            this.myMinorVersion = minorVersion;
            this.myBuildNumber = buildNumber;
        }

        public String toString() {
            return this.myMajorVersion + "." + this.myMinorVersion + "." + this.myBuildNumber;
        }
    }
}

