/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.windows.WinPtyProcess;
import com.pty4j.windows.conpty.Kernel32Ex;
import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.pty4j.windows.conpty.PseudoConsole;
import com.pty4j.windows.conpty.WinEx;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProcessUtils {
    ProcessUtils() {
    }

    public static WinBase.PROCESS_INFORMATION startProcess(@NotNull PseudoConsole pseudoConsole, @NotNull String[] command, @Nullable String workingDirectory, @NotNull Map<String, String> environment) throws IOException {
        WinEx.STARTUPINFOEX startupInfo = ProcessUtils.prepareStartupInformation(pseudoConsole);
        return ProcessUtils.start(startupInfo, command, workingDirectory, environment);
    }

    private static WinEx.STARTUPINFOEX prepareStartupInformation(@NotNull PseudoConsole pseudoConsole) throws IOException {
        WinEx.STARTUPINFOEX startupInfo = new WinEx.STARTUPINFOEX();
        startupInfo.StartupInfo.cb = new WinDef.DWORD((long)startupInfo.size());
        startupInfo.StartupInfo.lpReserved2 = null;
        startupInfo.StartupInfo.hStdOutput = null;
        startupInfo.StartupInfo.hStdError = null;
        startupInfo.StartupInfo.hStdInput = null;
        startupInfo.StartupInfo.dwFlags = 256;
        WinEx.SIZE_TByReference bytesRequired = new WinEx.SIZE_TByReference();
        if (Kernel32Ex.INSTANCE.InitializeProcThreadAttributeList(null, new WinDef.DWORD(1L), new WinDef.DWORD(0L), bytesRequired)) {
            throw new IllegalStateException("InitializeProcThreadAttributeList was unexpected to succeed");
        }
        Memory threadAttributeList = new Memory(bytesRequired.getValue().intValue());
        threadAttributeList.clear();
        startupInfo.lpAttributeList = threadAttributeList;
        if (!Kernel32Ex.INSTANCE.InitializeProcThreadAttributeList(threadAttributeList, new WinDef.DWORD(1L), new WinDef.DWORD(0L), bytesRequired)) {
            throw new LastErrorExceptionEx("InitializeProcThreadAttributeList");
        }
        if (!Kernel32Ex.INSTANCE.UpdateProcThreadAttribute(threadAttributeList, new WinDef.DWORD(0L), new BaseTSD.DWORD_PTR(131094L), new WinDef.PVOID(pseudoConsole.getHandle().getPointer()), new BaseTSD.SIZE_T((long)Native.POINTER_SIZE), null, null)) {
            throw new LastErrorExceptionEx("UpdateProcThreadAttribute");
        }
        return startupInfo;
    }

    private static WinBase.PROCESS_INFORMATION start(@NotNull WinEx.STARTUPINFOEX startupInfo, @NotNull String[] command, @Nullable String workingDirectory, @NotNull Map<String, String> environment) throws IOException {
        WinBase.PROCESS_INFORMATION processInfo = new WinBase.PROCESS_INFORMATION();
        String commandLine = WinPtyProcess.joinCmdArgs(command);
        if (!Kernel32Ex.INSTANCE.CreateProcessW(null, (commandLine + "\u0000").toCharArray(), null, null, false, new WinDef.DWORD(525312L), ProcessUtils.toEnvironmentBlock(environment), workingDirectory, startupInfo, processInfo)) {
            throw new LastErrorExceptionEx("CreateProcessW");
        }
        return processInfo;
    }

    @NotNull
    private static Memory toEnvironmentBlock(@NotNull Map<String, String> environment) {
        String str = environment.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue() + "\u0000").collect(Collectors.joining()) + "\u0000";
        byte[] bytes = str.getBytes(StandardCharsets.UTF_16LE);
        Memory result = new Memory(bytes.length);
        result.write(0L, bytes, 0, bytes.length);
        return result;
    }

    public static void closeHandles(WinBase.PROCESS_INFORMATION processInformation) throws IOException {
        if (!Kernel32.INSTANCE.CloseHandle(processInformation.hThread)) {
            throw new LastErrorExceptionEx("CloseHandle hThread");
        }
        if (!Kernel32.INSTANCE.CloseHandle(processInformation.hProcess)) {
            throw new LastErrorExceptionEx("CloseHandle hProcess");
        }
    }
}

