/*
 * Decompiled with CFR 0.152.
 */
package daevil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OS {
    public static final OS OS;
    private static final Map<String, String> MAC_OS;
    private static final Map<Integer, String> DARWIN;
    private static final List<String> UNIX;
    private final OsInfo osInfo;

    @Deprecated
    public static OS getOs() {
        return SingletonHolder.instance;
    }

    private OS() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        OsInfo osInfo = null;
        if (name != null) {
            if (name.startsWith("Windows")) {
                osInfo = new OsInfo(name, version, arch, name);
            } else if (name.startsWith("Mac")) {
                osInfo = this.initMacOsInfo(name, version, arch);
            } else if (name.startsWith("Darwin")) {
                osInfo = this.initDarwinOsInfo(name, version, arch);
            } else {
                for (String unixName : UNIX) {
                    if (!name.startsWith(unixName)) continue;
                    osInfo = this.initUnixOsInfo(name, version, arch);
                }
            }
        }
        if (osInfo == null) {
            osInfo = new OsInfo(name, version, arch, name);
        }
        this.osInfo = osInfo;
    }

    public String getName() {
        return this.osInfo.getName();
    }

    public String getArch() {
        return this.osInfo.getArch();
    }

    public String getVersion() {
        return this.osInfo.getVersion();
    }

    public String getPlatformName() {
        return this.osInfo.getPlatformName();
    }

    public String toString() {
        return "OS{Name = " + this.osInfo.getName() + ", Architecture = " + this.osInfo.getArch() + ", Platform = " + this.osInfo.getPlatformName() + ", Version = " + this.osInfo.getVersion() + "}";
    }

    private OsInfo initMacOsInfo(String name, String version, String arch) {
        String versionKey;
        int dotIndex = version.indexOf(46);
        int numericVersion = Integer.parseInt(dotIndex < 0 ? version : version.substring(0, dotIndex));
        dotIndex = version.indexOf(46, dotIndex + 1);
        String string = versionKey = dotIndex < 3 ? version : version.substring(0, dotIndex);
        if (numericVersion < 10) {
            return new OsInfo(name, version, arch, "Mac OS " + version);
        }
        if (numericVersion == 10) {
            String versionName = MAC_OS.containsKey(versionKey) ? MAC_OS.get(versionKey) : "unknown";
            return new OsInfo(name, version, arch, "OS X " + versionName + " (" + version + ")");
        }
        String versionName = MAC_OS.containsKey(String.valueOf(numericVersion)) ? MAC_OS.get(String.valueOf(numericVersion)) : "unknown";
        return new OsInfo(name, version, arch, "OS X " + versionName + " (" + version + ")");
    }

    private OsInfo initDarwinOsInfo(String name, String version, String arch) {
        String[] versions = version.split("\\.");
        int numericVersion = Integer.parseInt(versions[0]);
        String versionName = DARWIN.containsKey(numericVersion) ? DARWIN.get(numericVersion) : "unknown";
        return new OsInfo(name, version, arch, "OS X " + versionName + " (" + version + ")");
    }

    private OsInfo initUnixOsInfo(String name, String version, String arch) {
        File fileVersion;
        File dir;
        OsInfo osInfo = this.getPlatformNameFromLsbRelease(name, version, arch);
        if (osInfo == null) {
            osInfo = this.getPlatformNameFromOsRelease(name, version, arch);
        }
        if (osInfo == null) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, "/etc/system-release");
        }
        if ((dir = new File("/etc/")).exists()) {
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, this.getFileEndingWith(dir, "-release"));
            }
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, this.getFileEndingWith(dir, "_version"));
            }
            if (osInfo == null) {
                osInfo = this.getPlatformNameFromFile(name, version, arch, "/etc/issue");
            }
        }
        if ((fileVersion = new File("/proc/version")).exists() && osInfo == null) {
            osInfo = this.getPlatformNameFromFile(name, version, arch, fileVersion.getAbsolutePath());
        }
        if (osInfo == null) {
            osInfo = new OsInfo(name, version, arch, name);
        }
        return osInfo;
    }

    private String getFileEndingWith(File dir, final String fileEndingWith) {
        File[] fileList = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(fileEndingWith);
            }
        });
        if (fileList.length > 0) {
            return fileList[0].getAbsolutePath();
        }
        return null;
    }

    private OsInfo getPlatformNameFromFile(String name, String version, String arch, String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                return this.readPlatformName(name, version, arch, br);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    OsInfo readPlatformName(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String lineToReturn = null;
        int lineNb = 0;
        while ((line = br.readLine()) != null) {
            if (lineNb++ == 0) {
                lineToReturn = line;
            }
            if (!line.startsWith("PRETTY_NAME")) continue;
            return new OsInfo(name, version, arch, line.substring(13, line.length() - 1));
        }
        return new OsInfo(name, version, arch, lineToReturn);
    }

    private OsInfo getPlatformNameFromOsRelease(String name, String version, String arch) {
        String fileName = "/etc/os-release";
        File f = new File(fileName);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                return this.readPlatformNameFromOsRelease(name, version, arch, br);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private OsInfo readPlatformNameFromOsRelease(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribName = "Linux";
        Object distribVersion = "";
        String distribId = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("NAME=")) {
                distribName = line.replace("NAME=", "").replace("\"", "");
            }
            if (line.startsWith("VERSION=")) {
                distribVersion = line.replace("VERSION=", "").replace("\"", "") + " ";
            }
            if (!line.startsWith("ID=")) continue;
            distribId = line.replace("ID=", "").replace("\"", "");
        }
        if (distribId != null) {
            return new OsInfo(name, version, arch, distribName + " " + (String)distribVersion + "(" + distribId + ")");
        }
        return null;
    }

    private OsInfo getPlatformNameFromLsbRelease(String name, String version, String arch) {
        String fileName = "/etc/lsb-release";
        File f = new File(fileName);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                return this.readPlatformNameFromLsb(name, version, arch, br);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    OsInfo readPlatformNameFromLsb(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribDescription = null;
        String distribCodename = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("DISTRIB_DESCRIPTION")) {
                distribDescription = line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "");
            }
            if (!line.startsWith("DISTRIB_CODENAME")) continue;
            distribCodename = line.replace("DISTRIB_CODENAME=", "");
        }
        if (distribDescription != null && distribCodename != null) {
            return new OsInfo(name, version, arch, distribDescription + " (" + distribCodename + ")");
        }
        return null;
    }

    public String getShellExtension() {
        if (this.isWindows()) {
            return ".bat";
        }
        if (this.isPosix().booleanValue()) {
            return ".sh";
        }
        throw new RuntimeException("Can not detect OS");
    }

    public boolean isWindows() {
        return this.osInfo.isWindows();
    }

    public boolean isMac() {
        return this.osInfo.isMac();
    }

    public boolean isUnix() {
        return this.osInfo.isUnix();
    }

    public Boolean isPosix() {
        return this.osInfo.isMac() || this.osInfo.isUnix();
    }

    static {
        MAC_OS = new HashMap<String, String>();
        DARWIN = new HashMap<Integer, String>();
        UNIX = new ArrayList<String>();
        MAC_OS.put("10.0", "Puma");
        MAC_OS.put("10.1", "Cheetah");
        MAC_OS.put("10.2", "Jaguar");
        MAC_OS.put("10.3", "Panther");
        MAC_OS.put("10.4", "Tiger");
        MAC_OS.put("10.5", "Leopard");
        MAC_OS.put("10.6", "Snow Leopard");
        MAC_OS.put("10.7", "Lion");
        MAC_OS.put("10.8", "Mountain Lion");
        MAC_OS.put("10.9", "Mavericks");
        MAC_OS.put("10.10", "Yosemite");
        MAC_OS.put("10.11", "El Captain");
        MAC_OS.put("10.12", "Sierra");
        MAC_OS.put("10.13", "High Sierra");
        MAC_OS.put("10.14", "Mojave");
        MAC_OS.put("10.15", "Catalina");
        MAC_OS.put("10.16", "Big Sur");
        MAC_OS.put("11", "Big Sur");
        MAC_OS.put("12", "Monterey");
        MAC_OS.put("13", "Ventura");
        DARWIN.put(5, "Puma");
        DARWIN.put(6, "Jaguar");
        DARWIN.put(7, "Panther");
        DARWIN.put(8, "Tiger");
        DARWIN.put(9, "Leopard");
        DARWIN.put(10, "Snow Leopard");
        DARWIN.put(11, "Lion");
        DARWIN.put(12, "Mountain Lion");
        DARWIN.put(13, "Mavericks");
        DARWIN.put(14, "Yosemite");
        DARWIN.put(15, "El Captain");
        DARWIN.put(16, "Sierra");
        DARWIN.put(17, "High Sierra");
        DARWIN.put(18, "Mojave");
        DARWIN.put(19, "Catalina");
        UNIX.addAll(Arrays.asList("Linux", "SunOS", "FreeBSD", "AIX"));
        OS = new OS();
    }

    static class OsInfo {
        private String name;
        private String arch;
        private String version;
        private String platformName;

        private OsInfo(String name, String version, String arch, String platformName) {
            this.name = name;
            this.arch = arch;
            this.version = version;
            this.platformName = platformName;
        }

        public String getName() {
            return this.name;
        }

        public String getArch() {
            return this.arch;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatformName() {
            return this.platformName;
        }

        public boolean isWindows() {
            return this.name != null && this.name.contains("Win");
        }

        public boolean isMac() {
            return this.name != null && this.name.contains("Mac");
        }

        public boolean isUnix() {
            return this.name != null && (this.name.contains("nix") || this.name.contains("nux") || this.name.contains("AIX") || this.name.contains("FreeBSD"));
        }
    }

    private static class SingletonHolder {
        private static final OS instance = new OS();

        private SingletonHolder() {
        }
    }
}

