/*
 * Decompiled with CFR 0.152.
 */
package daevil;

import daevil.Daevil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourceUtil {
    static void copyResourcesReplaceTokens(String path, Path dest, Map<String, String> tokens, boolean recurse, String include, String replaceAll) {
        if (!dest.toFile().exists() && !dest.toFile().mkdirs()) {
            Daevil.log.error("Could not create directory: " + dest.toAbsolutePath());
        }
        try {
            Consumer<Path> pathConsumer = resourcePath -> {
                String fileName = resourcePath.toString().substring(resourcePath.toString().lastIndexOf(47) + 1);
                if (!Files.isDirectory(resourcePath, new LinkOption[0]) && fileName.matches(include)) {
                    ResourceUtil.copyPathReplaceTokens(resourcePath, Paths.get(dest.toString(), fileName), tokens);
                } else if (Files.isDirectory(resourcePath, new LinkOption[0]) && recurse) {
                    Path childPath = Paths.get(dest.toString(), fileName);
                    if (!Files.exists(childPath, new LinkOption[0]) && !childPath.toFile().mkdirs()) {
                        Daevil.log.error("Could not create directory: " + childPath.toAbsolutePath());
                    }
                    ResourceUtil.copyResourcesReplaceTokens(path + "/" + fileName, childPath, tokens, recurse, include, replaceAll);
                }
            };
            ResourceUtil.processResource(Daevil.class.getResource(path).toURI(), patth -> {
                try (Stream<Path> stream = Files.list(patth);){
                    stream.forEach(pathConsumer);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void copyResources(String path, Path dest, String include, String replaceAll) {
        URI uri;
        URL pathResource;
        if (!dest.toFile().exists() && !dest.toFile().mkdirs()) {
            Daevil.log.error("Could not create directory: " + dest.toAbsolutePath());
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if ((pathResource = Daevil.class.getResource((String)path)) == null) {
            throw new IllegalArgumentException("path not found: " + (String)path);
        }
        try {
            uri = pathResource.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("unable to get URI: " + e.getMessage());
        }
        Consumer<Path> pathConsumer = resourcePath -> {
            String fileName = resourcePath.toString().substring(resourcePath.toString().lastIndexOf(47) + 1);
            if (!Files.isDirectory(resourcePath, new LinkOption[0]) && fileName.matches(include)) {
                Path destPath;
                if (replaceAll != null && !replaceAll.trim().isEmpty()) {
                    fileName = fileName.replaceAll(replaceAll.split(",")[0], replaceAll.split(",")[1]);
                }
                if (Files.exists(destPath = Paths.get(dest.toString(), fileName), new LinkOption[0])) {
                    Daevil.log.error("File exists: " + destPath.toAbsolutePath());
                } else {
                    Daevil.log.debug("Copying " + resourcePath + " to " + destPath.toAbsolutePath());
                    try {
                        Files.copy(resourcePath, destPath, new CopyOption[0]);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    if (fileName.endsWith(".sh")) {
                        ResourceUtil.markExecutable(destPath);
                    }
                }
            }
        };
        try {
            ResourceUtil.processResource(uri, resourcePath -> {
                try (Stream<Path> stream = Files.list(resourcePath);){
                    stream.forEach(pathConsumer);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void copyPathReplaceTokens(Path source, Path dest, Map<String, String> tokens) {
        Daevil.log.debug("Copy/Replacing " + source + " to " + dest.toAbsolutePath());
        try (Stream<String> lines = Files.lines(source);){
            List replaced = lines.map(line -> ResourceUtil.replaceTokens(line, tokens)).collect(Collectors.toList());
            Files.write(dest, replaced, new OpenOption[0]);
            if (dest.toString().endsWith(".sh")) {
                ResourceUtil.markExecutable(dest);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static String replaceTokens(String string, Map<String, String> tokens) {
        List<String> msg = Arrays.asList(string);
        "@#".chars().forEach(delimiter -> tokens.forEach((key, value) -> {
            value = value == null ? "" : value;
            msg.set(0, ((String)msg.get(0)).replace((char)delimiter + key + (char)delimiter, (CharSequence)value));
        }));
        return msg.get(0);
    }

    private static void processResource(URI uri, Daevil.IOConsumer<Path> action) throws IOException {
        try {
            Path p = Paths.get(uri);
            action.accept(p);
        }
        catch (FileSystemNotFoundException ex) {
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                Path p = fs.provider().getPath(uri);
                action.accept(p);
            }
        }
    }

    public static String getInputAsString(InputStream is) {
        try (Scanner s = new Scanner(is);){
            Scanner useDelimiter = s.useDelimiter("\\A");
            try {
                String string;
                String string2 = string = useDelimiter.hasNext() ? s.next() : "";
                if (useDelimiter != null) {
                    useDelimiter.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (useDelimiter != null) {
                    try {
                        useDelimiter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static void markExecutable(Path path) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        try {
            Daevil.log.debug("Marking executable: " + path);
            Files.setPosixFilePermissions(path, perms);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

