/*
 * Decompiled with CFR 0.152.
 */
package daevil.iconexe;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WriteBMP32 {
    private WriteBMP32() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(BufferedImage img, File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        try {
            BufferedOutputStream out = new BufferedOutputStream(fout);
            WriteBMP32.write(img, out);
            out.flush();
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(BufferedImage img, OutputStream os) throws IOException {
        InfoHeader ih = WriteBMP32.createInfoHeader(img);
        int mapSize = 0;
        IndexColorModel icm = null;
        if (ih.sBitCount <= 8) {
            icm = (IndexColorModel)img.getColorModel();
            mapSize = icm.getMapSize();
        }
        int headerSize = 14 + ih.iSize;
        int mapBytes = 4 * mapSize;
        int dataOffset = headerSize + mapBytes;
        int bytesPerLine = 0;
        switch (ih.sBitCount) {
            case 1: {
                bytesPerLine = WriteBMP32.getBytesPerLine1(ih.iWidth);
                break;
            }
            case 4: {
                bytesPerLine = WriteBMP32.getBytesPerLine4(ih.iWidth);
                break;
            }
            case 8: {
                bytesPerLine = WriteBMP32.getBytesPerLine8(ih.iWidth);
                break;
            }
            case 24: {
                bytesPerLine = WriteBMP32.getBytesPerLine24(ih.iWidth);
                break;
            }
            case 32: {
                bytesPerLine = ih.iWidth * 4;
            }
        }
        int fileSize = dataOffset + bytesPerLine * ih.iHeight;
        LittleEndianOutputStream out = new LittleEndianOutputStream(os);
        WriteBMP32.writeFileHeader(fileSize, dataOffset, out);
        ih.write(out);
        if (ih.sBitCount <= 8) {
            WriteBMP32.writeColorMap(icm, out);
        }
        switch (ih.sBitCount) {
            case 1: {
                WriteBMP32.write1(img.getRaster(), out);
                break;
            }
            case 4: {
                WriteBMP32.write4(img.getRaster(), out);
                break;
            }
            case 8: {
                WriteBMP32.write8(img.getRaster(), out);
                break;
            }
            case 24: {
                WriteBMP32.write24(img.getRaster(), out);
                break;
            }
            case 32: {
                WriteBMP32.write32(img.getRaster(), img.getAlphaRaster(), out);
            }
        }
    }

    public static InfoHeader createInfoHeader(BufferedImage img) {
        InfoHeader ret = new InfoHeader();
        ret.iColorsImportant = 0;
        ret.iColorsUsed = 0;
        ret.iCompression = 0;
        ret.iHeight = img.getHeight();
        ret.iWidth = img.getWidth();
        ret.sBitCount = (short)img.getColorModel().getPixelSize();
        ret.iNumColors = 1 << (ret.sBitCount == 32 ? 24 : (int)ret.sBitCount);
        ret.iImageSize = 0;
        return ret;
    }

    public static void writeFileHeader(int fileSize, int dataOffset, LittleEndianOutputStream out) throws IOException {
        byte[] signature = "BM".getBytes("UTF-8");
        out.write(signature);
        out.writeIntLE(fileSize);
        out.writeIntLE(0);
        out.writeIntLE(dataOffset);
    }

    public static void writeColorMap(IndexColorModel icm, LittleEndianOutputStream out) throws IOException {
        int mapSize = icm.getMapSize();
        for (int i = 0; i < mapSize; ++i) {
            int rgb = icm.getRGB(i);
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            out.writeByte(b);
            out.writeByte(g);
            out.writeByte(r);
            out.writeByte(0);
        }
    }

    public static int getBytesPerLine1(int width) {
        int ret = width / 8;
        if (ret * 8 < width) {
            ++ret;
        }
        if (ret % 4 != 0) {
            ret = (ret / 4 + 1) * 4;
        }
        return ret;
    }

    public static int getBytesPerLine4(int width) {
        int ret = width / 2;
        if (ret % 4 != 0) {
            ret = (ret / 4 + 1) * 4;
        }
        return ret;
    }

    public static int getBytesPerLine8(int width) {
        int ret = width;
        if (ret % 4 != 0) {
            ret = (ret / 4 + 1) * 4;
        }
        return ret;
    }

    public static int getBytesPerLine24(int width) {
        int ret = width * 3;
        if (ret % 4 != 0) {
            ret = (ret / 4 + 1) * 4;
        }
        return ret;
    }

    public static int getBitmapSize(int w, int h, int bpp) {
        int bytesPerLine = 0;
        switch (bpp) {
            case 1: {
                bytesPerLine = WriteBMP32.getBytesPerLine1(w);
                break;
            }
            case 4: {
                bytesPerLine = WriteBMP32.getBytesPerLine4(w);
                break;
            }
            case 8: {
                bytesPerLine = WriteBMP32.getBytesPerLine8(w);
                break;
            }
            case 24: {
                bytesPerLine = WriteBMP32.getBytesPerLine24(w);
                break;
            }
            case 32: {
                bytesPerLine = w * 4;
            }
        }
        int ret = bytesPerLine * h;
        return ret;
    }

    public static void write1(Raster raster, LittleEndianOutputStream out) throws IOException {
        int bytesPerLine = WriteBMP32.getBytesPerLine1(raster.getWidth());
        byte[] line = new byte[bytesPerLine];
        for (int y = raster.getHeight() - 1; y >= 0; --y) {
            for (int i = 0; i < bytesPerLine; ++i) {
                line[i] = 0;
            }
            for (int x = 0; x < raster.getWidth(); ++x) {
                int bi = x / 8;
                int i = x % 8;
                int index = raster.getSample(x, y, 0);
                line[bi] = WriteBMP32.setBit(line[bi], i, index);
            }
            out.write(line);
        }
    }

    public static void write4(Raster raster, LittleEndianOutputStream out) throws IOException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        int bytesPerLine = WriteBMP32.getBytesPerLine4(width);
        byte[] line = new byte[bytesPerLine];
        for (int y = height - 1; y >= 0; --y) {
            for (int i = 0; i < bytesPerLine; ++i) {
                line[i] = 0;
            }
            for (int x = 0; x < width; ++x) {
                int bi = x / 2;
                int i = x % 2;
                int index = raster.getSample(x, y, 0);
                line[bi] = WriteBMP32.setNibble(line[bi], i, index);
            }
            out.write(line);
        }
    }

    public static void write8(Raster raster, LittleEndianOutputStream out) throws IOException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        int bytesPerLine = WriteBMP32.getBytesPerLine8(width);
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int index = raster.getSample(x, y, 0);
                out.writeByte(index);
            }
            for (int i = width; i < bytesPerLine; ++i) {
                out.writeByte(0);
            }
        }
    }

    public static void write24(Raster raster, LittleEndianOutputStream out) throws IOException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        int bytesPerLine = WriteBMP32.getBytesPerLine24(width);
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int r = raster.getSample(x, y, 0);
                int g = raster.getSample(x, y, 1);
                int b = raster.getSample(x, y, 2);
                out.writeByte(b);
                out.writeByte(g);
                out.writeByte(r);
            }
            for (int i = width * 3; i < bytesPerLine; ++i) {
                out.writeByte(0);
            }
        }
    }

    public static void write32(Raster raster, Raster alpha, LittleEndianOutputStream out) throws IOException {
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int r = raster.getSample(x, y, 0);
                int g = raster.getSample(x, y, 1);
                int b = raster.getSample(x, y, 2);
                int a = alpha.getSample(x, y, 0);
                out.writeByte(b);
                out.writeByte(g);
                out.writeByte(r);
                out.writeByte(a);
            }
        }
    }

    private static byte setBit(byte bits, int index, int bit) {
        bits = bit == 0 ? (byte)(bits & ~(1 << 7 - index)) : (byte)(bits | 1 << 7 - index);
        return bits;
    }

    private static byte setNibble(byte nibbles, int index, int nibble) {
        nibbles = (byte)(nibbles | nibble << (1 - index) * 4);
        return nibbles;
    }

    public static int getColorMapSize(short sBitCount) {
        int ret = 0;
        if (sBitCount <= 8) {
            ret = (1 << sBitCount) * 4;
        }
        return ret;
    }

    public static class LittleEndianOutputStream
    extends DataOutputStream {
        public LittleEndianOutputStream(OutputStream out) {
            super(out);
        }

        public static short swapShort(short value) {
            return (short)((value & 0xFF00) >> 8 | (value & 0xFF) << 8);
        }

        public static int swapInteger(int value) {
            return (value & 0xFF000000) >> 24 | (value & 0xFF0000) >> 8 | (value & 0xFF00) << 8 | (value & 0xFF) << 24;
        }

        public static long swapLong(long value) {
            return (value & 0xFF00000000000000L) >> 56 | (value & 0xFF000000000000L) >> 40 | (value & 0xFF0000000000L) >> 24 | (value & 0xFF00000000L) >> 8 | (value & 0xFF000000L) << 8 | (value & 0xFF0000L) << 24 | (value & 0xFF00L) << 40 | (value & 0xFFL) << 56;
        }

        public static float swapFloat(float value) {
            int i = Float.floatToIntBits(value);
            i = LittleEndianOutputStream.swapInteger(i);
            return Float.intBitsToFloat(i);
        }

        public static double swapDouble(double value) {
            long l = Double.doubleToLongBits(value);
            l = LittleEndianOutputStream.swapLong(l);
            return Double.longBitsToDouble(l);
        }

        public static String toHexString(int i, boolean littleEndian, int bytes) {
            if (littleEndian) {
                i = LittleEndianOutputStream.swapInteger(i);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(i));
            if (sb.length() % 2 != 0) {
                sb.insert(0, '0');
            }
            while (sb.length() < bytes * 2) {
                sb.insert(0, "00");
            }
            return sb.toString();
        }

        public static StringBuilder toCharString(StringBuilder sb, int i, int bytes, char def) {
            int shift = 24;
            for (int j = 0; j < bytes; ++j) {
                int b = i >> shift & 0xFF;
                char c = b < 32 ? def : (char)b;
                sb.append(c);
                shift -= 8;
            }
            return sb;
        }

        public static String toInfoString(int info) {
            StringBuilder sb = new StringBuilder();
            sb.append("Decimal: ").append(info);
            sb.append(", Hex BE: ").append(LittleEndianOutputStream.toHexString(info, false, 4));
            sb.append(", Hex LE: ").append(LittleEndianOutputStream.toHexString(info, true, 4));
            sb.append(", String BE: [");
            sb = LittleEndianOutputStream.toCharString(sb, info, 4, '.');
            sb.append(']');
            sb.append(", String LE: [");
            sb = LittleEndianOutputStream.toCharString(sb, LittleEndianOutputStream.swapInteger(info), 4, '.');
            sb.append(']');
            return sb.toString();
        }

        public void writeShortLE(short value) throws IOException {
            value = LittleEndianOutputStream.swapShort(value);
            super.writeShort(value);
        }

        public void writeIntLE(int value) throws IOException {
            value = LittleEndianOutputStream.swapInteger(value);
            super.writeInt(value);
        }

        public void writeFloatLE(float value) throws IOException {
            value = LittleEndianOutputStream.swapFloat(value);
            super.writeFloat(value);
        }

        public void writeLongLE(long value) throws IOException {
            value = LittleEndianOutputStream.swapLong(value);
            super.writeLong(value);
        }

        public void writeDoubleLE(double value) throws IOException {
            value = LittleEndianOutputStream.swapDouble(value);
            super.writeDouble(value);
        }

        public void writeUnsignedInt(long value) throws IOException {
            int i1 = (int)(value >> 24);
            int i2 = (int)(value >> 16 & 0xFFL);
            int i3 = (int)(value >> 8 & 0xFFL);
            int i4 = (int)(value & 0xFFL);
            this.write(i1);
            this.write(i2);
            this.write(i3);
            this.write(i4);
        }

        public void writeUnsignedIntLE(long value) throws IOException {
            int i1 = (int)(value >> 24);
            int i2 = (int)(value >> 16 & 0xFFL);
            int i3 = (int)(value >> 8 & 0xFFL);
            int i4 = (int)(value & 0xFFL);
            this.write(i4);
            this.write(i3);
            this.write(i2);
            this.write(i1);
        }
    }

    public static class InfoHeader {
        public int iSize;
        public int iWidth;
        public int iHeight;
        public short sPlanes;
        public short sBitCount;
        public int iCompression;
        public int iImageSize;
        public int iXpixelsPerM;
        public int iYpixelsPerM;
        public int iColorsUsed;
        public int iColorsImportant;
        public int iNumColors;

        public InfoHeader() {
            this.iSize = 40;
            this.iWidth = 0;
            this.iHeight = 0;
            this.sPlanes = 1;
            this.sBitCount = 0;
            this.iNumColors = 0;
            this.iCompression = 0;
            this.iImageSize = 0;
            this.iXpixelsPerM = 0;
            this.iYpixelsPerM = 0;
            this.iColorsUsed = 0;
            this.iColorsImportant = 0;
        }

        public InfoHeader(InfoHeader source) {
            this.iColorsImportant = source.iColorsImportant;
            this.iColorsUsed = source.iColorsUsed;
            this.iCompression = source.iCompression;
            this.iHeight = source.iHeight;
            this.iWidth = source.iWidth;
            this.iImageSize = source.iImageSize;
            this.iNumColors = source.iNumColors;
            this.iSize = source.iSize;
            this.iXpixelsPerM = source.iXpixelsPerM;
            this.iYpixelsPerM = source.iYpixelsPerM;
            this.sBitCount = source.sBitCount;
            this.sPlanes = source.sPlanes;
        }

        public void write(LittleEndianOutputStream out) throws IOException {
            out.writeIntLE(this.iSize);
            out.writeIntLE(this.iWidth);
            out.writeIntLE(this.iHeight);
            out.writeShortLE(this.sPlanes);
            out.writeShortLE(this.sBitCount);
            out.writeIntLE(this.iCompression);
            out.writeIntLE(this.iImageSize);
            out.writeIntLE(this.iXpixelsPerM);
            out.writeIntLE(this.iYpixelsPerM);
            out.writeIntLE(this.iColorsUsed);
            out.writeIntLE(this.iColorsImportant);
        }
    }
}

