/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu;

import daevil.OSType;
import daevil.menu.BatchFileBuilder;
import daevil.menu.MenuOption;
import daevil.menu.dependency.JavaResolver;
import daevil.menu.dependency.Resolver;
import daevil.property.Property;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Menu {
    List<MenuOption> _options;
    int optionCount = 0;
    List<Resolver> resolvers;
    private String _title;
    public final Property<String> title = Property.get(() -> this._title).set(value -> {
        this._title = value;
        return this._title;
    });
    private String _fileName;
    public final Property<String> fileName = Property.get(() -> this._fileName).set(value -> {
        this._fileName = value;
        return this._fileName;
    });

    public Menu(String title) {
        this._options = new ArrayList<MenuOption>();
        this.resolvers = new ArrayList<Resolver>();
        this.title.set(title);
        this.fileName.set(this.safeName(title));
    }

    public Menu(String title, List<MenuOption> options) {
        this(title);
        this._options = options;
    }

    public List<Resolver> resolvers() {
        return this.resolvers;
    }

    public Menu resolvers(List<Resolver> resolvers) {
        this.resolvers = resolvers;
        return this;
    }

    public Menu resolver(Resolver resolver) {
        this.resolvers.add(resolver);
        return this;
    }

    public JavaResolver javaResolver() {
        JavaResolver resolver = new JavaResolver(this);
        this.resolver(resolver);
        return resolver;
    }

    String safeName(String name) {
        return name.replace("-", "_").replace(".", "_");
    }

    public Menu addOption(MenuOption option) {
        if (this.getOption(option.name.get()) != null) {
            throw new RuntimeException("Each option must be unique, duplicate: " + option.name.get());
        }
        if (!option.name.get().equals("separator")) {
            ++this.optionCount;
            option.number.set(this.optionCount);
        }
        this.options().add(option);
        return this;
    }

    public Menu title(String title) {
        this._title = title;
        return this;
    }

    public List<MenuOption> options() {
        return this._options;
    }

    public Menu options(List<MenuOption> options) {
        this._options = options;
        return this;
    }

    public Menu addOption(String name, String description, String command) {
        MenuOption option = new MenuOption(this, name, description, command);
        return this.addOption(option);
    }

    public MenuOption getOption(String optionName) {
        List found = this.options().stream().filter(menuOption -> menuOption.name.get() == optionName).collect(Collectors.toList());
        if (found.size() > 0) {
            return (MenuOption)found.get(0);
        }
        return null;
    }

    public Menu addOption(String name, String description, String ... command) {
        MenuOption option = new MenuOption(this, name, description, String.join((CharSequence)"\n", command));
        return this.addOption(option);
    }

    public List<Path> generate(Path dest) {
        ArrayList<Path> paths = new ArrayList<Path>();
        String script = this.generate();
        try {
            Files.write(dest, script.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        paths.add(dest);
        return paths;
    }

    public String generate() {
        return this.displayCommands(OSType.ANY);
    }

    public String displayCommands(OSType osType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.title.get()).append('\n');
        this.resolvers().forEach(resolver -> System.out.println("Resolver: " + resolver.getClass().getName() + "\n"));
        this._options.forEach(option -> {
            sb.append(option.number.get()).append(") ").append(option.name.get()).append(" Description: ").append(option.description.get()).append('\n');
            option.commandsish(osType).forEach(command -> sb.append("   Command: ").append((String)command).append('\n'));
        });
        return sb.toString();
    }

    String usageString(String suffix, String usageSeparator) {
        StringBuilder sb = new StringBuilder(suffix);
        this._options.forEach(option -> {
            if (!option.name.get().equals("separator")) {
                sb.append(option.name.get()).append(usageSeparator);
            }
        });
        return sb.toString().substring(0, sb.length() - 1) + "]";
    }

    public String generateResolverText(OSType osType) {
        StringBuilder resolverText = new StringBuilder();
        this.resolvers().forEach(resolver -> System.out.println("Resolver: " + resolver.getClass().getName()));
        this.resolvers().forEach(resolver -> resolverText.append(resolver.generate(osType)));
        return resolverText.append('\n').toString();
    }

    public abstract BatchFileBuilder batchFileBuilder();
}

