/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu;

import daevil.Daevil;
import daevil.OSType;
import daevil.menu.Menu;
import daevil.property.Property;
import daevil.term.ProcessResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MenuOption {
    Map<OSType, List<String>> osCommands;
    private Menu menu;
    private String _name;
    public final Property<String> name = Property.get(() -> this._name).set(value -> {
        this._name = value;
        return this._name;
    });
    private String _description;
    public final Property<String> description = Property.get(() -> this._description).set(value -> {
        this._description = value;
        return this._description;
    });
    private Integer _number;
    public final Property<Integer> number = Property.get(() -> this._number).set(value -> {
        this._number = value;
        return this._number;
    });

    MenuOption(Menu menu) {
        this.menu = menu;
    }

    MenuOption(Menu menu, String name, String description) {
        this.menu = menu;
        this.name.set(name);
        this.description.set(description);
        this.osCommands = new LinkedHashMap<OSType, List<String>>();
    }

    MenuOption(Menu menu, String name, String description, String command) {
        this.menu = menu;
        this.name.set(name);
        this.description.set(description);
        this.osCommands = new LinkedHashMap<OSType, List<String>>();
        this.command(command);
    }

    MenuOption(Menu menu, String name, String description, Map<OSType, List<String>> osCommands) {
        this.menu = menu;
        this.name.set(name);
        this.description.set(description);
        this.osCommands = osCommands;
    }

    public List<String> commandsish(OSType osType) {
        ArrayList<String> matched = new ArrayList<String>();
        this.osCommands.forEach((aClass, strings) -> {
            if (aClass.typeOf(osType)) {
                matched.addAll((Collection<String>)strings);
            }
        });
        if (matched.size() == 0 && osType.typeOf(OSType.NIX)) {
            this.osCommands.forEach((aClass, strings) -> {
                if (aClass == OSType.NIX) {
                    matched.addAll((Collection<String>)strings);
                }
            });
        }
        return matched;
    }

    public List<String> commands(OSType osType) {
        this.osCommands.computeIfAbsent(osType, k -> new ArrayList());
        return this.osCommands.get((Object)osType);
    }

    public String commandLines(OSType osType) {
        this.osCommands.computeIfAbsent(osType, k -> new ArrayList());
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.osCommands.get((Object)osType));
    }

    public MenuOption command(String command) {
        return this.command(OSType.ANY, command);
    }

    public MenuOption command(OSType osType, String command) {
        this.commands(osType).add(command);
        return this;
    }

    public List<ProcessResult> execute(OSType osType, boolean haltOnFailure) {
        return this.execute(osType, 120, haltOnFailure);
    }

    public List<ProcessResult> execute(OSType osType, int timeoutSeconds, boolean haltOnFailure) {
        List<String> commands = this.commandsish(osType);
        ArrayList<ProcessResult> results = new ArrayList<ProcessResult>();
        if (commands.size() == 0) {
            Daevil.log.error("No commands to run for osType: " + osType);
        }
        commands.forEach(command -> results.add(osType.execute((String)command, null, null, timeoutSeconds, haltOnFailure)));
        return results;
    }
}

