/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu;

import daevil.Daevil;
import daevil.OSType;
import daevil.ResourceUtil;
import daevil.menu.BashMenu;
import daevil.menu.BatchFileBuilder;
import daevil.menu.BatchFileMenu;
import daevil.menu.Menu;
import daevil.menu.MenuOption;
import daevil.menu.dependency.Resolver;
import daevil.term.ProcessResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiOSMenu
extends Menu {
    private Map<OSType, Menu> menus = new HashMap<OSType, Menu>();

    public MultiOSMenu(String title) {
        super(title);
    }

    public MenuOption addOption(String name, String description) {
        MenuOption option = new MenuOption(this, name, description);
        this.addOption(option);
        return option;
    }

    @Override
    public Menu addOption(String name, String description, String command) {
        MenuOption option = new MenuOption(this, name, description);
        option.command(OSType.ANY, command);
        return this.addOption(option);
    }

    @Override
    public Menu addOption(String name, String description, String ... command) {
        MenuOption option = new MenuOption(this, name, description);
        Arrays.stream(command).forEach(cmd -> option.command(OSType.ANY, (String)cmd));
        return this.addOption(option);
    }

    @Override
    public String generate() {
        return this.menu(OSType.host()).generate();
    }

    public String generate(OSType osType) {
        return this.menu(osType).generate();
    }

    public Menu menu(OSType osType) {
        if (!osType.typeOf(OSType.NIX) && !osType.typeOf(OSType.WINDOWS)) {
            throw new IllegalArgumentException("OSType is of unknown kind: " + osType);
        }
        OSType superType = osType.typeOf(OSType.NIX) ? OSType.NIX : OSType.WINDOWS;
        Menu menu = this.menus.get((Object)superType);
        if (menu == null) {
            menu = superType == OSType.NIX ? new BashMenu((String)this.title.get(), this._options).resolvers(this.resolvers) : new BatchFileMenu((String)this.title.get(), this._options).resolvers(this.resolvers);
        }
        if (superType == OSType.WINDOWS && !((String)this.fileName.get()).toLowerCase().endsWith(".bat")) {
            this.fileName.set((String)this.fileName.get() + ".bat");
        }
        menu.title((String)((String)this.title.get())).options((List<MenuOption>)this._options).resolvers((List<Resolver>)this.resolvers).fileName.set((String)this.fileName.get());
        this.menus.put(superType, menu);
        return menu;
    }

    public Path generate(OSType osType, Path toDirectory) {
        if (!toDirectory.toFile().exists()) {
            toDirectory.toFile().mkdir();
        }
        Path filePath = Paths.get(toDirectory.toString(), (String)this.fileName.get());
        try {
            Daevil.log.info("Generating " + osType + ":" + filePath);
            Files.write(filePath, this.generate(osType).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (osType.typeOf(OSType.NIX)) {
            ResourceUtil.markExecutable(filePath);
        }
        return filePath;
    }

    @Override
    public List<Path> generate(Path path) {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.generate(OSType.NIX, path));
        paths.add(this.generate(OSType.WINDOWS, path));
        return paths;
    }

    public ProcessResult execute(Path path, Map<String, String> input) {
        return this.execute(path, OSType.host(), input);
    }

    public ProcessResult execute(Path path, OSType osType, Map<String, String> input) {
        this.generate(osType, path);
        path = Paths.get(path.toAbsolutePath().toString(), (String)this.fileName.get());
        Daevil.log.debug("Executing: " + path);
        return osType.execute(path.toString(), null, input, 10, false);
    }

    public ProcessResult executeResolvers(Path path, OSType osType) {
        try {
            Daevil.log.info("Generating resolver script: " + path);
            Files.write(path, this.generateResolverText(osType).getBytes(), new OpenOption[0]);
            String scriptPath = osType == OSType.WINDOWS ? "resolvers.bat" : "resolvers";
            path = Paths.get(path.toAbsolutePath().toString(), scriptPath);
            Daevil.log.debug("Executing: " + path);
            return osType.execute(path.toString(), null, null, 10, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public BatchFileBuilder batchFileBuilder() {
        return this.menu(OSType.WINDOWS).batchFileBuilder();
    }
}

