/*
 * Decompiled with CFR 0.152.
 */
package daevil.property;

import daevil.property.ExceptionalSupplier;
import daevil.property.Exceptions;
import daevil.property.Named;
import daevil.property.Property;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class GuessesName<T>
extends Property<T>
implements Named<T> {
    private String declaringClassName;
    private int declaringLineNumber;

    GuessesName(Supplier<T> getter, Function<T, T> setter) {
        super(getter, setter);
        this.recordPosition();
    }

    private void recordPosition() {
        int expectedDepth = 3;
        StackTraceElement stackTraceElement = new Throwable().fillInStackTrace().getStackTrace()[expectedDepth];
        this.declaringClassName = stackTraceElement.getClassName();
        this.declaringLineNumber = stackTraceElement.getLineNumber();
    }

    private Object createInstanceOfDeclarer() {
        Class cls = Exceptions.unchecked(() -> Class.forName(this.declaringClassName));
        return Exceptions.unchecked(cls::newInstance);
    }

    private String guessName() {
        Class cls = Exceptions.unchecked(() -> Class.forName(this.declaringClassName));
        Object o = this.createInstanceOfDeclarer();
        Optional<Field> field = Arrays.asList(cls.getDeclaredFields()).stream().peek(f -> f.setAccessible(true)).filter(f -> f.getType().isAssignableFrom(GuessesName.class)).filter(f -> Exceptions.unchecked((ExceptionalSupplier<GuessesName, E>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$guessName$4(java.lang.reflect.Field java.lang.Object ), ()Ldaevil/property/GuessesName;)((Field)f, (Object)o)).declaringLineNumber == this.declaringLineNumber).findFirst();
        return field.get().getName();
    }

    @Override
    public String name() {
        return this.guessName();
    }

    private static /* synthetic */ GuessesName lambda$guessName$4(Field f, Object o) throws IllegalAccessException {
        return (GuessesName)f.get(o);
    }
}

