/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import java.util.ArrayDeque;
import java.util.Deque;

public abstract class ContentProcessor {
    private final int depth;
    private final String code;
    private final Deque<Mode> stack = new ArrayDeque<Mode>();
    private int startIndex = -1;
    private int endIndex = -1;
    private int lastWrittenIndex = -1;
    private Mode currentMode;
    private int i;

    public ContentProcessor(int depth, String code) {
        this.depth = depth;
        this.code = code;
    }

    public void process() {
        this.push(Mode.Code);
        this.i = 0;
        while (this.i < this.code.length()) {
            if (this.regionMatches("@`") && this.currentMode.isContentBlockAllowed()) {
                if (this.currentMode == Mode.Code) {
                    this.startIndex = this.i + 1;
                }
                this.push(Mode.Content);
            } else if (this.regionMatches("`") && this.currentMode == Mode.Content) {
                this.pop();
                if (this.currentMode == Mode.Code) {
                    this.endIndex = this.i;
                    this.handleContentBlock();
                }
            } else if (this.regionMatches("@raw") && this.currentMode == Mode.Content) {
                this.push(Mode.Raw);
            } else if (this.regionMatches("@endraw") && this.currentMode == Mode.Raw) {
                this.pop();
            }
            ++this.i;
        }
        if (this.lastWrittenIndex + 1 < this.code.length()) {
            this.onRemainingCode(this.code, this.lastWrittenIndex + 1, this.code.length());
        }
    }

    private void push(Mode mode) {
        this.stack.push(mode);
        this.currentMode = mode;
    }

    private void pop() {
        this.stack.pop();
        this.currentMode = this.stack.peek();
    }

    private boolean regionMatches(String s) {
        return this.code.regionMatches(this.i - s.length() + 1, s, 0, s.length());
    }

    private void handleContentBlock() {
        this.onContentBlock(this.depth, this.code, this.lastWrittenIndex, this.startIndex, this.endIndex);
        this.lastWrittenIndex = this.endIndex;
    }

    protected abstract void onContentBlock(int var1, String var2, int var3, int var4, int var5);

    protected abstract void onRemainingCode(String var1, int var2, int var3);

    private static enum Mode {
        Code,
        Content,
        Raw;


        boolean isContentBlockAllowed() {
            return this == Code || this == Content;
        }
    }
}

