/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;

public final class IoUtils {
    private IoUtils() {
    }

    public static String toString(Path file) {
        try {
            byte[] bytes = Files.readAllBytes(file);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static void deleteDirectoryContent(Path directory) {
        Objects.requireNonNull(directory);
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> pathStream = Files.walk(directory, new FileVisitOption[0]);){
            pathStream.filter(d -> d != directory).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isTemplateFile(String name) {
        return name.endsWith(".jte") || name.endsWith(".kte");
    }
}

