/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateConfig;
import gg.jte.compiler.CodeGenerator;
import gg.jte.compiler.LineInfo;
import gg.jte.compiler.TemplateParametersCompleteVisitor;
import gg.jte.compiler.TemplateParserVisitor;
import gg.jte.compiler.TemplateType;
import gg.jte.html.HtmlPolicy;
import gg.jte.html.HtmlPolicyException;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.runtime.StringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TemplateParser {
    private final String templateCode;
    private final TemplateType type;
    private final TemplateParserVisitor visitor;
    private final TemplateConfig config;
    private final ContentType contentType;
    private final HtmlPolicy htmlPolicy;
    private final String[] htmlTags;
    private final boolean trimControlStructures;
    private final boolean htmlCommentsPreserved;
    private final Deque<Mode> stack = new ArrayDeque<Mode>();
    private final Deque<Indent> indentStack = new ArrayDeque<Indent>();
    private final Deque<HtmlTag> htmlStack = new ArrayDeque<HtmlTag>();
    private final CodeResolver codeResolver;
    private Mode currentMode;
    private Mode previousControlStructureTrimmed;
    private List<Mode> initialModes;
    private HtmlTag currentHtmlTag;
    private int depth;
    private boolean paramsComplete;
    private boolean outputPrevented;
    private boolean tagClosed;
    private int i;
    private int startIndex;
    private int endIndex;
    private int lastIndex = 0;
    private int lastLineIndex = 0;
    private int lastTrimmedIndex = -1;
    private char previousChar;
    private char currentChar;

    public TemplateParser(String templateCode, TemplateType type, TemplateParserVisitor visitor, TemplateConfig config) {
        this(templateCode, type, visitor, config, null);
    }

    public TemplateParser(String templateCode, TemplateType type, TemplateParserVisitor visitor, TemplateConfig config, CodeResolver codeResolver) {
        this.templateCode = templateCode;
        this.type = type;
        this.visitor = visitor;
        this.config = config;
        this.contentType = config.contentType;
        this.htmlPolicy = config.htmlPolicy;
        this.htmlTags = config.htmlTags;
        this.trimControlStructures = config.trimControlStructures;
        this.htmlCommentsPreserved = config.htmlCommentsPreserved;
        this.startIndex = 0;
        this.endIndex = templateCode.length();
        this.codeResolver = codeResolver;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        this.lastIndex = startIndex;
        this.lastLineIndex = startIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public void setInitialModes(List<Mode> initialModes) {
        this.initialModes = initialModes;
    }

    public void setParamsComplete(boolean paramsComplete) {
        this.paramsComplete = paramsComplete;
    }

    public void parse() {
        this.parse(0);
    }

    public void parse(int startingDepth) {
        try {
            this.doParse(startingDepth);
        }
        catch (HtmlPolicyException e) {
            this.visitor.onError(e.getMessage());
        }
    }

    private void doParse(int startingDepth) {
        this.currentMode = Mode.Text;
        this.stack.push(this.currentMode);
        if (this.initialModes != null) {
            for (Mode initialMode : this.initialModes) {
                this.push(initialMode);
            }
        }
        this.depth = startingDepth;
        this.i = this.startIndex;
        while (this.i < this.endIndex) {
            TemplateCallMode previousMode;
            this.previousChar = this.currentChar;
            this.currentChar = this.templateCode.charAt(this.i);
            if (!this.currentMode.isComment() && this.regionMatches("@import") && this.isParamOrImportAllowed()) {
                this.push(Mode.Import);
                this.lastIndex = this.i + 1;
            } else if (this.currentMode == Mode.Import && this.currentChar == '\n') {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, content) -> this.visitor.onImport(content.trim()));
                this.pop();
                this.lastIndex = this.i + 1;
            } else if (!this.currentMode.isComment() && this.regionMatches("@param") && this.isParamOrImportAllowed()) {
                this.push(Mode.Param);
                this.lastIndex = this.i + 1;
            } else if (this.currentMode == Mode.Param && this.currentChar == '\n') {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, content) -> this.visitor.onParam(content.trim()));
                this.pop();
                this.lastIndex = this.i + 1;
            } else if (this.currentMode == Mode.Text && this.regionMatches("@raw")) {
                this.extractTextPart(this.i - 3, Mode.Raw);
                this.lastIndex = this.i + 1;
                this.push(Mode.Raw);
                this.visitor.onRawStart(this.depth);
            } else if (this.currentMode == Mode.Content && this.regionMatches("@raw")) {
                this.push(Mode.Raw);
            } else if (this.currentMode == Mode.Raw && this.regionMatches("@endraw")) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extractTextPart(this.i - 6, Mode.RawEnd);
                    this.lastIndex = this.i + 1;
                    this.visitor.onRawEnd(this.depth);
                }
            } else if (this.isCommentAllowed() && this.regionMatches("<%--")) {
                this.extractComment(Mode.Comment, this.i - 3);
            } else if (this.isCommentAllowed() && this.regionMatches("<!--") && this.isHtmlCommentAllowed()) {
                this.extractComment(Mode.HtmlComment, this.i - 3);
            } else if (this.isCommentAllowed() && this.regionMatches("/*") && this.isCssCommentAllowed()) {
                this.extractComment(Mode.CssComment, this.i - 1);
            } else if (this.isCommentAllowed() && this.regionMatches("//") && this.isJsCommentAllowed()) {
                this.extractComment(Mode.JsComment, this.i - 1);
            } else if (this.isCommentAllowed() && this.regionMatches("/*") && this.isJsCommentAllowed()) {
                this.extractComment(Mode.JsBlockComment, this.i - 1);
            } else if (this.currentMode == Mode.Comment) {
                if (this.regionMatches("--%>")) {
                    this.pop();
                    this.lastIndex = this.i + 1;
                }
            } else if (this.currentMode == Mode.HtmlComment) {
                if (this.regionMatches("-->")) {
                    this.pop();
                    this.lastIndex = this.i + 1;
                }
            } else if (this.currentMode == Mode.CssComment || this.currentMode == Mode.JsBlockComment) {
                if (this.regionMatches("*/")) {
                    this.pop();
                    this.lastIndex = this.i + 1;
                }
            } else if (this.currentMode == Mode.JsComment) {
                if (this.currentChar == '\n') {
                    this.pop();
                    this.lastIndex = this.i;
                } else if (this.regionMatches("</script>")) {
                    this.pop();
                    this.lastIndex = this.i - 8;
                }
            } else if (this.currentMode == Mode.Text && this.regionMatches("${")) {
                if (!this.outputPrevented) {
                    this.extractTextPart(this.i - 1, Mode.Code);
                    this.lastIndex = this.i + 1;
                }
                this.push(Mode.Code);
            } else if (this.currentMode == Mode.Text && this.regionMatches("$unsafe{")) {
                this.extractTextPart(this.i - 7, Mode.UnsafeCode);
                this.lastIndex = this.i + 1;
                this.push(Mode.UnsafeCode);
            } else if (this.currentMode == Mode.Text && this.regionMatches("!{")) {
                this.extractTextPart(this.i - 1, Mode.CodeStatement);
                this.lastIndex = this.i + 1;
                this.push(Mode.CodeStatement);
            } else if (this.currentChar == '}' && this.currentMode == Mode.CodeStatement) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onCodeStatement);
                    this.lastIndex = this.i + 1;
                }
            } else if (this.currentChar == '\"' && this.currentMode.isTrackStrings()) {
                this.push(Mode.JavaCodeString);
            } else if (this.currentChar == '\"' && this.currentMode == Mode.JavaCodeString && this.previousChar != '\\') {
                this.pop();
            } else if (this.currentChar == '}' && this.currentMode == Mode.Code) {
                this.pop();
                if (this.currentMode == Mode.Text && !this.outputPrevented) {
                    this.extractCodePart();
                }
            } else if (this.currentChar == '}' && this.currentMode == Mode.UnsafeCode) {
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onUnsafeCodePart);
                    this.lastIndex = this.i + 1;
                }
            } else if (this.currentMode == Mode.Text && this.regionMatches("@if")) {
                this.extractTextPart(this.i - 2, Mode.Condition);
                this.lastIndex = this.i + 1;
                this.push(Mode.Condition);
            } else if (this.currentChar == '(' && (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse || this.currentMode == Mode.ForLoop)) {
                this.lastIndex = this.i + 1;
                this.push(new JavaCodeMode(this.currentChar, this.getCurrentTemplateLine()));
            } else if (this.currentMode.isTrackBraces() && (this.currentChar == '(' || this.currentChar == '{')) {
                this.push(new JavaCodeMode(this.currentChar, this.getCurrentTemplateLine()));
            } else if (this.currentMode.isTrackBraces() && (this.currentChar == ')' || this.currentChar == '}')) {
                JavaCodeMode javaCodeMode;
                char closingBrace;
                if (this.currentMode == Mode.JavaCodeParam) {
                    previousMode = this.getPreviousMode(TemplateCallMode.class);
                    this.extract(this.templateCode, this.lastIndex, this.i, (d, c) -> {
                        if (!StringUtils.isBlank(c)) {
                            previousMode.params.add(c);
                        }
                    });
                } else if (this.currentMode instanceof JavaCodeMode && this.currentChar != (closingBrace = (javaCodeMode = (JavaCodeMode)this.currentMode).getClosingBrace())) {
                    this.visitor.onError("Unexpected closing brace " + this.currentChar + ", expected " + closingBrace);
                }
                this.pop();
                if (this.currentMode == Mode.Text) {
                    this.visitor.onError("Unexpected closing brace " + this.currentChar);
                } else if (this.currentMode == Mode.Condition) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onConditionStart);
                    this.lastIndex = this.i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode == Mode.ConditionElse) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onConditionElse);
                    this.lastIndex = this.i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode == Mode.ForLoop) {
                    this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onForLoopStart);
                    this.lastIndex = this.i + 1;
                    this.push(Mode.Text);
                } else if (this.currentMode instanceof TemplateCallMode) {
                    TemplateCallMode templateCallMode = (TemplateCallMode)this.currentMode;
                    if (this.contentType == ContentType.Html && this.currentHtmlTag != null && this.currentHtmlTag.innerTagsIgnored) {
                        this.visitor.onError("Template calls in <" + this.currentHtmlTag.name + "> blocks are not allowed.");
                    }
                    this.extract(this.templateCode, this.lastIndex, this.i, (d, c) -> this.visitor.onTemplateCall(d, templateCallMode.name.toString(), templateCallMode.params));
                    this.lastIndex = this.i + 1;
                    this.pop();
                }
            } else if (this.regionMatches("@`") && this.isContentExpressionAllowed()) {
                this.push(Mode.Content);
            } else if (this.currentChar == '`' && this.currentMode == Mode.Content) {
                this.pop();
            } else if (this.currentChar == ',' && this.currentMode == Mode.JavaCodeParam) {
                previousMode = this.getPreviousMode(TemplateCallMode.class);
                this.extract(this.templateCode, this.lastIndex, this.i, (d, c) -> {
                    if (!StringUtils.isBlank(c)) {
                        previousMode.params.add(c);
                    }
                });
                this.lastIndex = this.i + 1;
            } else if (this.currentMode == Mode.Text && this.regionMatches("@else") && this.nextChar() != 'i') {
                this.extractTextPart(this.i - 4, Mode.ConditionElse);
                this.lastIndex = this.i + 1;
                this.pop();
                this.visitor.onConditionElse(this.depth);
                this.push(Mode.Text);
            } else if (this.currentMode == Mode.Text && this.regionMatches("@elseif")) {
                this.extractTextPart(this.i - 6, Mode.ConditionElse);
                this.lastIndex = this.i + 1;
                this.pop();
                if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
                    this.pop();
                }
                this.push(Mode.ConditionElse);
            } else if (this.currentMode == Mode.Text && this.regionMatches("@endif")) {
                this.extractTextPart(this.i - 5, Mode.ConditionEnd);
                this.lastIndex = this.i + 1;
                this.pop();
                if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
                    this.visitor.onConditionEnd(this.depth);
                    this.pop();
                }
            } else if (this.currentMode == Mode.Text && this.regionMatches("@for")) {
                this.extractTextPart(this.i - 3, Mode.ForLoop);
                this.lastIndex = this.i + 1;
                this.push(Mode.ForLoop);
            } else if (this.currentMode == Mode.Text && this.regionMatches("@endfor")) {
                this.extractTextPart(this.i - 6, Mode.ForLoopEnd);
                this.lastIndex = this.i + 1;
                this.pop();
                if (this.currentMode == Mode.ForLoop) {
                    this.visitor.onForLoopEnd(this.depth);
                    this.pop();
                }
            } else if (this.currentMode == Mode.Text && this.regionMatches("@template.")) {
                TemplateCallMode mode = new TemplateCallMode();
                this.extractTextPart(this.i - 9, mode);
                this.lastIndex = this.i + 1;
                this.push(mode);
                this.push(Mode.TemplateCallName);
            } else if (this.currentMode == Mode.Text && (this.regionMatches("@tag.") || this.regionMatches("@layout."))) {
                String rootDirectory = "jte-root-directory";
                if (this.codeResolver instanceof DirectoryCodeResolver) {
                    rootDirectory = ((DirectoryCodeResolver)this.codeResolver).getRoot().toAbsolutePath().toString().replace("\\", "\\\\");
                }
                this.visitor.onError("@tag and @layout have been replace with @template since jte 2.\nYour templates must be migrated. You can do this automatically by running the following Java code in your project:\n\npublic class Migration {\n    public static void main(String[] args) {\n        gg.jte.migrate.MigrateV1To2.migrateTemplates(java.nio.file.Paths.get(\"" + rootDirectory + "\"));\n    }\n}");
            } else if (this.currentMode == Mode.TemplateCallName) {
                if (this.currentChar == '(') {
                    this.pop();
                    this.push(Mode.JavaCodeParam);
                    this.lastIndex = this.i + 1;
                } else if (this.currentChar != ' ') {
                    this.getPreviousMode(TemplateCallMode.class).name.append(this.currentChar);
                }
            } else if (this.currentMode == Mode.Text && this.contentType == ContentType.Html) {
                this.interceptHtmlTags();
            }
            if (this.currentChar == '\n' && this.currentMode != Mode.Content) {
                this.visitor.onLineFinished();
                this.lastLineIndex = this.i + 1;
            }
            ++this.i;
        }
        if (this.stack.size() > 1) {
            this.handleUnclosedKeywords();
        }
        if (this.lastIndex < this.endIndex) {
            this.extractTextPart(this.endIndex, null);
        }
        if (this.type != TemplateType.Content) {
            this.completeParamsIfRequired();
            this.visitor.onComplete();
        }
    }

    private char nextChar() {
        if (this.i + 1 >= this.templateCode.length()) {
            return '\u0000';
        }
        return this.templateCode.charAt(this.i + 1);
    }

    private boolean regionMatches(String s) {
        return this.templateCode.regionMatches(this.i - s.length() + 1, s, 0, s.length());
    }

    private void handleUnclosedKeywords() {
        while (this.currentMode == Mode.Text) {
            this.pop();
        }
        if (this.currentMode instanceof JavaCodeMode) {
            JavaCodeMode mode = (JavaCodeMode)this.currentMode;
            this.visitor.onError("Missing closing brace " + mode.getClosingBrace(), mode.getTemplateLine());
        } else if (this.currentMode == Mode.Condition || this.currentMode == Mode.ConditionElse) {
            this.visitor.onError("Missing @endif");
        } else if (this.currentMode == Mode.ForLoop) {
            this.visitor.onError("Missing @endfor");
        }
    }

    private int getCurrentTemplateLine() {
        if (this.visitor instanceof CodeGenerator) {
            return ((CodeGenerator)this.visitor).getCurrentTemplateLine();
        }
        return 0;
    }

    private boolean isCommentAllowed() {
        return this.currentMode == Mode.Text;
    }

    private boolean isParamOrImportAllowed() {
        if (this.paramsComplete) {
            return false;
        }
        int endIndex = this.templateCode.lastIndexOf(64, this.i);
        for (int j = this.lastIndex; j < endIndex; ++j) {
            char currentChar = this.templateCode.charAt(j);
            if (Character.isWhitespace(currentChar)) continue;
            return false;
        }
        return true;
    }

    private boolean areParamsComplete(int startIndex) {
        block3: {
            if (this.visitor instanceof TemplateParametersCompleteVisitor) {
                return false;
            }
            try {
                TemplateParser templateParser = new TemplateParser(this.templateCode, this.type, new TemplateParametersCompleteVisitor(), this.config);
                templateParser.setStartIndex(startIndex);
                templateParser.parse();
            }
            catch (TemplateParametersCompleteVisitor.Result result) {
                if (!result.complete) break block3;
                return true;
            }
        }
        return false;
    }

    private boolean isContentExpressionAllowed() {
        return this.currentMode == Mode.Content || this.currentMode == Mode.JavaCodeParam || this.currentMode == Mode.Code || this.currentMode == Mode.CodeStatement || this.currentMode == Mode.Param;
    }

    private void extractTextPart(int endIndex, Mode mode) {
        if (this.currentMode != Mode.Text) {
            this.visitor.onError("Unexpected end of template expression");
        }
        if (this.trimControlStructures) {
            this.extractTextPartAndTrimControlStructures(endIndex, mode);
        } else {
            this.extract(this.templateCode, this.lastIndex, endIndex, this.visitor::onTextPart);
        }
    }

    private void extractTextPartAndTrimControlStructures(int endIndex, Mode mode) {
        this.completeParamsIfRequired();
        int startIndex = this.lastIndex;
        if (this.lastTrimmedIndex != -1) {
            if (this.lastTrimmedIndex > this.lastIndex) {
                startIndex = this.lastTrimmedIndex;
            }
            this.lastTrimmedIndex = -1;
        }
        if (startIndex < 0) {
            return;
        }
        if (endIndex < startIndex) {
            return;
        }
        if (LineInfo.isSingleControlStructure(this.templateCode, endIndex, this.endIndex, this.lastLineIndex, mode)) {
            this.lastTrimmedIndex = this.templateCode.indexOf(10, endIndex) + 1;
            this.extractTrimmed(startIndex, this.lastLineIndex);
            this.previousControlStructureTrimmed = mode;
        } else {
            this.extractTrimmed(startIndex, endIndex);
            this.previousControlStructureTrimmed = null;
        }
        if (mode == Mode.Condition || mode == Mode.ForLoop || mode == Mode.Raw) {
            this.pushIndent(endIndex, mode);
        } else if (mode == Mode.ConditionEnd || mode == Mode.ForLoopEnd || mode == Mode.RawEnd) {
            this.popIndent();
        }
    }

    private void extractTrimmed(int startIndex, int endIndex) {
        int indentationsToSkip = this.getIndentationsToSkip();
        this.visitor.onTextPart(this.depth, this.trimIndentations(startIndex, endIndex, indentationsToSkip));
    }

    private String trimIndentations(int startIndex, int endIndex, int indentationsToSkip) {
        StringBuilder resultText = new StringBuilder(endIndex - startIndex);
        int indentation = 0;
        int line = 0;
        boolean writeLine = false;
        boolean firstNonWhitespaceReached = false;
        if (this.previousControlStructureTrimmed == null) {
            firstNonWhitespaceReached = true;
            writeLine = true;
        }
        for (int j = startIndex; j < endIndex; ++j) {
            char currentChar = this.templateCode.charAt(j);
            if (!(line <= 0 && !firstNonWhitespaceReached || currentChar != '\r' && currentChar != '\n')) {
                resultText.append(currentChar);
            }
            if (currentChar == '\r') continue;
            if (currentChar == '\n') {
                ++line;
                indentation = 0;
                writeLine = false;
                continue;
            }
            if (!firstNonWhitespaceReached && !Character.isWhitespace(currentChar)) {
                firstNonWhitespaceReached = true;
            }
            if (!writeLine && this.isIndentationCharacter(currentChar) && indentation < indentationsToSkip) {
                ++indentation;
            } else {
                writeLine = true;
            }
            if (!writeLine) continue;
            resultText.append(currentChar);
        }
        return resultText.toString();
    }

    private void pushIndent(int endIndex, Mode mode) {
        char currentChar;
        int currentLineIndentation = 0;
        for (int j = endIndex - 1; j >= this.lastIndex && this.isIndentationCharacter(currentChar = this.templateCode.charAt(j)); --j) {
            ++currentLineIndentation;
        }
        int nextLineIndentation = 0;
        int nextIndex = this.templateCode.indexOf(10, endIndex);
        if (nextIndex > 0) {
            char currentChar2;
            for (int j = nextIndex + 1; j < this.endIndex && this.isIndentationCharacter(currentChar2 = this.templateCode.charAt(j)); ++j) {
                ++nextLineIndentation;
            }
        }
        int amount = Math.max(nextLineIndentation - currentLineIndentation, 0);
        this.indentStack.push(new Indent(mode, amount));
    }

    private void popIndent() {
        if (!this.indentStack.isEmpty()) {
            this.indentStack.pop();
        }
    }

    private boolean isIndentationCharacter(char c) {
        return c == ' ' || c == '\t';
    }

    private int getIndentationsToSkip() {
        int amount = 0;
        for (Indent indent : this.indentStack) {
            amount += indent.amount;
        }
        return amount;
    }

    private void extractCodePart() {
        if (this.contentType == ContentType.Html) {
            this.extractHtmlCodePart();
        } else {
            this.extractPlainCodePart();
        }
        this.lastIndex = this.i + 1;
    }

    private void extractPlainCodePart() {
        this.extract(this.templateCode, this.lastIndex, this.i, this.visitor::onCodePart);
    }

    private void extractHtmlCodePart() {
        if (this.currentHtmlTag != null) {
            if (this.currentHtmlTag.attributesProcessed) {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, codePart) -> this.visitor.onHtmlTagBodyCodePart(depth, codePart, this.currentHtmlTag.name));
                return;
            }
            HtmlAttribute currentAttribute = this.currentHtmlTag.getCurrentAttribute();
            if (currentAttribute != null && currentAttribute.quoteCount < 2) {
                this.extract(this.templateCode, this.lastIndex, this.i, (depth, codePart) -> this.visitor.onHtmlTagAttributeCodePart(depth, codePart, this.currentHtmlTag.name, currentAttribute.name));
                return;
            }
        }
        this.extract(this.templateCode, this.lastIndex, this.i, (depth, codePart) -> this.visitor.onHtmlTagBodyCodePart(depth, codePart, "html"));
    }

    private void extractComment(Mode mode, int startIndex) {
        if (this.paramsComplete || this.areParamsComplete(startIndex)) {
            this.extractTextPart(startIndex, mode);
        }
        this.push(mode);
    }

    private boolean isHtmlCommentAllowed() {
        if (this.contentType != ContentType.Html) {
            return false;
        }
        if (this.htmlCommentsPreserved) {
            return false;
        }
        if (this.currentHtmlTag == null) {
            return true;
        }
        return !this.currentHtmlTag.isScript && !this.currentHtmlTag.isStyle && !this.currentHtmlTag.isInAttribute();
    }

    private boolean isCssCommentAllowed() {
        if (this.contentType != ContentType.Html) {
            return false;
        }
        if (this.htmlCommentsPreserved) {
            return false;
        }
        if (this.currentHtmlTag == null) {
            return false;
        }
        return this.currentHtmlTag.isStyle && !this.currentHtmlTag.isInStringLiteral() && !this.currentHtmlTag.isInAttribute();
    }

    private boolean isJsCommentAllowed() {
        if (this.contentType != ContentType.Html) {
            return false;
        }
        if (this.htmlCommentsPreserved) {
            return false;
        }
        if (this.currentHtmlTag == null) {
            return false;
        }
        return this.currentHtmlTag.isScript && !this.currentHtmlTag.isInStringLiteral() && !this.currentHtmlTag.isInAttribute();
    }

    private void interceptHtmlTags() {
        if (this.isOpeningHtmlTag()) {
            String name = this.parseHtmlTagName(this.i + 1);
            if (!name.isEmpty()) {
                HtmlTag htmlTag = new HtmlTag(name, this.isHtmlTagIntercepted(name), this.i + name.length());
                this.htmlPolicy.validateHtmlTag(htmlTag);
                this.pushHtmlTag(htmlTag);
                this.tagClosed = false;
            }
        } else if (this.currentHtmlTag != null && this.i > this.currentHtmlTag.attributeStartIndex) {
            if (!this.currentHtmlTag.attributesProcessed && this.currentHtmlTag.isCurrentAttributeQuote(this.currentChar)) {
                HtmlAttribute currentAttribute = this.currentHtmlTag.getCurrentAttribute();
                ++currentAttribute.quoteCount;
                if (currentAttribute.quoteCount == 1) {
                    currentAttribute.valueStartIndex = this.i + 1;
                } else if (currentAttribute.quoteCount == 2) {
                    currentAttribute.value = this.templateCode.substring(currentAttribute.valueStartIndex, this.i);
                    if (currentAttribute.containsSingleOutput) {
                        this.extractTextPart(this.getLastWhitespaceIndex(currentAttribute.startIndex - 1), Mode.Code);
                        this.lastIndex = this.i + 1;
                        this.visitor.onHtmlAttributeOutput(this.depth, this.currentHtmlTag, currentAttribute);
                        this.outputPrevented = false;
                    }
                }
            } else if (!this.currentHtmlTag.attributesProcessed && !this.currentHtmlTag.isInAttributeString() && this.regionMatches("/>")) {
                if (this.currentHtmlTag.intercepted) {
                    this.extractTextPart(this.i - 1, null);
                    this.lastIndex = this.i - 1;
                    this.visitor.onInterceptHtmlTagOpened(this.depth, this.currentHtmlTag);
                }
                this.currentHtmlTag.attributesProcessed = true;
                this.popHtmlTag();
            } else if (!this.currentHtmlTag.attributesProcessed && !this.currentHtmlTag.isInAttributeString() && this.currentChar == '>') {
                if (this.tagClosed) {
                    this.tagClosed = false;
                } else {
                    if (this.currentHtmlTag.intercepted) {
                        this.extractTextPart(this.i, null);
                        this.lastIndex = this.i;
                        this.visitor.onInterceptHtmlTagOpened(this.depth, this.currentHtmlTag);
                    }
                    this.currentHtmlTag.attributesProcessed = true;
                    if (this.currentHtmlTag.bodyIgnored) {
                        this.popHtmlTag();
                    }
                }
            } else if (this.currentHtmlTag.attributesProcessed && this.regionMatches("</")) {
                if (this.templateCode.startsWith(this.currentHtmlTag.name, this.i + 1)) {
                    if (!this.currentHtmlTag.bodyIgnored) {
                        if (this.currentHtmlTag.intercepted) {
                            this.extractTextPart(this.i - 1, null);
                            this.lastIndex = this.i - 1;
                            this.visitor.onInterceptHtmlTagClosed(this.depth, this.currentHtmlTag);
                        }
                        this.popHtmlTag();
                    }
                } else if (!this.currentHtmlTag.innerTagsIgnored) {
                    String tagName = this.parseHtmlTagName(this.i + 1);
                    this.visitor.onError("Unclosed tag <" + this.currentHtmlTag.name + ">, expected </" + this.currentHtmlTag.name + ">, got </" + tagName + ">.");
                }
                this.tagClosed = true;
            } else if (!this.currentHtmlTag.attributesProcessed && !Character.isWhitespace(this.currentChar) && this.currentChar != '/' && this.currentHtmlTag.isCurrentAttributeComplete()) {
                HtmlAttribute attribute = this.parseHtmlAttribute();
                if (attribute != null) {
                    this.htmlPolicy.validateHtmlAttribute(this.currentHtmlTag, attribute);
                    this.currentHtmlTag.attributes.add(attribute);
                    if (attribute.containsSingleOutput) {
                        this.outputPrevented = true;
                    }
                    if (attribute.quotes == '\u0000') {
                        this.i += attribute.name.length() - 1;
                        this.outputPrevented = false;
                    }
                } else {
                    this.outputPrevented = false;
                }
            } else if (this.currentHtmlTag.isStyle || this.currentHtmlTag.isScript) {
                this.handleStringLiterals('\'');
                this.handleStringLiterals('\"');
            }
        }
    }

    private void handleStringLiterals(char quote) {
        if (this.currentChar == quote && (this.currentHtmlTag.stringLiteralQuote == '\u0000' || this.currentHtmlTag.stringLiteralQuote == quote)) {
            if (this.currentHtmlTag.stringLiteralQuote == '\u0000') {
                this.currentHtmlTag.stringLiteralQuote = this.currentChar;
            } else if (this.previousChar != '\\') {
                this.currentHtmlTag.stringLiteralQuote = '\u0000';
            }
        }
    }

    private boolean isOpeningHtmlTag() {
        if (this.currentChar != '<') {
            return false;
        }
        if (this.templateCode.startsWith("<%--", this.i)) {
            return false;
        }
        if (this.templateCode.startsWith("<!", this.i)) {
            return false;
        }
        if (this.currentHtmlTag == null) {
            return true;
        }
        if (this.currentHtmlTag.innerTagsIgnored) {
            return false;
        }
        return this.currentHtmlTag.attributesProcessed;
    }

    private void pushHtmlTag(HtmlTag htmlTag) {
        this.htmlStack.push(htmlTag);
        this.currentHtmlTag = htmlTag;
    }

    private void popHtmlTag() {
        this.htmlStack.pop();
        this.currentHtmlTag = this.htmlStack.peek();
    }

    private String parseHtmlTagName(int index) {
        char c;
        if (this.templateCode.startsWith("!--", index)) {
            return "!--";
        }
        int startIndex = index;
        while (index < this.endIndex && !Character.isWhitespace(c = this.templateCode.charAt(index)) && c != '/' && c != '>') {
            ++index;
        }
        return this.templateCode.substring(startIndex, index);
    }

    private HtmlAttribute parseHtmlAttribute() {
        int nameEndIndex = -1;
        char quotes = '\u0000';
        for (int j = this.i; j < this.endIndex; ++j) {
            char c = this.templateCode.charAt(j);
            if (c == '=') {
                quotes = this.parseHtmlAttributeQuotes(j + 1);
            }
            if (nameEndIndex == -1) {
                if (c != '=' && c != '/' && c != '>' && !Character.isWhitespace(c)) continue;
                nameEndIndex = j;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (nameEndIndex == -1) {
            return null;
        }
        return new HtmlAttribute(this.templateCode.substring(this.i, nameEndIndex), quotes, this.i, this.isHtmlAttributeSingleOutput(nameEndIndex, quotes));
    }

    private char parseHtmlAttributeQuotes(int index) {
        while (Character.isWhitespace(this.templateCode.charAt(index))) {
            ++index;
        }
        return this.templateCode.charAt(index);
    }

    private boolean isHtmlAttributeSingleOutput(int nameEndIndex, char quotes) {
        int openingQuoteIndex = -1;
        int openingOutputIndex = -1;
        int closingOutputIndex = -1;
        for (int j = nameEndIndex + 1; j < this.endIndex; ++j) {
            char c = this.templateCode.charAt(j);
            if (openingQuoteIndex == -1) {
                if (c != quotes) continue;
                openingQuoteIndex = j;
                continue;
            }
            if (openingOutputIndex == -1) {
                if (this.templateCode.startsWith("${", j)) {
                    openingOutputIndex = j;
                    continue;
                }
                return false;
            }
            if (closingOutputIndex == -1) {
                if (c != '}') continue;
                closingOutputIndex = j;
                continue;
            }
            return c == quotes;
        }
        return false;
    }

    private int getLastWhitespaceIndex(int index) {
        while (index >= 0) {
            if (!Character.isWhitespace(this.templateCode.charAt(index))) {
                ++index;
                break;
            }
            --index;
        }
        return index;
    }

    private boolean isHtmlTagIntercepted(String name) {
        if (this.htmlTags != null) {
            for (String htmlTag : this.htmlTags) {
                if (!name.equals(htmlTag)) continue;
                return true;
            }
        }
        return false;
    }

    private void push(Mode mode) {
        this.currentMode = mode;
        this.stack.push(this.currentMode);
        if (mode == Mode.Text) {
            ++this.depth;
        }
    }

    private void pop() {
        Mode previousMode = this.stack.pop();
        if (previousMode == Mode.Text) {
            --this.depth;
        }
        this.currentMode = this.stack.peek();
    }

    private <T extends Mode> T getPreviousMode(Class<T> modeClass) {
        for (Mode mode : this.stack) {
            if (!modeClass.isAssignableFrom(mode.getClass())) continue;
            return (T)mode;
        }
        throw new IllegalStateException("Expected mode of type " + modeClass + " on the stack, but found nothing!");
    }

    private void extract(String templateCode, int startIndex, int endIndex, VisitorCallback callback) {
        this.completeParamsIfRequired();
        if (startIndex < 0) {
            return;
        }
        if (endIndex < startIndex) {
            return;
        }
        callback.accept(this.depth, templateCode.substring(startIndex, endIndex));
    }

    private void completeParamsIfRequired() {
        if (!this.paramsComplete && this.currentMode != Mode.Param && this.currentMode != Mode.Import && this.type != TemplateType.Content) {
            this.visitor.onParamsComplete();
            this.paramsComplete = true;
        }
    }

    static interface Mode {
        public static final Mode Import = new StatelessMode("Import");
        public static final Mode Param = new StatelessMode("Param");
        public static final Mode Text = new StatelessMode("Text");
        public static final Mode Code = new StatelessMode("Code", true, true, false);
        public static final Mode UnsafeCode = new StatelessMode("UnsafeCode", true, true, false);
        public static final Mode CodeStatement = new StatelessMode("CodeStatement", true, true, false);
        public static final Mode Condition = new StatelessMode("Condition");
        public static final Mode JavaCodeParam = new StatelessMode("JavaCodeParam", true, true, false);
        public static final Mode JavaCodeString = new StatelessMode("JavaCodeString");
        public static final Mode ConditionElse = new StatelessMode("ConditionElse");
        public static final Mode ConditionEnd = new StatelessMode("ConditionEnd");
        public static final Mode ForLoop = new StatelessMode("ForLoop");
        public static final Mode ForLoopEnd = new StatelessMode("ForLoopEnd");
        public static final Mode TemplateCallName = new StatelessMode("TemplateCallName");
        public static final Mode Comment = new StatelessMode("Comment");
        public static final Mode HtmlComment = new StatelessMode("HtmlComment", false, false, true);
        public static final Mode CssComment = new StatelessMode("CssComment", false, false, true);
        public static final Mode JsComment = new StatelessMode("JsComment", false, false, true);
        public static final Mode JsBlockComment = new StatelessMode("JsBlockComment", false, false, true);
        public static final Mode Content = new StatelessMode("Content", false, false, true);
        public static final Mode Raw = new StatelessMode("Raw");
        public static final Mode RawEnd = new StatelessMode("RawEnd");

        public boolean isTrackStrings();

        public boolean isTrackBraces();

        public boolean isComment();
    }

    static interface VisitorCallback {
        public void accept(int var1, String var2);
    }

    private static class JavaCodeMode
    implements Mode {
        private final char closingBrace;
        private final int templateLine;

        public JavaCodeMode(char openingBrace, int templateLine) {
            this.closingBrace = (char)(openingBrace == '(' ? 41 : 125);
            this.templateLine = templateLine;
        }

        @Override
        public boolean isTrackStrings() {
            return true;
        }

        @Override
        public boolean isTrackBraces() {
            return true;
        }

        @Override
        public boolean isComment() {
            return false;
        }

        public char getClosingBrace() {
            return this.closingBrace;
        }

        public int getTemplateLine() {
            return this.templateLine;
        }
    }

    private static class TemplateCallMode
    implements Mode {
        final StringBuilder name = new StringBuilder();
        final List<String> params = new ArrayList<String>();

        private TemplateCallMode() {
        }

        @Override
        public boolean isTrackStrings() {
            return false;
        }

        @Override
        public boolean isTrackBraces() {
            return false;
        }

        @Override
        public boolean isComment() {
            return false;
        }
    }

    public static class HtmlTag
    implements gg.jte.html.HtmlTag {
        private static final Set<String> VOID_HTML_TAGS = new HashSet<String>(Arrays.asList("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"));
        public final String name;
        public final boolean intercepted;
        public final int attributeStartIndex;
        public final boolean bodyIgnored;
        public final boolean innerTagsIgnored;
        public final boolean isScript;
        public final boolean isStyle;
        public final List<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>();
        public boolean attributesProcessed;
        public char stringLiteralQuote;

        public HtmlTag(String name, boolean intercepted, int attributeStartIndex) {
            this.name = name;
            this.intercepted = intercepted;
            this.attributeStartIndex = attributeStartIndex;
            this.bodyIgnored = VOID_HTML_TAGS.contains(name);
            this.isScript = "script".equals(name);
            this.isStyle = "style".equals(name);
            this.innerTagsIgnored = this.isScript || this.isStyle;
        }

        public HtmlAttribute getCurrentAttribute() {
            if (this.attributes.isEmpty()) {
                return null;
            }
            return this.attributes.get(this.attributes.size() - 1);
        }

        public boolean isCurrentAttributeComplete() {
            HtmlAttribute currentAttribute = this.getCurrentAttribute();
            if (currentAttribute == null) {
                return true;
            }
            if (currentAttribute.quotes == '\u0000') {
                return true;
            }
            return currentAttribute.quoteCount > 1;
        }

        public boolean isCurrentAttributeQuote(char currentChar) {
            HtmlAttribute currentAttribute = this.getCurrentAttribute();
            if (currentAttribute == null) {
                return false;
            }
            return currentChar == currentAttribute.quotes;
        }

        public boolean isInAttribute() {
            if (this.attributesProcessed) {
                return false;
            }
            HtmlAttribute currentAttribute = this.getCurrentAttribute();
            return currentAttribute != null && currentAttribute.quoteCount < 2;
        }

        public boolean isInAttributeString() {
            if (this.attributesProcessed) {
                return false;
            }
            HtmlAttribute currentAttribute = this.getCurrentAttribute();
            return currentAttribute != null && currentAttribute.quoteCount == 1;
        }

        public boolean isInStringLiteral() {
            return this.stringLiteralQuote != '\u0000';
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class Indent {
        public final Mode mode;
        public final int amount;

        public Indent(Mode mode, int amount) {
            this.mode = mode;
            this.amount = amount;
        }
    }

    public static class HtmlAttribute
    implements gg.jte.html.HtmlAttribute {
        private static final Set<String> BOOLEAN_HTML_ATTRIBUTES = new HashSet<String>(Arrays.asList("allowfullscreen", "allowpaymentrequest", "async", "autofocus", "autoplay", "checked", "controls", "default", "disabled", "formnovalidate", "hidden", "ismap", "itemscope", "loop", "multiple", "muted", "nomodule", "novalidate", "open", "playsinline", "readonly", "required", "reversed", "selected", "truespeed"));
        public final String name;
        public final char quotes;
        public final int startIndex;
        public final boolean containsSingleOutput;
        public final boolean bool;
        public String value;
        public int quoteCount;
        public int valueStartIndex;

        private HtmlAttribute(String name, char quotes, int startIndex, boolean containsSingleOutput) {
            this.name = name;
            this.quotes = quotes;
            this.startIndex = startIndex;
            this.containsSingleOutput = containsSingleOutput;
            this.bool = BOOLEAN_HTML_ATTRIBUTES.contains(name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.quotes == '\u0000';
        }

        @Override
        public char getQuotes() {
            return this.quotes;
        }

        @Override
        public boolean isBoolean() {
            return this.bool;
        }
    }

    private static class StatelessMode
    implements Mode {
        private final String debugName;
        private final boolean trackStrings;
        private final boolean trackBraces;
        private final boolean comment;

        private StatelessMode(String debugName) {
            this(debugName, false, false, false);
        }

        private StatelessMode(String debugName, boolean trackStrings, boolean trackBraces, boolean comment) {
            this.debugName = debugName;
            this.trackStrings = trackStrings;
            this.trackBraces = trackBraces;
            this.comment = comment;
        }

        @Override
        public boolean isTrackStrings() {
            return this.trackStrings;
        }

        @Override
        public boolean isTrackBraces() {
            return this.trackBraces;
        }

        @Override
        public boolean isComment() {
            return this.comment;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.debugName + "]";
        }
    }
}

