/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.gradleutil.conf.Loader;
import net.gradleutil.conf.LoaderOptions;
import net.gradleutil.conf.config.Config;
import net.gradleutil.conf.config.ConfigException;
import net.gradleutil.conf.config.ConfigObject;
import net.gradleutil.conf.config.ConfigValue;
import net.gradleutil.conf.config.ConfigValueType;
import net.gradleutil.conf.util.ConfUtil;

public class BeanConfigLoader {
    public static <T> T get(Config config, String className, ClassLoader classLoader, Boolean ignoreMissingProperties) throws Exception {
        T bean = BeanConfigLoader.create(Loader.loaderOptions().config(config).className(className).classLoader(classLoader).allowUnresolved(ignoreMissingProperties));
        Class<?> expectedClass = classLoader.loadClass(className);
        if (bean.getClass().isAssignableFrom(expectedClass)) {
            return bean;
        }
        throw new ClassCastException("Expected " + expectedClass.getSimpleName() + ", but got " + bean.getClass().getSimpleName());
    }

    public static <T> T get(Config config, String className, ClassLoader classLoader) throws Exception {
        return BeanConfigLoader.get(config, className, classLoader, false);
    }

    public static <T> T create(LoaderOptions options) throws RuntimeException {
        Class<?> clazz = BeanConfigLoader.getClassForKey(options.className, options);
        try {
            Object bean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanConfigLoader.setBeanFromConfig(bean, options);
            return (T)bean;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of " + clazz.getName(), e);
        }
    }

    public static void setBeanFromConfig(Object bean, LoaderOptions options) throws Exception {
        if (options.config == null) {
            options.config = Loader.load(options);
        }
        String packageName = bean.getClass().getPackage().getName();
        List<Map<String, ConfigValue>> keyValueMap = BeanConfigLoader.toList(bean, options.config);
        options.classLoader(options.classLoader != null ? options.classLoader : bean.getClass().getClassLoader());
        for (Map<String, ConfigValue> map : keyValueMap) {
            for (Map.Entry<String, ConfigValue> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.equals("$schema")) continue;
                String id = ConfUtil.ident(key, true, true, options.singularizeClasses);
                List<Method> setters = BeanConfigLoader.getSetters(BeanConfigLoader.getBeanInfo(bean.getClass()));
                Method setter = BeanConfigLoader.getSetter(setters, key, id);
                if (setter == null) {
                    List keys = setters.stream().map(Method::getName).collect(Collectors.toList());
                    throw new Exception("Unable to find setter for key " + key + " or ident " + id + " out of " + keys);
                }
                Parameter firstParam = setter.getParameters()[0];
                ConfigValue configValue = entry.getValue();
                Object value = BeanConfigLoader.getValue(configValue, key, packageName + '.' + id, setters, options.classLoader, options.allowUnresolved);
                if (value == null) continue;
                try {
                    Class<?> superclass = firstParam.getType().getSuperclass();
                    if (superclass != null && superclass.getSimpleName().equals("Enum") && value instanceof String) {
                        ?[] consts = firstParam.getType().getEnumConstants();
                        Object eVal = Arrays.stream(consts).filter(c -> c.toString().equals(value)).findFirst().orElse(null);
                        setter.invoke(bean, eVal);
                        continue;
                    }
                    if (firstParam.getType().getSimpleName().equals("BigInteger")) {
                        setter.invoke(bean, BigInteger.valueOf(Long.parseLong(value.toString())));
                        continue;
                    }
                    if (firstParam.getType().getSimpleName().equals("Integer")) {
                        setter.invoke(bean, Integer.parseInt(value.toString()));
                        continue;
                    }
                    if (firstParam.getType().getSimpleName().equals("Long")) {
                        setter.invoke(bean, Long.parseLong(value.toString()));
                        continue;
                    }
                    if (firstParam.getType().getSimpleName().equals("String")) {
                        setter.invoke(bean, value.toString());
                        continue;
                    }
                    setter.invoke(bean, value);
                }
                catch (Exception e) {
                    throw new Exception("Unable to set " + key + "=" + value, e);
                }
            }
        }
    }

    public static List<Map<String, ConfigValue>> toList(Object bean, Config config) {
        String k;
        ArrayList<Map<String, ConfigValue>> keyValueMap = new ArrayList<Map<String, ConfigValue>>();
        for (Map.Entry entry : config.root().entrySet()) {
            HashMap map = new HashMap();
            map.put(entry.getKey(), entry.getValue());
            keyValueMap.add(map);
        }
        if (keyValueMap.stream().map(Map::keySet).distinct().count() == 1L && (k = (String)((Map)keyValueMap.get(0)).keySet().iterator().next()).equalsIgnoreCase(bean.getClass().getSimpleName())) {
            ConfigObject key = (ConfigObject)config.root().get(k);
            ArrayList<Map<String, ConfigValue>> result = new ArrayList<Map<String, ConfigValue>>();
            for (Map.Entry entry : key.entrySet()) {
                HashMap map = new HashMap();
                map.put(entry.getKey(), entry.getValue());
                result.add(map);
            }
            return result;
        }
        return keyValueMap;
    }

    public static Method getSetter(List<Method> methods, String key, String id) {
        String[] names = new String[]{key, id, "set" + key, "set" + id};
        return methods.stream().filter(prop -> prop.getParameterCount() > 0).filter(prop -> Arrays.stream(names).anyMatch(prop.getName()::equalsIgnoreCase)).findFirst().orElse(null);
    }

    public static Class<?> getClassForKey(String name, LoaderOptions options) {
        Class<?> obClass;
        String packageName = name.substring(0, name.lastIndexOf(46));
        String className = name.replace(packageName + ".", "");
        try {
            String ident = ConfUtil.ident(className, true, true, options.singularizeClasses);
            obClass = options.classLoader.loadClass(packageName + "." + ident);
        }
        catch (ClassNotFoundException ignore) {
            try {
                obClass = options.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load class " + name, e);
            }
        }
        return obClass;
    }

    private static Object getValue(ConfigValue configValue, String configPropName, String className, List<Method> setters, ClassLoader classLoader, Boolean ignoreMissingProperties) throws Exception {
        String identPropName = ConfUtil.ident(configPropName, true, false, false).toLowerCase();
        Method setter = BeanConfigLoader.getSetter(setters, configPropName, identPropName);
        Serializable value = null;
        if (setter == null) {
            if (!ignoreMissingProperties.booleanValue()) {
                String message = String.format("Missing set%s for %s#%s (%s)\n%s", identPropName, className, configPropName, setters.stream().map(Method::getName).collect(Collectors.joining(", ")), configValue);
                throw new InstantiationException(message);
            }
        } else {
            if (configValue.valueType() == ConfigValueType.NULL) {
                return null;
            }
            if (configValue.valueType() == ConfigValueType.LIST) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (ConfigValue item : (List)((Object)configValue)) {
                    if (item.valueType() == ConfigValueType.OBJECT) {
                        ConfigObject configObject = (ConfigObject)item;
                        String packageName = className.substring(0, className.lastIndexOf(46));
                        String classSimpleName = className.replace(packageName + ".", "");
                        String firstKey = (String)configObject.keySet().iterator().next();
                        if (configObject.keySet().size() == 1 && firstKey.equalsIgnoreCase(classSimpleName)) {
                            ConfigObject conf = (ConfigObject)configObject.get(firstKey);
                            list.add(BeanConfigLoader.getValue(conf, configPropName, packageName + "." + firstKey, setters, classLoader, ignoreMissingProperties));
                            continue;
                        }
                        BeanConfigLoader.safeListAdd(configPropName, setters, classLoader, ignoreMissingProperties, list, item);
                        continue;
                    }
                    BeanConfigLoader.safeListAdd(configPropName, setters, classLoader, ignoreMissingProperties, list, item);
                }
                value = list;
            } else if (configValue.valueType() == ConfigValueType.OBJECT) {
                ConfigObject configObject = (ConfigObject)configValue;
                value = BeanConfigLoader.get(configObject.toConfig(), className, classLoader, ignoreMissingProperties);
            } else if (configValue.valueType() == ConfigValueType.NUMBER) {
                Number number = (Number)configValue.unwrapped();
                value = setter.getReturnType() == Long.class ? (Number)number.longValue() : (Number)number.intValue();
            } else {
                value = configValue.unwrapped();
            }
        }
        return value;
    }

    private static void safeListAdd(String configPropName, List<Method> beanProps, ClassLoader classLoader, Boolean ignoreMissingProperties, List<Object> list, ConfigValue item) throws Exception {
        Method setter = BeanConfigLoader.getSetter(beanProps, configPropName, configPropName);
        assert (setter != null);
        String beanReturnType = setter.getGenericParameterTypes()[0].getTypeName().replaceAll(".*<(.*)>", "$1");
        list.add(BeanConfigLoader.getValue(item, configPropName, beanReturnType, beanProps, classLoader, ignoreMissingProperties));
    }

    static BeanInfo getBeanInfo(Class<?> clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new ConfigException.BadBean("Could not get bean information for class " + clazz.getName(), e);
        }
        return beanInfo;
    }

    static List<Method> getSetters(BeanInfo beanInfo) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (PropertyDescriptor beanProp : beanInfo.getPropertyDescriptors()) {
            if (beanProp.getReadMethod() == null || beanProp.getWriteMethod() == null || beanProp.getName().equals("metaClass")) continue;
            methods.add(beanProp.getWriteMethod());
        }
        Arrays.stream(beanInfo.getMethodDescriptors()).map(MethodDescriptor::getMethod).forEach(methods::add);
        return methods;
    }
}

