/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.gradleutil.conf.BeanConfigLoader;
import net.gradleutil.conf.LoaderOptions;
import net.gradleutil.conf.Log;
import net.gradleutil.conf.config.Config;
import net.gradleutil.conf.config.ConfigException;
import net.gradleutil.conf.config.ConfigFactory;
import net.gradleutil.conf.config.ConfigParseOptions;
import net.gradleutil.conf.config.ConfigResolveOptions;
import net.gradleutil.conf.config.ConfigResolver;
import net.gradleutil.conf.config.ConfigSyntax;
import net.gradleutil.conf.config.ConfigValue;
import net.gradleutil.conf.config.ConfigValueFactory;
import net.gradleutil.conf.json.JSONObject;
import net.gradleutil.conf.json.schema.SchemaUtil;
import net.gradleutil.conf.json.schema.ValidationException;
import net.gradleutil.conf.util.ConfUtil;

public class Loader {
    private static final ConfigResolver SYSTEM_PROPERTY = new ConfigResolver(){

        @Override
        public ConfigValue lookup(String path) {
            HashMap<String, String> map = new HashMap<String, String>();
            String systemPath = System.getProperties().getProperty(path);
            map.put(path, systemPath != null ? systemPath : path);
            return ConfigValueFactory.fromMap(map).get(path);
        }

        @Override
        public ConfigResolver withFallback(ConfigResolver fallback) {
            return fallback;
        }
    };

    public static LoaderOptions loaderOptions() {
        return new LoaderOptions();
    }

    public static <T> T create(Config config, Class<T> clazz, LoaderOptions options) throws Exception {
        if (!config.root().toConfig().isResolved()) {
            throw new ConfigException.NotResolved("need to Config#resolve() a config before using it to initialize a bean, see the API docs for Config#resolve()");
        }
        T bean = clazz.newInstance();
        if (options.config == null) {
            options.config(config);
        }
        BeanConfigLoader.setBeanFromConfig(bean, options);
        return bean;
    }

    public static <T> T create(Config config, Class<T> clazz) throws Exception {
        return Loader.create(config, clazz, Loader.loaderOptions());
    }

    static <T> T create(Map<String, Object> map, Class<T> clazz) throws Exception {
        String json = new JSONObject(map).toString();
        Config config = Loader.load(json);
        return Loader.create(config, clazz);
    }

    public static <T> T create(String json, Class<T> clazz, LoaderOptions options) throws Exception {
        return Loader.create(Loader.load(json), clazz, options);
    }

    public static <T> T create(String json, Class<T> clazz) throws Exception {
        return Loader.create(Loader.load(json), clazz, Loader.loaderOptions());
    }

    public static Config load(String json) throws IOException {
        return Loader.load(new LoaderOptions().confString(json));
    }

    public static Config load(File jsonFile) throws IOException {
        return Loader.load(new LoaderOptions().conf(jsonFile));
    }

    public static Config load(File jsonFile, File schemaFile) throws IOException {
        return Loader.load(new LoaderOptions().conf(jsonFile).schemaFile(schemaFile));
    }

    public static Config load(LoaderOptions options) throws IOException {
        Config conf;
        Config config;
        ArrayList<Config> fallbacks = new ArrayList<Config>();
        Log log2 = new Log(options);
        BiFunction<String, File, Boolean> logIfFileExists = (message, file) -> {
            if (file != null && file.exists()) {
                log2.info(message + ": " + file.getAbsolutePath());
                return true;
            }
            if (file != null) {
                log2.info(message + ": " + file.getAbsolutePath() + " does not exist");
            }
            return false;
        };
        if (options.invalidateCaches.booleanValue()) {
            Loader.invalidateCaches();
            log2.info("Invalidating caches");
        }
        if (logIfFileExists.apply("load reference", options.reference).booleanValue()) {
            fallbacks.add(ConfigFactory.parseFile(options.reference));
        } else if (options.useReferences.booleanValue()) {
            log2.info("Loading reference from classloader, classLoader=" + options.classLoader);
            fallbacks.add(ConfigFactory.defaultReferenceUnresolved());
        }
        if (options.config != null) {
            config = options.config;
        } else if (logIfFileExists.apply("load config", options.conf).booleanValue()) {
            config = ConfigFactory.parseFile(options.conf);
        } else if (options.confString != null) {
            log2.info("Loading config from string");
            config = ConfigFactory.parseString(options.confString);
        } else {
            log2.info("Loading config from classloader, baseName=" + options.baseName + ", classLoader=" + options.classLoader);
            config = ConfigFactory.parseResources(options.classLoader, options.baseName);
        }
        if (logIfFileExists.apply("load override", options.confOverride).booleanValue()) {
            config = ConfigFactory.parseFile(options.confOverride).withFallback(config);
        }
        if (options.schemaString != null) {
            log2.info("Loading schema from string");
            options.schema(SchemaUtil.getSchema(options.schemaString));
        } else if (options.schemaFile != null) {
            log2.info("Loading schema from " + options.schemaFile);
            if (!options.schemaFile.exists()) {
                log2.info("schema file " + options.schemaFile + ", nonexistent, generating from conf");
            }
            options.schema(SchemaUtil.getSchema(options.schemaFile));
        }
        Config finalConfig = config;
        fallbacks.forEach(finalConfig::withFallback);
        log2.info("Resolving config, existing keys:" + String.join((CharSequence)", ", config.root().keySet()));
        if (options.schema != null && options.schemaValidation.booleanValue()) {
            log2.info("Validating config against schema " + options.schema.getLocation());
            List<ValidationException> errors = SchemaUtil.validate(options.schema, ConfUtil.configToJsonObject(config));
            if (!errors.isEmpty()) {
                if (options.onSchemaValidationFailure != null) {
                    options.onSchemaValidationFailure.accept(errors);
                } else {
                    errors.forEach(System.err::println);
                    throw new IllegalArgumentException("Failed validation");
                }
            }
            log2.info("Finished validating");
        }
        if (options.useSystemProperties.booleanValue()) {
            log2.info("Using System Properties");
            conf = ConfigFactory.load(config);
        } else {
            ConfigResolveOptions resolver = ConfigResolveOptions.defaults().setAllowUnresolved(options.allowUnresolved).setUseSystemEnvironment(options.useSystemEnvironment).appendResolver(SYSTEM_PROPERTY);
            conf = config.resolve(resolver);
        }
        if (options.resolveStringValues.booleanValue()) {
            conf = ConfUtil.resolveStringValues(conf);
        }
        return conf;
    }

    static Config loadWithSchemaFile(File schemaFile, File conf) throws IOException {
        return Loader.load(Loader.loaderOptions().conf(conf).schemaFile(schemaFile));
    }

    static Config loadWithSchema(String schemaString, File conf) throws IOException {
        return Loader.load(Loader.loaderOptions().conf(conf).schemaString(schemaString));
    }

    static Config loadWithOverride(File conf, File confOverride) throws IOException {
        return Loader.load(Loader.loaderOptions().conf(conf).confOverride(confOverride));
    }

    static Config resolveWithSystem(String baseName) {
        ConfigResolveOptions options = ConfigResolveOptions.defaults().setAllowUnresolved(true).appendResolver(SYSTEM_PROPERTY);
        return ConfigFactory.parseResources(baseName, ConfigParseOptions.defaults()).resolve(options);
    }

    static Config resolveWithSystem(File configFile) throws FileNotFoundException {
        if (!configFile.exists()) {
            throw new FileNotFoundException("config file '${configFile.absolutePath}' not found");
        }
        ConfigResolveOptions options = ConfigResolveOptions.defaults().setAllowUnresolved(true).appendResolver(SYSTEM_PROPERTY);
        ConfigParseOptions parseOpts = ConfigParseOptions.defaults();
        if (configFile.getName().toLowerCase().endsWith(".mhf")) {
            parseOpts.setSyntax(ConfigSyntax.CONF);
        }
        return ConfigFactory.parseFile(configFile, parseOpts).resolve(options);
    }

    static Config resolveStringWithSystem(String conf) {
        ConfigResolveOptions options = ConfigResolveOptions.defaults().setAllowUnresolved(true).appendResolver(SYSTEM_PROPERTY);
        ConfigParseOptions parseOpts = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF);
        return ConfigFactory.parseString(conf, parseOpts).resolve(options);
    }

    static void invalidateCaches() {
        ConfigFactory.invalidateCaches();
    }
}

