/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import net.gradleutil.conf.json.JSONArray;
import net.gradleutil.conf.json.JSONException;
import net.gradleutil.conf.json.JSONObject;
import net.gradleutil.conf.json.JSONString;
import net.gradleutil.conf.json.JSONTokener;

public class JsonObject
extends JSONObject {
    static final Pattern NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?");

    public JsonObject() {
    }

    public JsonObject(JSONTokener jsonTokener) {
        super(jsonTokener);
    }

    public JsonObject(String source) {
        super(source);
    }

    public JsonObject(Object object) {
        super(object);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean needsComma = false;
            int length = this.length();
            writer.write(123);
            if (length == 1) {
                Map.Entry<String, Object> entry = this.entrySet().iterator().next();
                JsonObject.writeEntry(writer, entry, indentFactor, indent);
            } else if (length != 0) {
                int newIndent = indent + indentFactor;
                for (Map.Entry<String, Object> entry : this.entrySet()) {
                    if (needsComma) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JsonObject.indent(writer, newIndent);
                    JsonObject.writeEntry(writer, entry, indentFactor, newIndent);
                    needsComma = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JsonObject.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    public static void writeEntry(Writer writer, Map.Entry<String, ?> entry, int indentFactor, int newIndent) throws IOException {
        String key = entry.getKey();
        writer.write(JsonObject.quote(key));
        writer.write(58);
        if (indentFactor > 0) {
            writer.write(32);
        }
        try {
            JsonObject.writeValue(writer, entry.getValue(), indentFactor, newIndent);
        }
        catch (Exception e) {
            throw new JSONException("Unable to write JSONObject value for key: " + key, e);
        }
    }

    static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            writer.write(o != null ? o.toString() : JsonObject.quote(value.toString()));
        } else if (value instanceof Number) {
            String numberAsString = JsonObject.numberToString((Number)value);
            if (NUMBER_PATTERN.matcher(numberAsString).matches()) {
                writer.write(numberAsString);
            } else {
                JsonObject.quote(numberAsString, writer);
            }
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof Enum) {
            writer.write(JsonObject.quote(((Enum)value).name()));
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            new JSONObject(map).write(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            new JSONArray(coll).write(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            new JSONArray(value).write(writer, indentFactor, indent);
        } else {
            JsonObject.quote(value.toString(), writer);
        }
        return writer;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }
}

