/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema;

import net.gradleutil.conf.json.schema.CollectingFailureReporter;
import net.gradleutil.conf.json.schema.EarlyFailingFailureReporter;
import net.gradleutil.conf.json.schema.InternalValidationException;
import net.gradleutil.conf.json.schema.PrimitiveValidationStrategy;
import net.gradleutil.conf.json.schema.ReadWriteContext;
import net.gradleutil.conf.json.schema.ReadWriteValidator;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.ValidatingVisitor;
import net.gradleutil.conf.json.schema.ValidationFailureReporter;
import net.gradleutil.conf.json.schema.Validator;
import net.gradleutil.conf.json.schema.event.ValidationListener;

class DefaultValidator
implements Validator {
    private boolean failEarly;
    private final ReadWriteContext readWriteContext;
    private final ValidationListener validationListener;
    private final PrimitiveValidationStrategy primitiveValidationStrategy;

    DefaultValidator(boolean failEarly, ReadWriteContext readWriteContext, ValidationListener validationListener, PrimitiveValidationStrategy primitiveValidationStrategy) {
        this.failEarly = failEarly;
        this.readWriteContext = readWriteContext;
        this.validationListener = validationListener;
        this.primitiveValidationStrategy = primitiveValidationStrategy;
    }

    @Override
    public void performValidation(Schema schema, Object input) {
        ValidationFailureReporter failureReporter = this.createFailureReporter(schema);
        ReadWriteValidator readWriteValidator = ReadWriteValidator.createForContext(this.readWriteContext, failureReporter);
        ValidatingVisitor visitor = new ValidatingVisitor(input, failureReporter, readWriteValidator, this.validationListener, this.primitiveValidationStrategy);
        try {
            visitor.visit(schema);
            visitor.failIfErrorFound();
        }
        catch (InternalValidationException e) {
            throw e.copy();
        }
    }

    private ValidationFailureReporter createFailureReporter(Schema schema) {
        if (this.failEarly) {
            return new EarlyFailingFailureReporter(schema);
        }
        return new CollectingFailureReporter(schema);
    }
}

