/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.gradleutil.conf.json.JSONTokener;
import net.gradleutil.conf.json.JsonObject;
import net.gradleutil.conf.json.schema.CombinedSchema;
import net.gradleutil.conf.json.schema.PrimitiveValidationStrategy;
import net.gradleutil.conf.json.schema.ReferenceSchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.SchemaToReferenceSchema;
import net.gradleutil.conf.json.schema.ValidationException;
import net.gradleutil.conf.json.schema.Validator;
import net.gradleutil.conf.json.schema.loader.SchemaLoader;

public class SchemaUtil
extends SchemaLoader {
    public SchemaUtil(SchemaLoader.SchemaLoaderBuilder builder) {
        super(builder);
    }

    public static Schema getSchema(File json) throws IOException {
        return SchemaUtil.getSchema(new String(Files.readAllBytes(json.toPath())));
    }

    public static Schema getInternalSchema(String name, String basePath, String extension) {
        String schemaJsonName = basePath + name + extension;
        InputStream inputStream = SchemaUtil.class.getResourceAsStream(schemaJsonName);
        return SchemaUtil.getSchema(inputStream, schemaJsonName);
    }

    public static Schema getInternalSchema(String name, String basePath) {
        return SchemaUtil.getInternalSchema(name, basePath, ".json");
    }

    public static Schema getInternalSchema(String name) {
        return SchemaUtil.getInternalSchema(name, "/schema/", ".json");
    }

    public static Schema getSchema(InputStream inputStream, String name, boolean useDefaults) {
        SchemaUtil.illegalIfNull(inputStream, "Could not load resource: " + name);
        JsonObject rawSchema = new JsonObject(new JSONTokener(inputStream));
        SchemaUtil.illegalIfNull(rawSchema, "Internal Schema was empty or could not be parsed: " + name);
        return SchemaLoader.builder().useDefaults(useDefaults).schemaJson(rawSchema).build().load().build();
    }

    public static Schema getSchema(InputStream inputStream, String name) {
        return SchemaUtil.getSchema(inputStream, name, true);
    }

    public static Schema getSchema(InputStream inputStream) {
        return SchemaUtil.getSchema(inputStream, "inputstream.schema.json", true);
    }

    public static Schema getSchema(String json, boolean useDefaults, String refName) {
        JsonObject rawSchema = SchemaUtil.JsonObjectFromString(json);
        SchemaUtil.illegalIfNull(rawSchema, "Schema could not be parsed: " + json);
        Object schema = SchemaLoader.builder().useDefaults(useDefaults).schemaJson(rawSchema).build().load().build();
        if (!(refName.isEmpty() || schema instanceof ReferenceSchema || schema instanceof CombinedSchema)) {
            return SchemaToReferenceSchema.toReferenceSchema(schema, refName);
        }
        return schema;
    }

    public static Schema getSchema(String json, boolean useDefaults) {
        return SchemaUtil.getSchema(json, useDefaults, "");
    }

    public static Schema getSchema(String json) {
        return SchemaUtil.getSchema(json, true, "");
    }

    public static JsonObject JsonObjectFromString(String json) {
        JsonObject JsonObject2;
        SchemaUtil.illegalIfNull(json, "json is empty");
        try {
            JsonObject2 = new JsonObject(json);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse script text:\n" + json, e);
        }
        return JsonObject2;
    }

    public static List<ValidationException> getExceptions(ValidationException e) {
        ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
        exceptions.add(e);
        return exceptions;
    }

    public static List<ValidationException> validate(Schema schema, JsonObject json) {
        ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
        try {
            Validator validator = Validator.builder().primitiveValidationStrategy(PrimitiveValidationStrategy.LENIENT).build();
            validator.performValidation(schema, json);
        }
        catch (ValidationException e) {
            exceptions.addAll(SchemaUtil.getExceptions(e));
        }
        return exceptions;
    }

    public static String editor(String schemaJson, String dataJson, String uiSchema) {
        String schemaForm;
        try {
            schemaForm = SchemaUtil.readFromInputStream(SchemaUtil.class.getResourceAsStream("/editor/index.html"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return schemaForm.replace("@schema", schemaJson).replace("@uiSchema", uiSchema).replace("@formData", dataJson);
    }

    public static String editor(String schemaJson, String dataJson) {
        return SchemaUtil.editor(schemaJson, dataJson, "{}");
    }

    public static void illegalIfNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }
}

