/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.gradleutil.conf.json.JSONArray;
import net.gradleutil.conf.json.JSONObject;
import net.gradleutil.conf.json.schema.ArraySchema;
import net.gradleutil.conf.json.schema.ArraySchemaValidatingVisitor;
import net.gradleutil.conf.json.schema.BooleanSchema;
import net.gradleutil.conf.json.schema.CombinedSchema;
import net.gradleutil.conf.json.schema.ConditionalSchema;
import net.gradleutil.conf.json.schema.ConditionalSchemaValidatingVisitor;
import net.gradleutil.conf.json.schema.ConstSchema;
import net.gradleutil.conf.json.schema.EnumSchema;
import net.gradleutil.conf.json.schema.FalseSchema;
import net.gradleutil.conf.json.schema.InternalValidationException;
import net.gradleutil.conf.json.schema.NotSchema;
import net.gradleutil.conf.json.schema.NullSchema;
import net.gradleutil.conf.json.schema.NumberSchema;
import net.gradleutil.conf.json.schema.NumberSchemaValidatingVisitor;
import net.gradleutil.conf.json.schema.ObjectComparator;
import net.gradleutil.conf.json.schema.ObjectSchema;
import net.gradleutil.conf.json.schema.ObjectSchemaValidatingVisitor;
import net.gradleutil.conf.json.schema.PrimitiveValidationStrategy;
import net.gradleutil.conf.json.schema.ReadWriteValidator;
import net.gradleutil.conf.json.schema.ReferenceSchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.StringSchema;
import net.gradleutil.conf.json.schema.StringSchemaValidatingVisitor;
import net.gradleutil.conf.json.schema.StringToValueConverter;
import net.gradleutil.conf.json.schema.TypeChecker;
import net.gradleutil.conf.json.schema.ValidationException;
import net.gradleutil.conf.json.schema.ValidationFailureReporter;
import net.gradleutil.conf.json.schema.Visitor;
import net.gradleutil.conf.json.schema.event.CombinedSchemaMatchEvent;
import net.gradleutil.conf.json.schema.event.CombinedSchemaMismatchEvent;
import net.gradleutil.conf.json.schema.event.SchemaReferencedEvent;
import net.gradleutil.conf.json.schema.event.ValidationListener;

class ValidatingVisitor
extends Visitor {
    private static final List<Class<?>> VALIDATED_TYPES = Collections.unmodifiableList(Arrays.asList(Number.class, String.class, Boolean.class, JSONObject.class, JSONArray.class, JSONObject.NULL.getClass()));
    static final String TYPE_FAILURE_MSG = "subject is an instance of non-handled type %s. Should be one of " + VALIDATED_TYPES.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
    protected Object subject;
    final ValidationListener validationListener;
    private ValidationFailureReporter failureReporter;
    private final ReadWriteValidator readWriteValidator;
    private final PrimitiveValidationStrategy primitiveValidationStrategy;

    private static boolean isNull(Object obj) {
        return obj == null || JSONObject.NULL.equals(obj);
    }

    @Override
    void visit(Schema schema) {
        if (Boolean.FALSE.equals(schema.isNullable()) && ValidatingVisitor.isNull(this.subject)) {
            this.failureReporter.failure("value cannot be null", "nullable");
        }
        this.readWriteValidator.validate(schema, this.subject);
        super.visit(schema);
    }

    ValidatingVisitor(Object subject, ValidationFailureReporter failureReporter, ReadWriteValidator readWriteValidator, ValidationListener validationListener, PrimitiveValidationStrategy primitiveValidationStrategy) {
        if (subject != null && !VALIDATED_TYPES.stream().anyMatch(type -> type.isAssignableFrom(subject.getClass()))) {
            throw new IllegalArgumentException(String.format(TYPE_FAILURE_MSG, subject.getClass().getSimpleName()));
        }
        this.subject = subject;
        this.failureReporter = failureReporter;
        this.readWriteValidator = readWriteValidator;
        this.validationListener = validationListener;
        this.primitiveValidationStrategy = Objects.requireNonNull(primitiveValidationStrategy);
    }

    @Override
    void visitNumberSchema(NumberSchema numberSchema) {
        numberSchema.accept(new NumberSchemaValidatingVisitor(this.subject, this));
    }

    @Override
    void visitArraySchema(ArraySchema arraySchema) {
        arraySchema.accept(new ArraySchemaValidatingVisitor(this));
    }

    @Override
    void visitBooleanSchema(BooleanSchema schema) {
        this.ifPassesTypeCheck(Boolean.class, true, schema.isNullable(), v -> {});
    }

    @Override
    void visitNullSchema(NullSchema nullSchema) {
        if (!(ValidatingVisitor.isNull(this.subject) || this.primitiveValidationStrategy == PrimitiveValidationStrategy.LENIENT && "null".equals(this.subject))) {
            this.failureReporter.failure("expected: null, found: " + this.subject.getClass().getSimpleName(), "type");
        }
    }

    @Override
    void visitConstSchema(ConstSchema constSchema) {
        if (ValidatingVisitor.isNull(this.subject) && ValidatingVisitor.isNull(constSchema.getPermittedValue())) {
            return;
        }
        Object effectiveSubject = EnumSchema.toJavaValue(this.subject);
        if (!ObjectComparator.deepEquals(effectiveSubject, constSchema.getPermittedValue())) {
            this.failureReporter.failure("", "const");
        }
    }

    @Override
    void visitEnumSchema(EnumSchema enumSchema) {
        Object effectiveSubject = EnumSchema.toJavaValue(this.subject);
        for (Object possibleValue : enumSchema.getPossibleValues()) {
            if (!ObjectComparator.deepEquals(possibleValue, effectiveSubject)) continue;
            return;
        }
        this.failureReporter.failure(String.format("%s is not a valid enum value", this.subject), "enum");
    }

    @Override
    void visitFalseSchema(FalseSchema falseSchema) {
        this.failureReporter.failure("false schema always fails", "false");
    }

    @Override
    void visitNotSchema(NotSchema notSchema) {
        Schema mustNotMatch = notSchema.getMustNotMatch();
        ValidationException failure = this.getFailureOfSchema(mustNotMatch, this.subject);
        if (failure == null) {
            this.failureReporter.failure("subject must not be valid against schema " + mustNotMatch, "not");
        }
    }

    @Override
    void visitReferenceSchema(ReferenceSchema referenceSchema) {
        Schema referredSchema = referenceSchema.getReferredSchema();
        if (referredSchema == null) {
            throw new IllegalStateException("referredSchema must be injected before validation");
        }
        ValidationException failure = this.getFailureOfSchema(referredSchema, this.subject);
        if (failure != null) {
            this.failureReporter.failure(failure);
        }
        if (this.validationListener != null) {
            this.validationListener.schemaReferenced(new SchemaReferencedEvent(referenceSchema, this.subject, referredSchema));
        }
    }

    @Override
    void visitObjectSchema(ObjectSchema objectSchema) {
        objectSchema.accept(new ObjectSchemaValidatingVisitor(this));
    }

    @Override
    void visitStringSchema(StringSchema stringSchema) {
        stringSchema.accept(new StringSchemaValidatingVisitor(this.subject, this));
    }

    @Override
    void visitCombinedSchema(CombinedSchema combinedSchema) {
        Collection<Schema> subschemas = combinedSchema.getSubschemas();
        ArrayList<ValidationException> failures = new ArrayList<ValidationException>(subschemas.size());
        CombinedSchema.ValidationCriterion criterion = combinedSchema.getCriterion();
        for (Schema subschema : subschemas) {
            ValidationException exception = this.getFailureOfSchema(subschema, this.subject);
            if (null != exception) {
                failures.add(exception);
            }
            this.reportSchemaMatchEvent(combinedSchema, subschema, exception);
        }
        int matchingCount = subschemas.size() - failures.size();
        try {
            criterion.validate(subschemas.size(), matchingCount);
        }
        catch (ValidationException e) {
            this.failureReporter.failure(new InternalValidationException(combinedSchema, new StringBuilder(e.getPointerToViolation()), e.getMessage(), failures, e.getKeyword(), combinedSchema.getSchemaLocation()));
        }
    }

    @Override
    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        conditionalSchema.accept(new ConditionalSchemaValidatingVisitor(this.subject, this));
    }

    private void reportSchemaMatchEvent(CombinedSchema schema, Schema subschema, ValidationException failure) {
        if (failure == null) {
            this.validationListener.combinedSchemaMatch(new CombinedSchemaMatchEvent(schema, subschema, this.subject));
        } else {
            this.validationListener.combinedSchemaMismatch(new CombinedSchemaMismatchEvent(schema, subschema, this.subject, failure));
        }
    }

    ValidationException getFailureOfSchema(Schema schema, Object input) {
        Object origSubject = this.subject;
        this.subject = input;
        ValidationException rval = this.failureReporter.inContextOfSchema(schema, () -> this.visit(schema));
        this.subject = origSubject;
        return rval;
    }

    void failIfErrorFound() {
        this.failureReporter.validationFinished();
    }

    void failure(String message, String keyword) {
        this.failureReporter.failure(message, keyword);
    }

    void failure(Class<?> expectedType, Object actualValue) {
        this.failureReporter.failure(expectedType, actualValue);
    }

    void failure(ValidationException exc) {
        this.failureReporter.failure(exc);
    }

    Object getFailureState() {
        return this.failureReporter.getState();
    }

    boolean isFailureStateChanged(Object olState) {
        return this.failureReporter.isChanged(olState);
    }

    <SE, E extends SE> void ifPassesTypeCheck(Class<E> expectedType, Function<Object, SE> castFn, boolean schemaRequiresType, Boolean nullable, Consumer<SE> onPass) {
        Object subject = this.subject;
        if (this.primitiveValidationStrategy == PrimitiveValidationStrategy.LENIENT) {
            boolean expectedString = expectedType.isAssignableFrom(String.class);
            if (subject instanceof String && !expectedString) {
                subject = StringToValueConverter.stringToValue((String)subject);
            } else if (expectedString) {
                subject = subject.toString();
            }
        }
        if (ValidatingVisitor.isNull(subject)) {
            if (schemaRequiresType && !Boolean.TRUE.equals(nullable)) {
                this.failureReporter.failure(expectedType, this.subject);
            }
            return;
        }
        if (TypeChecker.isAssignableFrom(expectedType, subject.getClass())) {
            onPass.accept(castFn.apply(subject));
            return;
        }
        if (schemaRequiresType) {
            this.failureReporter.failure(expectedType, this.subject);
        }
    }

    <E> void ifPassesTypeCheck(Class<E> expectedType, boolean schemaRequiresType, Boolean nullable, Consumer<E> onPass) {
        this.ifPassesTypeCheck(expectedType, expectedType::cast, schemaRequiresType, nullable, onPass);
    }
}

