/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema;

import java.util.Objects;
import net.gradleutil.conf.json.schema.InternalValidationException;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.ValidationException;

abstract class ValidationFailureReporter {
    protected Schema schema;

    ValidationFailureReporter(Schema schema) {
        this.schema = Objects.requireNonNull(schema, "schema cannot be null");
    }

    void failure(String message, String keyword) {
        this.failure(new InternalValidationException(this.schema, message, keyword, this.schema.getSchemaLocation()));
    }

    void failure(Class<?> expectedType, Object actualValue) {
        this.failure(new InternalValidationException(this.schema, expectedType, actualValue, "type", this.schema.getSchemaLocation()));
    }

    abstract void failure(ValidationException var1);

    ValidationException inContextOfSchema(Schema schema, Runnable task) {
        Objects.requireNonNull(schema, "schema cannot be null");
        Schema origSchema = this.schema;
        this.schema = schema;
        task.run();
        this.schema = origSchema;
        return null;
    }

    abstract void validationFinished();

    Object getState() {
        return null;
    }

    boolean isChanged(Object oldState) {
        return false;
    }
}

