/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema;

import net.gradleutil.conf.json.schema.DefaultValidator;
import net.gradleutil.conf.json.schema.PrimitiveValidationStrategy;
import net.gradleutil.conf.json.schema.ReadWriteContext;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.event.ValidationListener;

public interface Validator {
    public static ValidatorBuilder builder() {
        return new ValidatorBuilder();
    }

    public void performValidation(Schema var1, Object var2);

    public static class ValidatorBuilder {
        private boolean failEarly = false;
        private ReadWriteContext readWriteContext;
        private ValidationListener validationListener = ValidationListener.NOOP;
        private PrimitiveValidationStrategy primitiveValidationStrategy = PrimitiveValidationStrategy.STRICT;

        public ValidatorBuilder failEarly() {
            this.failEarly = true;
            return this;
        }

        public ValidatorBuilder readWriteContext(ReadWriteContext readWriteContext) {
            this.readWriteContext = readWriteContext;
            return this;
        }

        public ValidatorBuilder withListener(ValidationListener validationListener) {
            this.validationListener = validationListener;
            return this;
        }

        public ValidatorBuilder primitiveValidationStrategy(PrimitiveValidationStrategy primitiveValidationStrategy) {
            this.primitiveValidationStrategy = primitiveValidationStrategy;
            return this;
        }

        public Validator build() {
            return new DefaultValidator(this.failEarly, this.readWriteContext, this.validationListener, this.primitiveValidationStrategy);
        }
    }
}

