/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.event;

import java.util.Objects;
import net.gradleutil.conf.json.JSONObject;
import net.gradleutil.conf.json.JSONTokener;
import net.gradleutil.conf.json.schema.CombinedSchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.ValidationException;
import net.gradleutil.conf.json.schema.event.CombinedSchemaValidationEvent;
import net.gradleutil.conf.json.schema.event.MismatchEvent;

public class CombinedSchemaMismatchEvent
extends CombinedSchemaValidationEvent
implements MismatchEvent {
    private final ValidationException failure;

    public CombinedSchemaMismatchEvent(CombinedSchema schema, Schema subSchema, Object instance, ValidationException failure) {
        super(schema, subSchema, instance);
        this.failure = failure;
    }

    @Override
    public ValidationException getFailure() {
        return this.failure;
    }

    @Override
    void describeTo(JSONObject obj) {
        obj.put("type", "mismatch");
        obj.put("keyword", ((CombinedSchema)this.schema).getCriterion().toString());
        obj.put("subSchema", new JSONTokener(this.subSchema.toString()).nextValue());
        obj.put("failure", this.failure.toJSON());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CombinedSchemaMismatchEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CombinedSchemaMismatchEvent that = (CombinedSchemaMismatchEvent)o;
        return this.failure.equals(that.failure);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.failure);
    }

    @Override
    boolean canEqual(Object o) {
        return o instanceof CombinedSchemaMismatchEvent;
    }
}

