/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.gradleutil.conf.json.schema.FormatValidator;

public class URIFormatValidator
implements FormatValidator {
    private final boolean protocolRelativeURIPermitted;

    public URIFormatValidator() {
        this(true);
    }

    public URIFormatValidator(boolean protocolRelativeURIPermitted) {
        this.protocolRelativeURIPermitted = protocolRelativeURIPermitted;
    }

    @Override
    public Optional<String> validate(String subject) {
        try {
            URI uri;
            if (subject != null && (this.hasProtocol(uri = new URI(subject)) || this.protocolRelativeURIPermitted && this.isProtocolRelativeURI(subject))) {
                return Optional.empty();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Optional.of(String.format("[%s] is not a valid URI", subject));
    }

    @Deprecated
    protected Optional<String> failure(String subject) {
        return Optional.of(String.format("[%s] is not a valid URI", subject));
    }

    private boolean isProtocolRelativeURI(String subject) {
        return subject.startsWith("//");
    }

    private boolean hasProtocol(URI uri) {
        return uri.getScheme() != null;
    }

    @Override
    public String formatName() {
        return "uri";
    }
}

