/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.loader;

import java.util.Objects;
import net.gradleutil.conf.json.schema.ArraySchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.loader.JsonArray;
import net.gradleutil.conf.json.schema.loader.JsonObject;
import net.gradleutil.conf.json.schema.loader.JsonValue;
import net.gradleutil.conf.json.schema.loader.LoaderConfig;
import net.gradleutil.conf.json.schema.loader.LoadingState;
import net.gradleutil.conf.json.schema.loader.SchemaLoader;
import net.gradleutil.conf.json.schema.loader.SpecificationVersion;

class ArraySchemaLoader {
    private final LoadingState ls;
    private final LoaderConfig config;
    private final SchemaLoader defaultLoader;

    @Deprecated
    public ArraySchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this(ls, LoaderConfig.defaultV4Config(), defaultLoader);
    }

    ArraySchemaLoader(LoadingState ls, LoaderConfig config, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.config = Objects.requireNonNull(config, "config cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ArraySchema.Builder load() {
        ArraySchema.Builder builder = ArraySchema.builder();
        this.ls.schemaJson().maybe("minItems").map(JsonValue::requireInteger).ifPresent(builder::minItems);
        this.ls.schemaJson().maybe("maxItems").map(JsonValue::requireInteger).ifPresent(builder::maxItems);
        this.ls.schemaJson().maybe("uniqueItems").map(JsonValue::requireBoolean).ifPresent(builder::uniqueItems);
        this.ls.schemaJson().maybe("additionalItems").ifPresent(maybe -> maybe.canBe(Boolean.class, builder::additionalItems).or(JsonObject.class, obj -> builder.schemaOfAdditionalItems((Schema)this.defaultLoader.loadChild((JsonValue)obj).build())).requireAny());
        this.ls.schemaJson().maybe("items").ifPresent(items -> items.canBeSchema(itemSchema -> builder.allItemSchema((Schema)this.defaultLoader.loadChild((JsonValue)itemSchema).build())).or(JsonArray.class, arr -> this.buildTupleSchema(builder, (JsonArray)arr)).requireAny());
        if (this.config.specVersion != SpecificationVersion.DRAFT_4) {
            this.ls.schemaJson().maybe("contains").ifPresent(containedRawSchema -> this.addContainedSchema(builder, (JsonValue)containedRawSchema));
        }
        return builder;
    }

    private void addContainedSchema(ArraySchema.Builder builder, JsonValue schemaJson) {
        builder.containsItemSchema((Schema)this.defaultLoader.loadChild(schemaJson).build());
    }

    private void buildTupleSchema(ArraySchema.Builder builder, JsonArray itemSchema) {
        itemSchema.forEach((i, subschema) -> builder.addItemSchema((Schema)this.defaultLoader.loadChild(subschema).build()));
    }
}

