/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.gradleutil.conf.json.schema.CombinedSchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.loader.ExtractionResult;
import net.gradleutil.conf.json.schema.loader.JsonObject;
import net.gradleutil.conf.json.schema.loader.SchemaExtractor;
import net.gradleutil.conf.json.schema.loader.SchemaLoader;

class CombinedSchemaLoader
implements SchemaExtractor {
    private static final Map<String, CombinedSchemaProvider> COMB_SCHEMA_PROVIDERS = new HashMap<String, CombinedSchemaProvider>(3);
    private final SchemaLoader defaultLoader;

    public CombinedSchemaLoader(SchemaLoader defaultLoader) {
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    @Override
    public ExtractionResult extract(JsonObject schemaJson) {
        Set<String> presentKeys = COMB_SCHEMA_PROVIDERS.keySet().stream().filter(schemaJson::containsKey).collect(Collectors.toSet());
        Collection extractedSchemas = presentKeys.stream().map(key -> this.loadCombinedSchemaForKeyword(schemaJson, (String)key)).collect(Collectors.toList());
        return new ExtractionResult(presentKeys, extractedSchemas);
    }

    private CombinedSchema.Builder loadCombinedSchemaForKeyword(JsonObject schemaJson, String key) {
        ArrayList subschemas = new ArrayList();
        schemaJson.require(key).requireArray().forEach((i, subschema) -> subschemas.add(this.defaultLoader.loadChild(subschema).build()));
        return (CombinedSchema.Builder)COMB_SCHEMA_PROVIDERS.get(key).apply(subschemas);
    }

    static {
        COMB_SCHEMA_PROVIDERS.put("allOf", CombinedSchema::allOf);
        COMB_SCHEMA_PROVIDERS.put("anyOf", CombinedSchema::anyOf);
        COMB_SCHEMA_PROVIDERS.put("oneOf", CombinedSchema::oneOf);
    }

    @FunctionalInterface
    private static interface CombinedSchemaProvider
    extends Function<Collection<Schema>, CombinedSchema.Builder> {
    }
}

