/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.gradleutil.conf.json.schema.SchemaException;
import net.gradleutil.conf.json.schema.loader.JsonObjectIterator;
import net.gradleutil.conf.json.schema.loader.JsonValue;

class JsonObject
extends JsonValue {
    final Map<String, Object> storage;

    JsonObject(Map<String, Object> storage) {
        super(storage);
        this.storage = storage;
    }

    JsonValue childFor(String key) {
        return this.ls.childFor(key);
    }

    boolean containsKey(String key) {
        return this.storage.containsKey(key);
    }

    void require(String key, Consumer<JsonValue> consumer) {
        if (!this.storage.containsKey(key)) {
            throw this.failureOfMissingKey(key);
        }
        consumer.accept(this.childFor(key));
    }

    JsonValue require(String key) {
        return this.requireMapping(key, e -> e);
    }

    <R> R requireMapping(String key, Function<JsonValue, R> fn) {
        if (this.storage.containsKey(key)) {
            return fn.apply(this.childFor(key));
        }
        throw this.failureOfMissingKey(key);
    }

    private SchemaException failureOfMissingKey(String key) {
        return this.ls.createSchemaException(String.format("required key [%s] not found", key));
    }

    void maybe(String key, Consumer<JsonValue> consumer) {
        if (this.storage.containsKey(key)) {
            consumer.accept(this.childFor(key));
        }
    }

    Optional<JsonValue> maybe(String key) {
        return this.maybeMapping(key, JsonObject.identity());
    }

    <R> Optional<R> maybeMapping(String key, Function<JsonValue, R> fn) {
        if (this.storage.containsKey(key)) {
            return Optional.of(fn.apply(this.childFor(key)));
        }
        return Optional.empty();
    }

    void forEach(JsonObjectIterator iterator) {
        this.storage.entrySet().forEach((? super T entry) -> this.iterateOnEntry((Map.Entry<String, Object>)entry, iterator));
    }

    private void iterateOnEntry(Map.Entry<String, Object> entry, JsonObjectIterator iterator) {
        String key = entry.getKey();
        iterator.apply(key, this.childFor(key));
    }

    @Override
    public <R> R requireObject(Function<JsonObject, R> mapper) {
        return mapper.apply(this);
    }

    @Override
    protected Class<?> typeOfValue() {
        return JsonObject.class;
    }

    @Override
    protected Object value() {
        return this;
    }

    @Override
    protected Object unwrap() {
        return new HashMap<String, Object>(this.storage);
    }

    Map<String, Object> toMap() {
        if (this.storage == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.storage);
    }

    boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.storage.keySet());
    }

    public Object get(String name) {
        return this.storage.get(name);
    }
}

