/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.loader;

import java.util.Objects;
import net.gradleutil.conf.json.schema.ObjectSchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.loader.JsonArray;
import net.gradleutil.conf.json.schema.loader.JsonObject;
import net.gradleutil.conf.json.schema.loader.JsonValue;
import net.gradleutil.conf.json.schema.loader.LoaderConfig;
import net.gradleutil.conf.json.schema.loader.LoadingState;
import net.gradleutil.conf.json.schema.loader.SchemaLoader;
import net.gradleutil.conf.json.schema.loader.SpecificationVersion;
import net.gradleutil.conf.json.schema.regexp.Regexp;

class ObjectSchemaLoader {
    private final LoadingState ls;
    private final LoaderConfig config;
    private final SchemaLoader defaultLoader;

    public ObjectSchemaLoader(LoadingState ls, LoaderConfig config, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.config = Objects.requireNonNull(config, "config cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ObjectSchema.Builder load() {
        ObjectSchema.Builder builder = ObjectSchema.builder();
        this.ls.schemaJson().maybe("minProperties").map(JsonValue::requireInteger).ifPresent(builder::minProperties);
        this.ls.schemaJson().maybe("maxProperties").map(JsonValue::requireInteger).ifPresent(builder::maxProperties);
        this.ls.schemaJson().maybe("properties").map(JsonValue::requireObject).ifPresent(propertyDefs -> this.populatePropertySchemas((JsonObject)propertyDefs, builder));
        this.ls.schemaJson().maybe("additionalProperties").ifPresent(rawAddProps -> rawAddProps.canBe(Boolean.class, p -> builder.additionalProperties((boolean)p)).or(JsonObject.class, def -> builder.schemaOfAdditionalProperties((Schema)this.defaultLoader.loadChild((JsonValue)def).build())).requireAny());
        this.ls.schemaJson().maybe("required").map(JsonValue::requireArray).ifPresent(arr -> arr.forEach((i, val) -> builder.addRequiredProperty(val.requireString())));
        this.ls.schemaJson().maybe("patternProperties").map(JsonValue::requireObject).ifPresent(patternProps -> patternProps.keySet().forEach(pattern -> {
            Object patternSchema = this.defaultLoader.loadChild(patternProps.require((String)pattern)).build();
            Regexp regexp = this.ls.config.regexpFactory.createHandler((String)pattern);
            builder.patternProperty(regexp, (Schema)patternSchema);
        }));
        this.ls.schemaJson().maybe("dependencies").map(JsonValue::requireObject).ifPresent(deps -> this.addDependencies(builder, (JsonObject)deps));
        if (this.ls.specVersion().isAtLeast(SpecificationVersion.DRAFT_6)) {
            this.ls.schemaJson().maybe("propertyNames").map(this.defaultLoader::loadChild).map(Schema.Builder::build).ifPresent(builder::propertyNameSchema);
        }
        return builder;
    }

    private void populatePropertySchemas(JsonObject propertyDefs, ObjectSchema.Builder builder) {
        propertyDefs.forEach((key, value) -> {
            if (!key.equals(this.ls.specVersion().idKeyword()) || value instanceof JsonObject) {
                this.addPropertySchemaDefinition(key, value, builder);
            }
        });
    }

    private void addPropertySchemaDefinition(String keyOfObj, JsonValue definition, ObjectSchema.Builder builder) {
        builder.addPropertySchema(keyOfObj, (Schema)this.defaultLoader.loadChild(definition).build());
    }

    private void addDependencies(ObjectSchema.Builder builder, JsonObject deps) {
        deps.forEach((ifPresent, mustBePresent) -> this.addDependency(builder, ifPresent, mustBePresent));
    }

    private void addDependency(ObjectSchema.Builder builder, String ifPresent, JsonValue deps) {
        deps.canBeSchema(obj -> builder.schemaDependency(ifPresent, (Schema)this.defaultLoader.loadChild((JsonValue)obj).build())).or(JsonArray.class, arr -> arr.forEach((i, entry) -> builder.propertyDependency(ifPresent, entry.requireString()))).requireAny();
    }
}

