/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.loader;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.gradleutil.conf.json.schema.FormatValidator;
import net.gradleutil.conf.json.schema.StringSchema;
import net.gradleutil.conf.json.schema.loader.JsonValue;
import net.gradleutil.conf.json.schema.loader.LoadingState;
import net.gradleutil.conf.json.schema.loader.SpecificationVersion;

public class StringSchemaLoader {
    private LoadingState ls;
    private Map<String, FormatValidator> formatValidators;

    @Deprecated
    public StringSchemaLoader(LoadingState ls) {
        this(ls, SpecificationVersion.DRAFT_4.defaultFormatValidators());
    }

    StringSchemaLoader(LoadingState ls, Map<String, FormatValidator> formatValidators) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.formatValidators = Collections.unmodifiableMap(Objects.requireNonNull(formatValidators, "formatValidators cannot be null"));
    }

    public StringSchema.Builder load() {
        StringSchema.Builder builder = StringSchema.builder();
        this.ls.schemaJson().maybe("minLength").map(JsonValue::requireInteger).ifPresent(builder::minLength);
        this.ls.schemaJson().maybe("maxLength").map(JsonValue::requireInteger).ifPresent(builder::maxLength);
        this.ls.schemaJson().maybe("pattern").map(JsonValue::requireString).map(this.ls.config.regexpFactory::createHandler).ifPresent(builder::pattern);
        this.ls.schemaJson().maybe("format").map(JsonValue::requireString).ifPresent(format -> this.addFormatValidator(builder, (String)format));
        return builder;
    }

    private void addFormatValidator(StringSchema.Builder builder, String formatName) {
        FormatValidator formatValidator = this.formatValidators.get(formatName);
        if (formatValidator != null) {
            builder.formatValidator(formatValidator);
        }
    }
}

