/*
 * Decompiled with CFR 0.152.
 */
package net.gradleutil.conf.json.schema.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.gradleutil.conf.json.schema.BooleanSchema;
import net.gradleutil.conf.json.schema.CombinedSchema;
import net.gradleutil.conf.json.schema.NullSchema;
import net.gradleutil.conf.json.schema.Schema;
import net.gradleutil.conf.json.schema.SchemaException;
import net.gradleutil.conf.json.schema.loader.AbstractSchemaExtractor;
import net.gradleutil.conf.json.schema.loader.JsonArray;
import net.gradleutil.conf.json.schema.loader.SchemaLoader;

class TypeBasedSchemaExtractor
extends AbstractSchemaExtractor {
    TypeBasedSchemaExtractor(SchemaLoader defaultLoader) {
        super(defaultLoader);
    }

    @Override
    List<Schema.Builder<?>> extract() {
        if (this.containsKey("type")) {
            return Collections.singletonList(this.require("type").canBeMappedTo(JsonArray.class, arr -> this.buildAnyOfSchemaForMultipleTypes()).orMappedTo(String.class, this::loadForExplicitType).requireAny());
        }
        return Collections.emptyList();
    }

    private CombinedSchema.Builder buildAnyOfSchemaForMultipleTypes() {
        JsonArray subtypeJsons = this.require("type").requireArray();
        ArrayList<Schema> subschemas = new ArrayList<Schema>(subtypeJsons.length());
        subtypeJsons.forEach((j, raw) -> subschemas.add((Schema)this.loadForExplicitType(raw.requireString()).build()));
        return CombinedSchema.anyOf(subschemas);
    }

    private Schema.Builder<?> loadForExplicitType(String typeString) {
        switch (typeString) {
            case "string": {
                return this.buildStringSchema().requiresString(true);
            }
            case "integer": {
                return this.buildNumberSchema().requiresInteger(true);
            }
            case "number": {
                return this.buildNumberSchema();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return this.buildArraySchema();
            }
            case "object": {
                return this.buildObjectSchema();
            }
        }
        throw new SchemaException(this.schemaJson.ls.locationOfCurrentObj(), String.format("unknown type: [%s]", typeString));
    }
}

