/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.util;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;

public abstract class EnumConverter<E extends Enum<E>>
implements ValueConverter<E> {
    private final Class<E> clazz;
    private String delimiters = "[,]";

    protected EnumConverter(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public E convert(String value) {
        try {
            return Enum.valueOf(this.valueType(), value);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConversionException(this.message(value), e);
        }
    }

    @Override
    public Class<E> valueType() {
        return this.clazz;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    @Override
    public String valuePattern() {
        EnumSet<E> values = EnumSet.allOf(this.valueType());
        StringBuilder builder = new StringBuilder();
        builder.append(this.delimiters.charAt(0));
        Iterator i = values.iterator();
        while (i.hasNext()) {
            builder.append(((Enum)i.next()).toString());
            if (!i.hasNext()) continue;
            builder.append(this.delimiters.charAt(1));
        }
        builder.append(this.delimiters.charAt(2));
        return builder.toString();
    }

    private String message(String value) {
        ResourceBundle bundle2 = ResourceBundle.getBundle("joptsimple.ExceptionMessages");
        Object[] arguments = new Object[]{value, this.valuePattern()};
        String template = bundle2.getString(EnumConverter.class.getName() + ".message");
        return new MessageFormat(template).format(arguments);
    }
}

