/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.regex.Pattern;
import runwar.AgentLoader;
import runwar.logging.Logger;

final class AgentInitialization {
    private static final Pattern JAR_REGEX = Pattern.compile(".*[railo|lucee]-(inst|external.agent)+[-.\\d]*.jar");
    private static Logger log = Logger.getLogger("RunwarLogger");

    AgentInitialization() {
    }

    boolean loadAgentFromLocalJarFile(File file) {
        String string = System.getProperty("java.specification.version");
        if (!"1.6 1.7 1.8 1.9".contains(string)) {
            throw new IllegalStateException("This app requires a Java 6+ VM");
        }
        log.debug("Trying to load java agent from local jar file");
        String string2 = "";
        if (file != null && file.exists()) {
            log.debug("Trying first:" + file.getAbsolutePath());
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (JAR_REGEX.matcher(file2.getPath()).matches()) {
                    string2 = file2.getAbsolutePath();
                    break;
                }
                ++n2;
            }
        } else {
            string2 = this.discoverPathToJarFile();
        }
        if (string2 != null && string2.length() > 0) {
            log.debug("Loading agent from:" + string2);
            return new AgentLoader(string2).loadAgent();
        }
        log.warn("The agent loader was not found for auto-initialization");
        string2 = this.discoverPathToJarFile();
        if (string2 != null && string2.length() > 0) {
            log.debug("Loading internal lucee agent from " + string2);
            return new AgentLoader(string2).loadAgent();
        }
        return false;
    }

    private String discoverPathToJarFile() {
        log.debug("Searching for java agent");
        String string = this.findPathToJarFileFromClasspath();
        if (string == null) {
            string = this.getPathToJarFileContainingThisClass();
        }
        if (string != null) {
            return string;
        }
        log.warn("The agent jar was not found in the classpath!");
        System.out.println("The agent jar was not found in the classpath!");
        return null;
    }

    private String findPathToJarFileFromClasspath() {
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        log.debug("Trying to load java agent from classpath");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (JAR_REGEX.matcher(string).matches()) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    private String getPathToJarFileContainingThisClass() {
        CodeSource codeSource = AgentInitialization.class.getProtectionDomain().getCodeSource();
        log.debug("Trying to load java agent from jar containing this class");
        if (codeSource == null) {
            return null;
        }
        String string = "";
        try {
            URI uRI = codeSource.getLocation().toURI();
            String string2 = Paths.get(uRI).toString();
            string = string2.endsWith(".jar") ? this.findLocalJarOrZipFileFromLocationOfCurrentClassFile(string2) : this.findJarFileContainingCurrentClass(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return string;
    }

    private String findLocalJarOrZipFileFromLocationOfCurrentClassFile(String string) {
        File file;
        log.debug("Trying to load java agent from location of current class file");
        File file2 = new File(string).getParentFile();
        File[] fileArray = file2.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (JAR_REGEX.matcher(file.getPath()).matches()) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        file = new File(string.replace("classes/", "META-INF.zip"));
        log.debug("Trying to load java agent from " + file.getPath());
        return file.getPath();
    }

    private String findJarFileContainingCurrentClass(URI uRI) {
        if (!"file".equals(uRI.getScheme())) {
            String string = Paths.get(uRI).toString();
            int n = string.indexOf(58);
            return string.substring(n + 2);
        }
        return Paths.get(uRI).toString();
    }
}

