/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.jboss.logging.Logger;
import sun.tools.attach.BsdVirtualMachine;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

final class AgentLoader {
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public VirtualMachine attachVirtualMachine(String string) {
            return null;
        }

        @Override
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };
    private final String jarFilePath;
    private final String pid;
    private static Logger log = Logger.getLogger("RunwarLogger");

    AgentLoader(String string) {
        this.jarFilePath = string;
        this.pid = this.discoverProcessIdForRunningVM();
    }

    private String discoverProcessIdForRunningVM() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf(64);
        return string.substring(0, n);
    }

    boolean loadAgent() {
        VirtualMachine virtualMachine = AttachProvider.providers().isEmpty() ? this.getVirtualMachineImplementationFromEmbeddedOnes() : this.attachToThisVM();
        if (virtualMachine != null) {
            this.loadAgentAndDetachFromThisVM(virtualMachine);
            return true;
        }
        return false;
    }

    private VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes() {
        try {
            if (File.separatorChar == '\\') {
                return new WindowsVirtualMachine(ATTACH_PROVIDER, this.pid);
            }
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux") || string.startsWith("LINUX")) {
                return new LinuxVirtualMachine(ATTACH_PROVIDER, this.pid);
            }
            if (string.startsWith("Mac OS X")) {
                return new BsdVirtualMachine(ATTACH_PROVIDER, this.pid);
            }
            if (string.startsWith("Solaris")) {
                return new SolarisVirtualMachine(ATTACH_PROVIDER, this.pid);
            }
        }
        catch (Exception exception) {
            log.warn(exception.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            log.warn(unsatisfiedLinkError.getMessage());
        }
        return null;
    }

    private VirtualMachine attachToThisVM() {
        try {
            return VirtualMachine.attach(this.pid);
        }
        catch (Exception exception) {
            log.warn(exception.getMessage());
            return null;
        }
    }

    private void loadAgentAndDetachFromThisVM(VirtualMachine virtualMachine) {
        try {
            virtualMachine.loadAgent(this.jarFilePath, null);
            virtualMachine.detach();
        }
        catch (Exception exception) {
            System.err.println("Could not load agent. Error: " + exception.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Could not load agent. Error: " + unsatisfiedLinkError.getMessage());
        }
    }
}

