/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import runwar.Server;
import runwar.Start;
import runwar.logging.Logger;
import runwar.options.ServerOptions;

public class LaunchUtil {
    private static TrayIcon trayIcon;
    private static Logger log;
    private static boolean relaunching;
    private static final int KB = 1024;
    public static final Set<String> replicateProps;

    static {
        log = Logger.getLogger("RunwarLogger");
        replicateProps = new HashSet<String>(Arrays.asList("cfml.cli.home", "cfml.server.config.dir", "cfml.web.config.dir", "cfml.server.trayicon", "cfml.server.dockicon"));
    }

    public static File getJreExecutable() throws FileNotFoundException {
        String string = System.getProperty("java.home");
        if (string == null) {
            throw new IllegalStateException("java.home");
        }
        String string2 = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java" + (File.separator.equals("\\") ? ".exe" : "");
        File file = new File(string2);
        if (!file.isFile()) {
            throw new FileNotFoundException(file.toString());
        }
        return file;
    }

    public static File getJarDir(Class<?> clazz) {
        URL uRL;
        try {
            uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException securityException) {
            uRL = clazz.getResource(String.valueOf(clazz.getSimpleName()) + ".class");
        }
        String string = uRL.toExternalForm();
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.lastIndexOf("/"));
        } else {
            String string2 = "/" + clazz.getName().replace(".", "/") + ".class";
            if ((string = string.replace(string2, "")).startsWith("jar:") && string.endsWith(".jar!")) {
                string = string.substring(4, string.lastIndexOf("/"));
            }
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            return new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }

    public static void launch(List<String> list, int n) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        Thread.sleep(500L);
        InputStream inputStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        log.debug("launching: " + list.toString());
        log.debug("timeout of " + n / 1000 + " seconds");
        int n2 = -1;
        long l = System.currentTimeMillis();
        System.out.print("Starting in background - ");
        while (System.currentTimeMillis() - l < (long)n) {
            String string;
            if (bufferedReader.ready() && (string = bufferedReader.readLine()) != null) {
                try {
                    n2 = process.exitValue();
                    if (n2 == 0) {
                        while ((string = bufferedReader.readLine()) != null) {
                            log.debug(string);
                        }
                        System.exit(0);
                    } else if (n2 == 1) {
                        System.out.println();
                        LaunchUtil.printExceptionLine(string);
                        while ((string = bufferedReader.readLine()) != null) {
                            LaunchUtil.printExceptionLine(string);
                        }
                        System.exit(1);
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    LaunchUtil.processOutout(string, process);
                }
            }
            Thread.sleep(100L);
        }
        if (System.currentTimeMillis() - l > (long)n) {
            process.destroy();
            System.out.println();
            System.err.println("ERROR: Startup exceeded timeout of " + n / 1000 + " seconds - aborting!");
            System.exit(1);
        }
        System.out.println("Server is up - ");
        System.exit(0);
    }

    private static boolean processOutout(String string, Process process) {
        log.info("processoutput: " + string);
        if (string.indexOf("Server is up - ") != -1) {
            System.out.println(string);
            System.exit(0);
        } else if (string.indexOf("Exception in thread \"main\" java.lang.RuntimeException") != -1) {
            return true;
        }
        return false;
    }

    public static void printExceptionLine(String string) {
        log.debug(string);
        String string2 = string.contains("java.lang.RuntimeException: ") ? string.substring(string.indexOf("java.lang.RuntimeException: ") + "java.lang.RuntimeException: ".length()) : string;
        String string3 = string2 = string2.matches("^\\s+at runwar.Start.*") ? "" : string2.trim();
        if (string2.length() > 0) {
            System.err.println(string2);
        }
    }

    public static void relaunchAsBackgroundProcess(int n, String[] stringArray, String string) {
        try {
            if (relaunching) {
                return;
            }
            relaunching = true;
            String string2 = LaunchUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            log.info("Starting background " + string + " from: " + string2 + " ");
            String string3 = URLDecoder.decode(string2, "UTF-8");
            string3 = new File(string3).getPath();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(LaunchUtil.getJreExecutable().toString());
            List<String> list = LaunchUtil.getCurrentVMArgs();
            for (String string4 : list) {
                arrayList.add(string4);
            }
            arrayList.add("-jar");
            for (String string4 : replicateProps) {
                String string5 = System.getProperty(string4);
                if (string5 == null) continue;
                arrayList.add("-D" + string4 + "=" + string5);
            }
            arrayList.add(string3);
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4;
                string4 = stringArray2[n3];
                arrayList.add(string4);
                ++n3;
            }
            LaunchUtil.launch(arrayList, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void appendToBuffer(List<String> list, StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            list.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
    }

    public static List<String> getCurrentVMArgs() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        return list;
    }

    public static String[] tokenizeArgs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            int n = string.length();
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '\"') {
                    LaunchUtil.appendToBuffer(arrayList, stringBuffer);
                    bl = !bl;
                } else if (c == '\\') {
                    if (n > n2 + 1 && (string.charAt(n2 + 1) == '\"' || string.charAt(n2 + 1) == '\\')) {
                        stringBuffer.append(string.charAt(n2 + 1));
                        ++n2;
                    } else {
                        stringBuffer.append("\\");
                    }
                } else if (bl) {
                    stringBuffer.append(c);
                } else if (Character.isWhitespace(c)) {
                    LaunchUtil.appendToBuffer(arrayList, stringBuffer);
                } else {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            LaunchUtil.appendToBuffer(arrayList, stringBuffer);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static void hookTray(Server server) {
        ServerOptions serverOptions = Server.getServerOptions();
        String string = serverOptions.getIconImage();
        String string2 = serverOptions.getHost();
        int n = serverOptions.getPortNumber();
        int n2 = serverOptions.getSocketNumber();
        String string3 = serverOptions.getProcessName();
        String string4 = server.getPID();
        if (SystemTray.isSupported()) {
            Image image = LaunchUtil.getIconImage(string);
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            };
            trayIcon = new TrayIcon(image, String.valueOf(string3) + " server on " + string2 + ":" + n + " PID:" + string4);
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = null;
            JSONArray jSONArray = serverOptions.getTrayConfig() != null ? (JSONArray)JSONValue.parse(LaunchUtil.readFile(serverOptions.getTrayConfig())) : (JSONArray)JSONValue.parse(LaunchUtil.getResourceAsString("runwar/taskbar.json"));
            if (jSONArray == null) {
                log.error("Could not load taskbar properties");
                jSONArray = (JSONArray)JSONValue.parse("[{label:\"Stop Server (${runwar.processName})\", action:\"stopserver\"},{label:\"Open Browser\", action:\"openbrowser\", url:\"http://${runwar.host}:${runwar.port}/\"}]");
            }
            for (Object e : jSONArray) {
                JSONObject jSONObject = (JSONObject)e;
                String string5 = LaunchUtil.replaceMenuTokens(jSONObject.get("label").toString(), string3, string2, n, n2);
                String string6 = jSONObject.get("action").toString();
                menuItem = new MenuItem(string5);
                if (string6.toLowerCase().equals("stopserver")) {
                    menuItem.addActionListener(new ExitActionListener());
                } else if (string6.toLowerCase().equals("openbrowser")) {
                    String string7 = LaunchUtil.replaceMenuTokens(jSONObject.get("url").toString(), string3, string2, n, n2);
                    menuItem.addActionListener(new OpenBrowserActionListener(string7));
                } else {
                    log.error("Unknown menu item action \"" + string6 + "\" for \"" + string5 + "\"");
                }
                popupMenu.add(menuItem);
            }
            trayIcon.setPopupMenu(popupMenu);
            trayIcon.setImageAutoSize(true);
            trayIcon.addMouseListener(mouseListener);
            try {
                SystemTray.getSystemTray().add(trayIcon);
            }
            catch (AWTException aWTException) {
                System.err.println("TrayIcon could not be added.");
            }
        } else {
            log.warn("System Tray is not supported");
        }
    }

    public static void unhookTray() {
        if (SystemTray.isSupported() && trayIcon != null) {
            try {
                log.debug("Removing tray icon");
                SystemTray.getSystemTray().remove(trayIcon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Image getIconImage(String string) {
        Image image = null;
        if (string != null && string.length() != 0) {
            string = string.replaceAll("(^\")|(\"$)", "");
            log.debug("trying to load icon: " + string);
            if (string.contains("!")) {
                String[] stringArray = string.split("!");
                try {
                    ZipFile zipFile = new ZipFile(stringArray[0]);
                    ZipEntry zipEntry = zipFile.getEntry(stringArray[1].replaceFirst("^[\\/]", ""));
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    image = ImageIO.read(inputStream);
                    zipFile.close();
                    log.debug("loaded image from archive: " + stringArray[0] + stringArray[1]);
                }
                catch (IOException iOException) {
                    log.debug("Could not get zip resource: " + string + "(" + iOException.getMessage() + ")");
                }
            } else if (new File(string).exists()) {
                try {
                    image = ImageIO.read(new File(string));
                }
                catch (IOException iOException) {
                    log.debug("Could not get file resource: " + string + "(" + iOException.getMessage() + ")");
                }
            } else {
                log.debug("trying parent loader for image: " + string);
                URL uRL = LaunchUtil.class.getClassLoader().getParent().getResource(string);
                if (uRL == null) {
                    log.debug("trying loader for image: " + string);
                    uRL = LaunchUtil.class.getClassLoader().getResource(string);
                }
                if (uRL != null) {
                    log.debug("Trying getImage for: " + uRL);
                    image = Toolkit.getDefaultToolkit().getImage(uRL);
                }
            }
        } else {
            image = Toolkit.getDefaultToolkit().getImage(Start.class.getResource("/runwar/icon.png"));
        }
        if (image == null) {
            log.debug("Bad image, using default.");
            image = Toolkit.getDefaultToolkit().getImage(Start.class.getResource("/runwar/icon.png"));
        }
        return image;
    }

    private static String replaceMenuTokens(String string, String string2, String string3, int n, int n2) {
        string = string.replaceAll("\\$\\{runwar.port\\}", Integer.toString(n)).replaceAll("\\$\\{runwar.processName\\}", string2).replaceAll("\\$\\{runwar.host\\}", string3).replaceAll("\\$\\{runwar.stopsocket\\}", Integer.toString(n2));
        return string;
    }

    public static void openURL(String string) {
        String string2 = System.getProperty("os.name");
        if (string == null) {
            System.out.println("ERROR: No URL specified to open the browser to!");
            return;
        }
        try {
            System.out.println(string);
            if (string2.startsWith("Mac OS")) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", String.class);
                method.invoke(null, string);
            } else if (string2.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else {
                String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String string3 = null;
                int n = 0;
                while (n < stringArray.length && string3 == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", stringArray[n]}).waitFor() == 0) {
                        string3 = stringArray[n];
                    }
                    ++n;
                }
                if (string3 == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{string3, string});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, String.valueOf(exception.getMessage()) + ":\n" + exception.getLocalizedMessage());
        }
    }

    public static String getResourceAsString(String string) {
        return LaunchUtil.readStream(LaunchUtil.class.getClassLoader().getResourceAsStream(string));
    }

    public static void unzipInteralZip(ClassLoader classLoader, String string, File file, boolean bl) {
        if (bl) {
            System.out.println("Extracting " + string);
        }
        file.mkdir();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            System.err.println("Could not find the " + string + " on classpath!");
            System.exit(1);
        }
        LaunchUtil.unzipResource(uRL, file, bl);
    }

    public static void unzipResource(URL uRL, File file, boolean bl) {
        Timer timer = new Timer();
        class PrintDot
        extends TimerTask {
            PrintDot() {
            }

            @Override
            public void run() {
                System.out.print(".");
            }
        }
        PrintDot printDot = new PrintDot();
        timer.schedule((TimerTask)printDot, 0L, 2000L);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            JarInputStream jarInputStream = new JarInputStream(bufferedInputStream);
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                File file2 = new File(String.valueOf(file.toString()) + File.separator + jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                File file3 = new File(file2.getParent());
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                LaunchUtil.writeStreamTo(jarInputStream, fileOutputStream, 8192);
                if (file2.getPath().endsWith("pack.gz")) {
                    LaunchUtil.unpack(file2);
                    fileOutputStream.close();
                    file2.delete();
                }
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            printDot.cancel();
            exception.printStackTrace();
        }
        printDot.cancel();
    }

    public static void cleanUpUnpacked(File file) {
        if (file.exists() && file.listFiles(new ExtFilter(".gz")).length > 0) {
            File[] fileArray = file.listFiles(new ExtFilter(".gz"));
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                try {
                    file2.delete();
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
    }

    public static void removePreviousLibs(File file) {
        if (file.exists() && file.listFiles(new ExtFilter(".jar")).length > 0) {
            File[] fileArray = file.listFiles(new ExtFilter(".jar"));
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    System.err.println("Could not delete previous lib: " + file2.getAbsolutePath());
                }
                ++n2;
            }
        }
    }

    public static void unpack(File file) {
        block21: {
            DeflaterOutputStream deflaterOutputStream = null;
            InputStream inputStream = null;
            String string = file.getPath();
            String string2 = string.endsWith(".pack.gz") ? string.substring(0, string.length() - 8) : (string.endsWith(".pack") ? string.substring(0, string.length() - 5) : String.valueOf(string) + ".unpacked");
            try {
                try {
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    deflaterOutputStream = new JarOutputStream(new FileOutputStream(string2));
                    inputStream = new FileInputStream(string);
                    if (string.endsWith(".gz")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    unpacker.unpack(inputStream, (JarOutputStream)deflaterOutputStream);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {
                            System.err.println("Error closing file: " + iOException2.getMessage());
                        }
                    }
                    if (deflaterOutputStream == null) break block21;
                    try {
                        deflaterOutputStream.flush();
                        ((ZipOutputStream)deflaterOutputStream).close();
                    }
                    catch (IOException iOException3) {
                        System.err.println("Error closing file: " + iOException3.getMessage());
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("Error closing file: " + iOException.getMessage());
                    }
                }
                if (deflaterOutputStream != null) {
                    try {
                        deflaterOutputStream.flush();
                        ((ZipOutputStream)deflaterOutputStream).close();
                    }
                    catch (IOException iOException) {
                        System.err.println("Error closing file: " + iOException.getMessage());
                    }
                }
            }
        }
    }

    public static void copyInternalFile(ClassLoader classLoader, String string, File file) {
        URL uRL = classLoader.getResource(string);
        try {
            LaunchUtil.copyStream(uRL.openStream(), file);
        }
        catch (IOException iOException) {
            log.error(iOException);
        }
    }

    public static String readStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        block18: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            try {
                try {
                    int n;
                    while ((n = inputStream.read()) != -1) {
                        printStream.print((char)n);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (printStream != null) {
                            printStream.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (printStream != null) {
                        printStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byteArrayOutputStream.toString();
    }

    public static String readFile(File file) {
        try {
            return LaunchUtil.readStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException);
            return null;
        }
    }

    public static void copyFile(File file, File file2) {
        try {
            LaunchUtil.copyStream(new FileInputStream(file), file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException);
        }
    }

    public static void copyStream(InputStream inputStream, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LaunchUtil.writeStreamTo(inputStream, fileOutputStream, 8192);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException);
        }
    }

    public static int writeStreamTo(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2 = Math.min(inputStream.available(), 262144);
        byte[] byArray = new byte[Math.max(n, n2)];
        int n3 = 0;
        int n4 = inputStream.read(byArray);
        while (n4 >= 0) {
            outputStream.write(byArray, 0, n4);
            n3 += n4;
            n4 = inputStream.read(byArray);
        }
        return n3;
    }

    public static void deleteRecursive(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                LaunchUtil.deleteRecursive(file2);
                ++n2;
            }
        }
        if (!file.delete()) {
            System.err.println("Could not delete file: " + file.getAbsolutePath());
        }
    }

    private static class ExitActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                System.out.println("Exiting...");
                System.exit(0);
            }
            catch (Exception exception) {
                trayIcon.displayMessage("Error", exception.getMessage(), TrayIcon.MessageType.INFO);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                System.exit(1);
            }
        }
    }

    public static class ExtFilter
    implements FilenameFilter {
        private String ext;

        public ExtFilter(String string) {
            this.ext = string;
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(this.ext);
        }
    }

    private static class OpenBrowserActionListener
    implements ActionListener {
        private String url;

        public OpenBrowserActionListener(String string) {
            this.url = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            trayIcon.displayMessage("Browser", "Opening browser", TrayIcon.MessageType.INFO);
            LaunchUtil.openURL(this.url);
        }
    }

    public static class PrefixFilter
    implements FilenameFilter {
        private String prefix;

        public PrefixFilter(String string) {
            this.prefix = string;
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().startsWith(this.prefix);
        }
    }
}

