/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import runwar.LaunchUtil;
import runwar.Server;
import runwar.Start;

public final class RunEmbeddedWar {
    private static String WAR_POSTFIX = ".war";
    private static String WAR_NAME = "cfdistro";
    private static String WAR_FILENAME = String.valueOf(WAR_NAME) + WAR_POSTFIX;

    public static void main(String[] stringArray) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string = "runwar.properties";
        InputStream inputStream = classLoader.getResourceAsStream(string);
        Properties properties = new Properties();
        properties.load(inputStream);
        WAR_NAME = properties.getProperty("war.name");
        WAR_POSTFIX = ".war";
        WAR_FILENAME = String.valueOf(WAR_NAME) + WAR_POSTFIX;
        System.out.println(properties.toString());
        System.out.println("Starting...");
        File file = new File(RunEmbeddedWar.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
        File file2 = new File(String.valueOf(file.getCanonicalPath()) + "/" + WAR_FILENAME);
        File file3 = new File(String.valueOf(file.getCanonicalPath()) + "/" + WAR_NAME);
        if (file3.exists()) {
            System.out.println("Not extracting, as WAR directory already exists: " + file3.getCanonicalPath());
        } else {
            file3.mkdir();
            System.out.println("Extracting " + WAR_FILENAME + " to " + file2 + " ...");
            LaunchUtil.unzipInteralZip(classLoader, WAR_FILENAME, file3, false);
            System.out.println("Extracted " + WAR_FILENAME);
            LaunchUtil.copyInternalFile(classLoader, "server.json", new File(file, "server.json"));
        }
        System.out.println("Launching server...");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.add("-c");
        arrayList.add(new File(file, "server.json").getCanonicalPath());
        System.out.println(arrayList);
        if (properties.getProperty("open.url") != null) {
            new Server(3);
        }
        Start.main(arrayList.toArray(new String[arrayList.size()]));
    }
}

