/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.xnio.IoUtils;
import runwar.logging.Logger;

public class SSLUtil {
    private static Logger log = Logger.getLogger("RunwarLogger");
    private static final String SERVER_KEY_STORE = "runwar/runwar.keystore";
    private static final String SERVER_TRUST_STORE = "runwar/runwar.truststore";
    private static final char[] STORE_PASSWORD = "password".toCharArray();

    public static SSLContext createSSLContext() throws IOException {
        log.debug("Creating SSL context from: runwar/runwar.keystore trust store: runwar/runwar.truststore");
        return SSLUtil.createSSLContext(SSLUtil.loadKeyStore(SERVER_KEY_STORE), SSLUtil.loadKeyStore(SERVER_TRUST_STORE));
    }

    public static SSLContext createSSLContext(File file, File file2, char[] cArray) throws IOException {
        log.debug("Creating SSL context from cert: " + file + " key: " + file2);
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLUtil.createSSLContext(SSLUtil.keystoreFromDERCertificate(file, file2, cArray), SSLUtil.loadKeyStore(SERVER_TRUST_STORE));
        }
        catch (Exception exception) {
            throw new IOException("Could not load certificate", exception);
        }
        return sSLContext;
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore keyStore2) throws IOException {
        Object object;
        KeyManager[] keyManagerArray;
        TrustManager[] trustManagerArray;
        try {
            trustManagerArray = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerArray.init(keyStore, STORE_PASSWORD);
            keyManagerArray = trustManagerArray.getKeyManagers();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Unable to initialise KeyManager[]", noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new IOException("Unable to initialise KeyManager[]", unrecoverableKeyException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException("Unable to initialise KeyManager[]", keyStoreException);
        }
        trustManagerArray = null;
        try {
            object = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init(keyStore2);
            trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Unable to initialise TrustManager[]", noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException("Unable to initialise TrustManager[]", keyStoreException);
        }
        try {
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(keyManagerArray, trustManagerArray, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Unable to create and initialise the SSLContext", noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new IOException("Unable to create and initialise the SSLContext", keyManagementException);
        }
        return object;
    }

    private static KeyStore loadKeyStore(String string) throws IOException {
        InputStream inputStream = SSLUtil.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(String.format("Unable to load KeyStore from classpath %s", string));
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inputStream, STORE_PASSWORD);
            log.debug("loaded store: " + string);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception exception) {
            throw new IOException(String.format("Unable to load KeyStore %s", string), exception);
        }
        finally {
            IoUtils.safeClose((Closeable)inputStream);
        }
    }

    public static KeyStore keystoreFromDERCertificate(File file, File file2, char[] cArray) throws Exception {
        PrivateKey privateKey;
        String string = "serverkey";
        KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
        keyStore.load(null, cArray);
        try {
            privateKey = SSLUtil.loadPKCS8PrivateKey(file2);
        }
        catch (Exception exception) {
            privateKey = SSLUtil.loadRSAPrivateKey(file2);
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        InputStream inputStream = SSLUtil.fullStream(file);
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
        Certificate[] certificateArray = new Certificate[collection.toArray().length];
        if (collection.size() == 1) {
            Certificate certificate;
            inputStream = SSLUtil.fullStream(file);
            log.debug("One certificate, no chain.");
            certificateArray[0] = certificate = certificateFactory.generateCertificate(inputStream);
        } else {
            log.debug("Certificate chain length: " + collection.size());
            certificateArray = (Certificate[])collection.toArray();
        }
        keyStore.setKeyEntry(string, privateKey, cArray, certificateArray);
        Arrays.fill(cArray, '*');
        return keyStore;
    }

    private static PrivateKey loadPKCS8PrivateKey(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        byte[] byArray = new byte[(int)file.length()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    private static PrivateKey loadRSAPrivateKey(File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Security.addProvider(new BouncyCastleProvider());
        PEMParser pEMParser = new PEMParser(bufferedReader);
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pEMParser.readObject();
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        pEMParser.close();
        return privateKey;
    }

    private static InputStream fullStream(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IoUtils.safeClose((Closeable)fileInputStream);
        IoUtils.safeClose((Closeable)dataInputStream);
        return byteArrayInputStream;
    }
}

