/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.util.Headers;
import io.undertow.util.MimeMappings;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import runwar.AgentInitialization;
import runwar.BrowserOpener;
import runwar.LaunchUtil;
import runwar.SSLUtil;
import runwar.Stop;
import runwar.logging.LogSubverter;
import runwar.logging.Logger;
import runwar.mariadb4j.MariaDB4jManager;
import runwar.options.CommandLineHandler;
import runwar.options.ServerOptions;
import runwar.undertow.MappedResourceManager;
import runwar.undertow.WebXMLParser;
import runwar.util.TeeOutputStream;

public class Server {
    private static Logger log = Logger.getLogger("RunwarLogger");
    private TeeOutputStream tee;
    private static ServerOptions serverOptions;
    private static MariaDB4jManager mariadb4jManager;
    static volatile boolean listening;
    int portNumber;
    int socketNumber;
    private DeploymentManager manager;
    private Undertow undertow;
    private String PID;
    private String serverState = "STOPPED";
    private static URLClassLoader _classLoader;
    private String serverName = "default";
    private File statusFile = null;
    public static final String bar = "******************************************************************************";

    public Server() {
    }

    public Server(int n) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new OpenBrowserTask(), n * 1000);
    }

    protected void initClassLoader(List<URL> list) {
        if (_classLoader == null) {
            log.debug("Loading classes from lib dir");
            if (list != null && list.size() > 0) {
                log.debugf("classpath: %s", list);
                _classLoader = new URLClassLoader(list.toArray(new URL[list.size()]));
            } else {
                _classLoader = new URLClassLoader(null);
            }
        }
    }

    protected void setClassLoader(URLClassLoader uRLClassLoader) {
        _classLoader = uRLClassLoader;
    }

    public static URLClassLoader getClassLoader() {
        return _classLoader;
    }

    public void startServer(String[] stringArray, URLClassLoader uRLClassLoader) throws Exception {
        this.setClassLoader(uRLClassLoader);
        this.startServer(stringArray);
    }

    public void ensureJavaVersion() {
        log.debug("Checking that we're running on > java7");
        try {
            Class<?> clazz = Server.class.getClassLoader().loadClass("java.nio.charset.StandardCharsets");
            clazz.getClass().getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Could not load NIO!  Are we running on Java 7 or greater?  Sorry, exiting...");
        }
    }

    public void startServer(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        String string;
        Object object9;
        Object object10;
        this.ensureJavaVersion();
        this.serverState = "STARTING";
        serverOptions = CommandLineHandler.parseArguments(stringArray);
        if (serverOptions.getAction().equals("stop")) {
            Stop.stopServer(stringArray, true);
        }
        this.serverName = serverOptions.getServerName();
        this.portNumber = serverOptions.getPortNumber();
        this.socketNumber = serverOptions.getSocketNumber();
        String string2 = serverOptions.getCFEngineName();
        String string3 = serverOptions.getProcessName();
        String string4 = serverOptions.getContextPath();
        String string5 = serverOptions.getHost();
        File file = serverOptions.getWarFile();
        if (serverOptions.getStatusFile() != null) {
            this.statusFile = serverOptions.getStatusFile();
        }
        String string6 = serverOptions.getWarPath();
        String string7 = serverOptions.getLoglevel();
        char[] cArray = serverOptions.getStopPassword();
        Long l = serverOptions.getTransferMinSize();
        if (serverOptions.isBackground()) {
            this.setServerState("STARTING_BACKGROUND");
            object10 = new ArrayList();
            object9 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string8 = object9[n2];
                if (!string8.contains("background") && !string8.startsWith("-b")) {
                    object10.add(string8);
                }
                ++n2;
            }
            object10.add("--background");
            object10.add("false");
            int n3 = serverOptions.getLaunchTimeout();
            LaunchUtil.relaunchAsBackgroundProcess(n3, object10.toArray(new String[object10.size()]), string3);
            this.setServerState("STARTED_BACKGROUND");
            Thread.sleep(200L);
            System.exit(0);
        }
        if (file.exists() && !file.isDirectory()) {
            object10 = file.toURI().toURL();
            String string9 = file.getName().toLowerCase().replace(".war", "");
            if (!(file = new File(file.getParentFile(), string9)).exists()) {
                file.mkdir();
                log.debug("Exploding compressed WAR to " + file.getAbsolutePath());
                LaunchUtil.unzipResource((URL)object10, file, false);
            } else {
                log.debug("Using already exploded WAR in " + file.getAbsolutePath());
            }
            string6 = file.getAbsolutePath();
            if (serverOptions.getWarFile().getAbsolutePath().equals(serverOptions.getCfmlDirs())) {
                serverOptions.setCfmlDirs(file.getAbsolutePath());
            }
        }
        this.tee = null;
        if (serverOptions.getLogDir() != null) {
            object10 = serverOptions.getLogDir();
            ((File)object10).mkdir();
            File file2 = new File((File)object10, "server.out.txt");
            if (((File)object10).exists()) {
                if (file2.exists() && Files.size(Paths.get(file2.getPath(), new String[0])) > 0xA00000L) {
                    log.info("Log is over 10MB, moving " + file2.getPath() + " to " + file2.getPath() + ".bak");
                    Files.move(Paths.get(file2.getPath(), new String[0]), Paths.get(String.valueOf(file2.getPath()) + ".bak", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                log.info("Logging to " + file2.getPath());
                this.tee = new TeeOutputStream(System.out, new FileOutputStream(file2.getPath(), file2.exists()));
                PrintStream printStream = new PrintStream(this.tee, true);
                System.setOut(printStream);
                System.setErr(printStream);
            } else {
                log.error("Could not create log: " + file2.getPath());
            }
        }
        new AgentInitialization().loadAgentFromLocalJarFile(new File(file, "/WEB-INF/lib/"));
        object10 = System.getProperties().getProperty("os.name");
        String string10 = System.getProperty("cfml.server.trayicon");
        if (string10 != null && string10.length() > 0) {
            serverOptions.setIconImage(string10);
        }
        if ((string = System.getProperty("cfml.server.dockicon")) == null || string.length() == 0) {
            string = serverOptions.getIconImage();
        }
        if (object10 != null && ((String)object10).startsWith("Mac OS X")) {
            Image image = LaunchUtil.getIconImage(string);
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string3);
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("-Xdock:name", string3);
            try {
                object9 = Class.forName("com.apple.eawt.Application");
                object8 = ((Class)object9).getMethod("getApplication", new Class[0]);
                object7 = ((Method)object8).invoke(null, new Object[0]);
                object6 = object7.getClass().getMethod("setDockIconImage", Image.class);
                ((Method)object6).invoke(object7, image);
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        }
        String string11 = "Starting - port:" + this.portNumber + " stop-port:" + this.socketNumber + " warpath:" + string6;
        string11 = String.valueOf(string11) + "\ncontext: " + string4 + "  -  version: " + Server.getVersion();
        object9 = serverOptions.getCfmlDirs();
        if (((String)object9).length() > 0) {
            string11 = String.valueOf(string11) + "\nweb-dirs: " + (String)object9;
        }
        string11 = String.valueOf(string11) + "\nLog Directory: " + serverOptions.getLogDir().getAbsolutePath();
        System.out.println(bar);
        System.out.println(string11);
        System.out.println(bar);
        this.addShutDownHook();
        this.portNumber = this.getPortOrErrorOut(this.portNumber, string5);
        this.socketNumber = this.getPortOrErrorOut(this.socketNumber, string5);
        object8 = serverOptions.getCFMLServletConfigWebDir();
        object7 = serverOptions.getCFMLServletConfigServerDir();
        object6 = serverOptions.getWebXmlFile();
        File file3 = new File(file, "WEB-INF");
        if (object6 != null && new File(((File)object6).getParentFile(), "lib").exists()) {
            file3 = ((File)object6).getParentFile();
        }
        String string12 = serverOptions.getLibDirs();
        URL uRL = serverOptions.getJarURL();
        if (file.isDirectory() && file3.exists()) {
            string12 = String.valueOf(file3.getAbsolutePath()) + "/lib";
            log.info("Using existing WEB-INF/lib of: " + string12);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string12 != null || uRL != null) {
            if (string12 != null) {
                arrayList.addAll(this.getJarList(string12));
            }
            if (uRL != null) {
                arrayList.add(uRL);
            }
        }
        if (serverOptions.getMariaDB4jImportSQLFile() != null) {
            System.out.println("ADDN" + serverOptions.getMariaDB4jImportSQLFile().toURI().toURL());
            arrayList.add(serverOptions.getMariaDB4jImportSQLFile().toURI().toURL());
        }
        arrayList.addAll(this.getClassesList(new File(file3, "/classes")));
        this.initClassLoader(arrayList);
        mariadb4jManager = new MariaDB4jManager(_classLoader);
        log.debug("Transfer Min Size: " + serverOptions.getTransferMinSize());
        DeploymentInfo deploymentInfo = Servlets.deployment().setContextPath(string4.equals("/") ? "" : string4).setTempDir(new File(System.getProperty("java.io.tmpdir"))).setDeploymentName(string6);
        if (!file.exists()) {
            throw new RuntimeException("war does not exist: " + file.getAbsolutePath());
        }
        if (System.getProperty("java.library.path") == null) {
            if (object6 != null) {
                System.setProperty("java.library.path", String.valueOf(Server.getThisJarLocation().getPath()) + ':' + new File(((File)object6).getParentFile(), "lib").getPath());
            } else {
                System.setProperty("java.library.path", String.valueOf(Server.getThisJarLocation().getPath()) + ':' + new File(file, "/WEB-INF/lib/").getPath());
            }
        } else {
            System.setProperty("java.library.path", String.valueOf(Server.getThisJarLocation().getPath()) + ":" + System.getProperty("java.library.path"));
        }
        log.debug("java.library.path:" + System.getProperty("java.library.path"));
        if (System.getProperty("coldfusion.home") == null) {
            object5 = new File(file3, "cfusion").getAbsolutePath();
            if (object6 != null) {
                object5 = new File(((File)object6).getParentFile(), "cfusion").getAbsolutePath();
            }
            log.debug("Setting coldfusion home:" + (String)object5);
            System.setProperty("coldfusion.home", (String)object5);
            System.setProperty("coldfusion.rootDir", (String)object5);
            System.setProperty("coldfusion.libPath", String.valueOf(object5) + "/lib");
            System.setProperty("flex.dir", new File(file3, "cfform").getAbsolutePath());
            System.setProperty("coldfusion.jsafe.defaultalgo", "FIPS186Random");
            System.setProperty("coldfusion.classPath", String.valueOf(object5) + "/lib/updates/," + (String)object5 + "/lib/," + (String)object5 + "/lib/axis2," + (String)object5 + "/gateway/lib/," + (String)object5 + "/../cfform/jars," + (String)object5 + "/../flex/jars," + (String)object5 + "/lib/oosdk/lib," + (String)object5 + "/lib/oosdk/classes");
            System.setProperty("java.security.policy", String.valueOf(object5) + "/lib/coldfusion.policy");
            System.setProperty("java.security.auth.policy", String.valueOf(object5) + "/lib/neo_jaas.policy");
            System.setProperty("java.nixlibrary.path", String.valueOf(object5) + "/lib");
            System.setProperty("java.library.path", String.valueOf(object5) + "/lib");
        }
        if (file.isDirectory() && !file3.exists()) {
            if (object8 == null) {
                object5 = new File(Server.getThisJarLocation().getParentFile(), "engine/cfml/server/cfml-web/");
                object8 = String.valueOf(((File)object5).getPath()) + "/" + this.serverName;
            }
            log.debug("cfml.web.config.dir: " + (String)object8);
            if (object7 == null || ((String)object7).length() == 0) {
                object5 = new File(Server.getThisJarLocation().getParentFile(), "engine/cfml/server/");
                object7 = ((File)object5).getAbsolutePath();
            }
            log.debug("cfml.server.config.dir: " + (String)object7);
            object5 = System.getProperty("cfml.webinf");
            file3 = object5 == null ? new File((String)object8, "WEB-INF/") : new File((String)object5);
            log.debug("cfml.webinf: " + file3.getPath());
            object4 = file3;
            ((File)object4).mkdirs();
            deploymentInfo.setResourceManager(new MappedResourceManager(file, (long)l, (String)object9, (File)object4));
            if (object6 != null) {
                log.debug("using specified web.xml : " + ((File)object6).getAbsolutePath());
                deploymentInfo.setClassLoader(_classLoader);
                WebXMLParser.parseWebXml((File)object6, deploymentInfo);
            } else {
                Class<?> clazz;
                if (_classLoader == null) {
                    throw new RuntimeException("FATAL: Could not load any libs for war: " + file.getAbsolutePath());
                }
                deploymentInfo.setClassLoader(_classLoader);
                try {
                    clazz = _classLoader.loadClass(String.valueOf(string2) + ".loader.servlet.CFMLServlet");
                    log.debug("dynamically loaded CFML servlet from runwar child classloader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Server.class.getClassLoader().loadClass(String.valueOf(string2) + ".loader.servlet.CFMLServlet");
                    log.debug("dynamically loaded CFML servlet from runwar classloader");
                }
                try {
                    object3 = _classLoader.loadClass(String.valueOf(string2) + ".loader.servlet.RestServlet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object3 = Server.class.getClassLoader().loadClass(String.valueOf(string2) + ".loader.servlet.RestServlet");
                }
                log.debug("loaded servlet classes");
                deploymentInfo.addWelcomePages(serverOptions.getWelcomeFiles()).addServlets(Servlets.servlet("CFMLServlet", clazz).setRequireWelcomeFileMapping(true).addInitParam("configuration", (String)object8).addInitParam(String.valueOf(string2) + "-server-root", (String)object7).addMapping("*.cfm").addMapping("*.cfc").addMapping("/index.cfc/*").addMapping("/index.cfm/*").addMapping("/index.cfml/*").setLoadOnStartup(1), Servlets.servlet("RESTServlet", (Class<? extends Servlet>)object3).setRequireWelcomeFileMapping(true).addInitParam(String.valueOf(string2) + "-web-directory", (String)object8).addMapping("/rest/*").setLoadOnStartup(2));
            }
        } else if (file3.exists()) {
            log.debug("found WEB-INF: " + file3.getAbsolutePath());
            if (_classLoader == null) {
                throw new RuntimeException("FATAL: Could not load any libs for war: " + file.getAbsolutePath());
            }
            deploymentInfo.setClassLoader(_classLoader);
            deploymentInfo.setResourceManager(new MappedResourceManager(file, (long)l, (String)object9, file3));
            LogSubverter.subvertJDKLoggers(string7);
            WebXMLParser.parseWebXml(new File(file3, "/web.xml"), deploymentInfo);
        } else {
            throw new RuntimeException("Didn't know how to handle war:" + file.getAbsolutePath());
        }
        this.configureURLRewrite(deploymentInfo, file3);
        if (serverOptions.isCacheEnabled()) {
            this.addCacheHandler(deploymentInfo);
        }
        if (serverOptions.isCustomHTTPStatusEnabled()) {
            deploymentInfo.setSendCustomReasonPhraseOnError(true);
        }
        deploymentInfo.addServlet(new ServletInfo("default", DefaultServlet.class).addInitParam("directory-listing", Boolean.toString(serverOptions.isDirectoryListingEnabled())));
        this.manager = Servlets.defaultContainer().addDeployment(deploymentInfo);
        this.manager.deploy();
        object5 = this.manager.start();
        log.debug("started servlet deployment manager");
        object4 = Undertow.builder();
        if (serverOptions.isEnableHTTP()) {
            ((Undertow.Builder)object4).addHttpListener(this.portNumber, string5);
        }
        if (serverOptions.isEnableSSL()) {
            int n = serverOptions.getSSLPort();
            ((Undertow.Builder)object4).setDirectBuffers(true);
            log.info("Enabling SSL protocol on port " + n);
            if (serverOptions.getSSLCertificate() != null) {
                object3 = serverOptions.getSSLCertificate();
                object2 = serverOptions.getSSLKey();
                object = serverOptions.getSSLKeyPass();
                ((Undertow.Builder)object4).addHttpsListener(n, string5, SSLUtil.createSSLContext(object3, (File)object2, (char[])object));
                Arrays.fill((char[])object, '*');
            } else {
                ((Undertow.Builder)object4).addHttpsListener(n, string5, SSLUtil.createSSLContext());
            }
        }
        if (serverOptions.isEnableAJP()) {
            log.info("Enabling AJP protocol on port " + serverOptions.getAJPPort());
            ((Undertow.Builder)object4).addAjpListener(serverOptions.getAJPPort(), string5);
        }
        PathHandler pathHandler = new PathHandler(Handlers.redirect(string4)){

            @Override
            public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
                if (httpServerExchange.getRequestPath().endsWith(".svgz")) {
                    httpServerExchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "gzip");
                }
                super.handleRequest(httpServerExchange);
            }
        };
        pathHandler.addPrefixPath(string4, (HttpHandler)object5);
        if (serverOptions.isGzipEnabled()) {
            object3 = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", new GzipEncodingProvider(), 50, Predicates.parse("max-content-size[5]"))).setNext(pathHandler);
            ((Undertow.Builder)object4).setHandler((HttpHandler)object3);
        } else {
            ((Undertow.Builder)object4).setHandler(pathHandler);
        }
        try {
            this.PID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            object3 = serverOptions.getPidFile();
            if (object3 != null && ((String)object3).length() > 0) {
                object2 = new File((String)object3);
                ((File)object2).deleteOnExit();
                object = new PrintWriter((File)object2);
                ((PrintWriter)object).print(this.PID);
                ((PrintWriter)object).close();
            }
        }
        catch (Exception exception) {
            log.error("Unable to get PID:" + exception.getMessage());
        }
        if (serverOptions.isKeepRequestLog()) {
            log.error("request log currently unsupported");
        }
        this.undertow = ((Undertow.Builder)object4).build();
        object3 = new MonitorThread(cArray);
        ((Thread)object3).start();
        log.debug("started stop monitor");
        LaunchUtil.hookTray(this);
        log.debug("hooked system tray");
        if (serverOptions.isOpenbrowser()) {
            new Server(3);
        }
        object2 = "Server is up - http-port:" + this.portNumber + " stop-port:" + this.socketNumber + " PID:" + this.PID + " version " + Server.getVersion();
        log.debug(object2);
        System.out.println((String)object2);
        this.setServerState("STARTED");
        if (serverOptions.isMariaDB4jEnabled()) {
            try {
                mariadb4jManager.start(serverOptions.getMariaDB4jPort(), serverOptions.getMariaDB4jBaseDir(), serverOptions.getMariaDB4jDataDir(), serverOptions.getMariaDB4jImportSQLFile());
            }
            catch (Exception exception) {
                log.error("Could not start MariaDB4j");
                log.error(exception);
                System.out.println("Error starting MariaDB4j: " + exception.getMessage());
            }
        }
        this.undertow.start();
    }

    private void addShutDownHook() {
        final Thread thread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Server.this.stopServer();
                    thread.join();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        log.debug("Added shutdown hook");
    }

    public void stopServer() {
        int n = 0;
        try {
            System.out.println();
            System.out.println(bar);
            System.out.println("*** stopping server");
            if (serverOptions.isMariaDB4jEnabled()) {
                mariadb4jManager.stop();
            }
            try {
                this.manager.undeploy();
                this.undertow.stop();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                System.out.println("*** server did not appear to be running");
            }
            System.out.println(bar);
            this.setServerState("STOPPED");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setServerState("UNKNOWN");
            log.error(exception);
            n = 1;
        }
        try {
            if (this.tee != null) {
                this.tee.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Redirect:  Unable to close this log file!");
        }
        if (n != 0) {
            System.exit(n);
        }
    }

    private void configureURLRewrite(DeploymentInfo deploymentInfo, File file) throws ClassNotFoundException, IOException {
        if (serverOptions.isEnableURLRewrite()) {
            Class<?> clazz;
            log.debug("enabling URL rewriting");
            String string = "runwar/urlrewrite.xml";
            try {
                clazz = _classLoader.loadClass("org.tuckey.web.filters.urlrewrite.UrlRewriteFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Server.class.getClassLoader().loadClass("org.tuckey.web.filters.urlrewrite.UrlRewriteFilter");
            }
            if (serverOptions.getURLRewriteFile() != null) {
                if (!serverOptions.getURLRewriteFile().isFile()) {
                    log.error("The URL rewrite file " + string + " does not exist!");
                } else {
                    String string2 = "urlrewrite.xml";
                    LaunchUtil.copyFile(serverOptions.getURLRewriteFile(), new File(file, string2));
                    log.debug("Copying URL rewrite file " + serverOptions.getURLRewriteFile().getPath() + " to WEB-INF: " + file.getPath() + "/" + string2);
                    string = "/WEB-INF/" + string2;
                }
            }
            log.debug("URL rewriting config file: " + string);
            deploymentInfo.addFilter(new FilterInfo("UrlRewriteFilter", clazz).addInitParam("confPath", string).addInitParam("statusEnabled", Boolean.toString(serverOptions.isDebug())).addInitParam("modRewriteConf", "false"));
            deploymentInfo.addFilterUrlMapping("UrlRewriteFilter", "/*", DispatcherType.REQUEST);
        } else {
            log.debug("URL rewriting is disabled");
        }
    }

    private void addCacheHandler(final DeploymentInfo deploymentInfo) {
        deploymentInfo.addInitialHandlerChainWrapper(new HandlerWrapper(){

            @Override
            public HttpHandler wrap(HttpHandler httpHandler) {
                ResourceHandler resourceHandler = new ResourceHandler(deploymentInfo.getResourceManager());
                MimeMappings.Builder builder = MimeMappings.builder();
                ArrayList<String> arrayList = new ArrayList<String>();
                builder.addMapping("eot", "application/vnd.ms-fontobject");
                builder.addMapping("otf", "font/opentype");
                builder.addMapping("ttf", "application/x-font-ttf");
                builder.addMapping("woff", "application/x-font-woff");
                arrayList.addAll(Arrays.asList(".eot", ".otf", ".ttf", ".woff"));
                for (MimeMapping stringArray2 : deploymentInfo.getMimeMappings()) {
                    log.debug("Adding mime-type: " + stringArray2.getExtension() + " - " + stringArray2.getMimeType());
                    builder.addMapping(stringArray2.getExtension(), stringArray2.getMimeType());
                    arrayList.add("." + stringArray2.getExtension());
                }
                resourceHandler.setMimeMappings(builder.build());
                String[] stringArray2 = new String[arrayList.size()];
                stringArray2 = arrayList.toArray(stringArray2);
                CacheHandler cacheHandler = new CacheHandler(new DirectBufferCache(1024, 10, 10480), resourceHandler);
                PredicateHandler predicateHandler = new PredicateHandler(Predicates.suffixes(stringArray2), cacheHandler, httpHandler);
                return predicateHandler;
            }
        });
    }

    public static File getThisJarLocation() {
        return LaunchUtil.getJarDir(Server.class);
    }

    public String getPID() {
        return this.PID;
    }

    private int getPortOrErrorOut(int n, String string) {
        try {
            ServerSocket serverSocket = new ServerSocket(n, 1, InetAddress.getByName(string));
            n = serverSocket.getLocalPort();
            serverSocket.close();
            return n;
        }
        catch (BindException bindException) {
            throw new RuntimeException("Error getting port " + n + "!  Cannot start.  " + bindException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Unknown host (" + string + ")");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private List<URL> getJarList(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String[] stringArray = string.split(",");
        if (stringArray == null) {
            return arrayList;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (!".".equals(string2) && !"..".equals(string2)) {
                File file = new File(string2);
                File[] fileArray = file.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file2 = fileArray[n4];
                    String string3 = file2.getAbsolutePath();
                    if (!file2.isDirectory() && (string3.toLowerCase().endsWith(".jar") || string3.toLowerCase().endsWith(".zip"))) {
                        URL uRL = file2.toURI().toURL();
                        arrayList.add(uRL);
                        log.debug("lib: added to classpath: " + string3);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private List<URL> getClassesList(File file) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (file == null) {
            return arrayList;
        }
        if (file.exists() && file.isDirectory()) {
            URL uRL = file.toURI().toURL();
            arrayList.add(uRL);
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isDirectory()) {
                    arrayList.addAll(this.getClassesList(file2));
                }
                ++n2;
            }
        } else {
            log.debug("WEB-INF classes directory (" + file.getAbsolutePath() + ") does not exist");
        }
        return arrayList;
    }

    public static void printVersion() {
        System.out.println(LaunchUtil.getResourceAsString("runwar/version.properties"));
        System.out.println(LaunchUtil.getResourceAsString("io/undertow/version.properties"));
    }

    private static String getVersion() {
        String[] stringArray = LaunchUtil.getResourceAsString("runwar/version.properties").split("=");
        return stringArray[stringArray.length - 1].trim();
    }

    public static boolean serverWentDown(int n, long l, InetAddress inetAddress, int n2) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < (long)n) {
            if (Server.checkServerIsUp(inetAddress, n2)) {
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean serverCameUp(int n, long l, InetAddress inetAddress, int n2) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < (long)n) {
            if (!Server.checkServerIsUp(inetAddress, n2)) {
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static boolean checkServerIsUp(InetAddress inetAddress, int n) {
        Socket socket;
        block11: {
            socket = null;
            socket = SocketFactory.getDefault().createSocket(inetAddress, n);
            socket.setSoLinger(true, 0);
            if (socket == null) break block11;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return true;
        catch (IOException iOException) {
            block12: {
                try {
                    if (socket == null) break block12;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException iOException3) {}
            }
            return false;
        }
    }

    public static ServerOptions getServerOptions() {
        return serverOptions;
    }

    private void setServerState(String string) {
        this.serverState = string;
        if (this.statusFile != null) {
            try {
                PrintWriter printWriter = new PrintWriter(this.statusFile);
                printWriter.print(string);
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error(fileNotFoundException.getMessage());
            }
        }
    }

    public String getServerState() {
        return this.serverState;
    }

    private class MonitorThread
    extends Thread {
        private char[] stoppassword;

        public MonitorThread(char[] cArray) {
            this.stoppassword = cArray;
            this.setDaemon(true);
            this.setName("StopMonitor");
        }

        @Override
        public void run() {
            ServerSocket serverSocket = null;
            int n = 0;
            listening = true;
            try {
                serverSocket = new ServerSocket(Server.this.socketNumber, 1, InetAddress.getByName(serverOptions.getHost()));
                System.out.println(Server.bar);
                System.out.println("*** starting 'stop' listener thread - Host: " + serverOptions.getHost() + " - Socket: " + Server.this.socketNumber);
                System.out.println(Server.bar);
                while (listening) {
                    Socket socket = serverSocket.accept();
                    int n2 = 0;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    try {
                        int n3;
                        while ((n3 = bufferedReader.read()) != -1) {
                            char c = (char)n3;
                            if (this.stoppassword.length > n2 && c == this.stoppassword[n2]) {
                                ++n2;
                                continue;
                            }
                            n2 = 0;
                        }
                        if (n2 == this.stoppassword.length) {
                            listening = false;
                        } else {
                            log.warn("Incorrect password used when trying to stop server.");
                        }
                    }
                    catch (SocketException socketException) {}
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                serverSocket.close();
            }
            catch (Exception exception) {
                n = 1;
                exception.printStackTrace();
            }
            System.exit(n);
        }
    }

    class OpenBrowserTask
    extends TimerTask {
        OpenBrowserTask() {
        }

        @Override
        public void run() {
            int n = serverOptions.getPortNumber();
            String string = "http";
            String string2 = serverOptions.getHost();
            String string3 = serverOptions.getOpenbrowserURL();
            int n2 = serverOptions.getLaunchTimeout();
            if (string3 == null || string3.length() == 0) {
                string3 = "http://" + string2 + ":" + n;
            }
            if (serverOptions.isEnableSSL()) {
                n = serverOptions.getSSLPort();
                string = "https";
                string3 = string3.replace("http:", "https:");
            }
            if (!string3.startsWith("http")) {
                string3 = !string3.startsWith("/") ? "/" + string3 : string3;
                string3 = String.valueOf(string) + "://" + string2 + ":" + n + string3;
            }
            System.out.println("Waiting up to " + n2 / 1000 + " seconds for " + string2 + ":" + n + "...");
            try {
                if (Server.serverCameUp(n2, 3000L, InetAddress.getByName(string2), n)) {
                    System.out.println("Opening browser to..." + string3);
                    BrowserOpener.openURL(string3.trim());
                } else {
                    System.out.println("could not open browser to..." + string3 + "... timeout...");
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
            }
        }
    }

    public static class ServerState {
        public static final String STARTING = "STARTING";
        public static final String STARTED = "STARTED";
        public static final String STARTING_BACKGROUND = "STARTING_BACKGROUND";
        public static final String STARTED_BACKGROUND = "STARTED_BACKGROUND";
        public static final String STOPPING = "STOPPING";
        public static final String STOPPED = "STOPPED";
        public static final String UNKNOWN = "UNKNOWN";
    }
}

