/*
 * Decompiled with CFR 0.152.
 */
package runwar;

import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import runwar.Server;
import runwar.options.CommandLineHandler;
import runwar.options.ServerOptions;

public class Stop {
    public static void main(String[] stringArray) throws Exception {
        Stop.stopServer(stringArray, true);
    }

    public static void stopServer(String[] stringArray, boolean bl) throws Exception {
        ServerOptions serverOptions = CommandLineHandler.parseArguments(stringArray);
        int n = serverOptions.getSocketNumber();
        String string = serverOptions.getHost();
        char[] cArray = serverOptions.getStopPassword();
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            Socket socket = new Socket(inetAddress, n);
            OutputStream outputStream = socket.getOutputStream();
            System.out.println("*** sending stop request to socket : " + n);
            int n2 = 0;
            while (n2 < cArray.length) {
                outputStream.write(cArray[n2]);
                ++n2;
            }
            outputStream.flush();
            outputStream.close();
            socket.close();
            if (!Server.serverWentDown(10000, 500L, inetAddress, n)) {
                System.err.println("Timeout stopping server.  Did you set a stop-password, and are you passing it?  Check the log for more information.");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not stop server.  Are you sure it is running, and listing for stop requests on port " + n + "?");
            System.exit(1);
        }
        System.out.println("*** stopped.");
        System.out.println("******************************************************************************");
        if (bl) {
            System.exit(0);
        }
        Thread.currentThread().interrupt();
    }
}

