/*
 * Decompiled with CFR 0.152.
 */
package runwar.logging;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.jboss.logging.Logger;
import runwar.Server;
import runwar.logging.JDKLevel;
import runwar.logging.Logger;

public class LogSubverter {
    public static final Set<String> loggers = new HashSet<String>(Arrays.asList("RunwarLogger", "runwar.Start", "org.jboss.logging", "org.xnio.Xnio", "org.xnio.nio.NioXnio", "io.undertow.UndertowLogger"));
    private static Logger log = Logger.getLogger("RunwarLogger");

    public static void subvertLoggers(String string) {
        LogSubverter.subvertJDKLoggers(string);
        LogSubverter.subvertLog4jLoggers(string);
    }

    public static void subvertJDKLoggers(String string) {
        System.setProperty("java.util.logging.ConsoleHandler.formatter", "java.util.logging.SimpleFormatter");
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$s %3$s %5$s%6$s%n");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        JDKLevel jDKLevel = JDKLevel.WARN;
        if (string.trim().toUpperCase().equals("TRACE")) {
            jDKLevel = JDKLevel.TRACE;
        }
        if (string.trim().toUpperCase().equals("WARN")) {
            jDKLevel = JDKLevel.WARN;
        }
        if (string.trim().toUpperCase().equals("INFO")) {
            jDKLevel = JDKLevel.INFO;
        }
        if (string.trim().toUpperCase().equals("DEBUG")) {
            jDKLevel = JDKLevel.DEBUG;
        }
        if (string.trim().toUpperCase().equals("ERROR")) {
            jDKLevel = JDKLevel.ERROR;
        }
        if (string.trim().toUpperCase().equals("FATAL")) {
            jDKLevel = JDKLevel.FATAL;
        }
        consoleHandler.setLevel(jDKLevel);
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> enumeration = logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            java.util.logging.Logger logger2 = logManager.getLogger(string2);
            if (!loggers.contains(string2) || logger2 == null) continue;
            log.debugLazy("JDK loggers detected, level to " + string);
            logger2.setUseParentHandlers(false);
            logger2.setLevel(jDKLevel);
            if (logger2.getHandlers() == null) continue;
            Handler[] handlerArray = logger2.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                logger2.removeHandler(handler);
                ++n2;
            }
            logger2.addHandler(consoleHandler);
        }
    }

    public static void subvertLog4jLoggers(String string) {
        Method method;
        Class<?> clazz;
        Properties properties = new Properties();
        properties.put("log4j.rootLogger", String.valueOf(string.toUpperCase()) + ", stdout");
        properties.put("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        properties.put("log4j.appender.stdout.Target", "System.out");
        properties.put("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        properties.put("log4j.appender.stdout.layout.ConversionPattern", "%d{yy/MM/dd HH:mm:ss} %p %c{2}: %m%n");
        properties.put("RunwarLogger", String.valueOf(string.toUpperCase()) + ", stdout");
        properties.put("org.jboss.logging", String.valueOf(string.toUpperCase()) + ", stdout");
        ClassLoader classLoader = Server.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            clazz = classLoader.loadClass("org.apache.log4j.LogManager");
            method = clazz.getMethod("resetConfiguration", new Class[0]);
            method.invoke(null, new Object[0]);
            log.debugLazy("log4j loggers detected, configuration reset to " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debugLazy("No log4j loggers detected");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            clazz = classLoader.loadClass("org.apache.log4j.PropertyConfigurator");
            method = clazz.getMethod("configure", Properties.class);
            method.invoke(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Level translate(Logger.Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: {
                    return JDKLevel.FATAL;
                }
                case ERROR: {
                    return JDKLevel.ERROR;
                }
                case WARN: {
                    return JDKLevel.WARN;
                }
                case INFO: {
                    return JDKLevel.INFO;
                }
                case DEBUG: {
                    return JDKLevel.DEBUG;
                }
                case TRACE: {
                    return JDKLevel.TRACE;
                }
            }
        }
        return JDKLevel.ALL;
    }
}

