/*
 * Decompiled with CFR 0.152.
 */
package runwar.logging;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.logging.Logger;
import runwar.Server;
import runwar.logging.LogSubverter;

public class Logger {
    private static boolean loggingIsInitialized = false;
    private static org.jboss.logging.Logger logger;
    private static String loggerName;
    private static ArrayList<HashMap<String, Object>> lazyMessages;
    private static Logger.Level logLevel;

    static {
        logLevel = Logger.Level.WARN;
    }

    public Logger(String string) {
        loggerName = string;
        lazyMessages = new ArrayList();
    }

    public void debug(Object object) {
        Logger.log(Logger.Level.DEBUG, object);
    }

    public void debug(String string, Exception exception) {
        Logger.log(Logger.Level.DEBUG, string, exception);
    }

    public void debugf(String string, Object ... objectArray) {
        Logger.logf(Logger.Level.DEBUG, string, objectArray);
    }

    public void debugLazy(Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("level", (Object)Logger.Level.DEBUG);
        hashMap.put("message", object);
        lazyMessages.add(hashMap);
    }

    public void trace(Object object) {
        Logger.log(Logger.Level.TRACE, object);
    }

    public void trace(String string, Exception exception) {
        Logger.log(Logger.Level.TRACE, string, exception);
    }

    public void tracef(String string, Object object) {
        Logger.logf(Logger.Level.TRACE, string, object);
    }

    public void error(Object object) {
        Logger.log(Logger.Level.ERROR, object);
    }

    public void error(String string, Exception exception) {
        Logger.log(Logger.Level.ERROR, string, exception);
    }

    public void errorf(String string, Object object) {
        Logger.logf(Logger.Level.ERROR, string, object);
    }

    public void warn(Object object) {
        Logger.log(Logger.Level.WARN, object);
    }

    public void warn(String string, Exception exception) {
        Logger.log(Logger.Level.WARN, string, exception);
    }

    public void warnf(String string, Object object) {
        Logger.logf(Logger.Level.WARN, string, object);
    }

    public void info(Object object) {
        Logger.log(Logger.Level.INFO, object);
    }

    public void info(String string, Exception exception) {
        Logger.log(Logger.Level.INFO, string, exception);
    }

    public void info(String string, Object object) {
        Logger.logf(Logger.Level.INFO, string, object);
    }

    public void fatal(Object object) {
        Logger.log(Logger.Level.FATAL, object);
    }

    public void fatal(String string, Exception exception) {
        Logger.log(Logger.Level.FATAL, string, exception);
    }

    public void fatal(String string, Object object) {
        Logger.logf(Logger.Level.FATAL, string, object);
    }

    private static void log(Logger.Level level, Object object) {
        if (!loggingIsInitialized) {
            Logger.initLogging();
        }
        switch (level) {
            case DEBUG: {
                logger.debug(object);
                break;
            }
            case WARN: {
                logger.warn(object);
                break;
            }
            case INFO: {
                logger.info(object);
                break;
            }
            case TRACE: {
                logger.trace(object);
                break;
            }
            case FATAL: {
                logger.fatal(object);
                break;
            }
            default: {
                logger.debug(object);
            }
        }
    }

    private static void logf(Logger.Level level, String string, Object ... objectArray) {
        if (!loggingIsInitialized) {
            Logger.initLogging();
        }
        switch (level) {
            case DEBUG: {
                logger.debugf(string, objectArray);
                break;
            }
            case WARN: {
                logger.warnf(string, objectArray);
                break;
            }
            case INFO: {
                logger.infof(string, objectArray);
                break;
            }
            case TRACE: {
                logger.tracef(string, objectArray);
                break;
            }
            case FATAL: {
                logger.fatalf(string, objectArray);
                break;
            }
            default: {
                logger.debugf(string, objectArray);
            }
        }
    }

    private static void log(Logger.Level level, String string, Exception exception) {
        if (!loggingIsInitialized) {
            Logger.initLogging();
        }
        switch (level) {
            case DEBUG: {
                logger.debug((Object)string, exception);
                break;
            }
            case WARN: {
                logger.warn((Object)string, exception);
                break;
            }
            case INFO: {
                logger.info((Object)string, exception);
                break;
            }
            case TRACE: {
                logger.trace((Object)string, exception);
                break;
            }
            case FATAL: {
                logger.fatal((Object)string, exception);
                break;
            }
            default: {
                logger.debug((Object)string, exception);
            }
        }
    }

    private static void initLogging() {
        logger = org.jboss.logging.Logger.getLogger("RunwarLogger");
        if (Server.getServerOptions() != null) {
            logLevel = Logger.Level.valueOf(Server.getServerOptions().getLoglevel());
            loggingIsInitialized = true;
            if (logLevel == null) {
                logLevel = Logger.Level.valueOf("WARN");
            }
            LogSubverter.subvertLoggers(logLevel.toString());
            for (HashMap<String, Object> hashMap : lazyMessages) {
                Logger.Level level = (Logger.Level)((Object)hashMap.get("level"));
                Logger.log(level, String.valueOf(loggerName) + hashMap.get("message"));
            }
        }
    }

    public static Logger getLogger(String string) {
        return new Logger(string);
    }
}

