/*
 * Decompiled with CFR 0.152.
 */
package runwar.mariadb4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import runwar.logging.Logger;
import runwar.util.Reflection;

public class MariaDB4jManager {
    private File baseDir;
    private File dataDir;
    private Object server;
    private String username;
    private String password;
    private String dbName = null;
    private int port;
    private URLClassLoader classLoader;
    private static Logger log = Logger.getLogger("RunwarLogger");
    volatile boolean isShuttingDown;

    public MariaDB4jManager(URLClassLoader uRLClassLoader) {
        this.classLoader = uRLClassLoader;
    }

    public boolean canLoad() {
        try {
            log.debug("Checking for MariaDB4j class avaiability");
            Reflection.load(this.classLoader, "ch.vorburger.mariadb4j.DBConfigurationBuilder");
            return true;
        }
        catch (Exception exception) {
            log.debug("MariaDB4j classes are not available");
            return false;
        }
    }

    public void start(int n, File file, File file2, File file3) throws IOException {
        block9: {
            this.port = n;
            System.out.println("Starting MariaDB server on port " + n);
            this.baseDir = file == null ? Files.createTempDirectory("mariadb4j", new FileAttribute[0]).toFile() : file;
            System.out.println("MariaDB4j base directory " + this.baseDir.getAbsolutePath());
            this.dataDir = file2 == null ? new File(this.baseDir.getAbsolutePath(), "data-dir") : file2;
            System.out.println("MariaDB4j datadirectory " + this.dataDir.getAbsolutePath());
            Class<?> clazz = Reflection.load(this.classLoader, "ch.vorburger.mariadb4j.DBConfigurationBuilder");
            if (clazz == null) {
                throw new RuntimeException("COULD NOT LOAD DB CLASS");
            }
            Object object = Reflection.invoke(Reflection.method(clazz, "newBuilder"), null, new Object[0]);
            Reflection.invoke(Reflection.method(clazz, "setPort", Integer.TYPE), object, n);
            Reflection.invoke(Reflection.method(clazz, "setBaseDir", String.class), object, this.baseDir.getAbsolutePath());
            Reflection.invoke(Reflection.method(clazz, "setDataDir", String.class), object, this.dataDir.getAbsolutePath());
            Class<?> clazz2 = Reflection.load(this.classLoader, "ch.vorburger.mariadb4j.DB");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    this.server = Reflection.invoke(Reflection.method(clazz2, "newEmbeddedDB", Reflection.load(this.classLoader, "ch.vorburger.mariadb4j.DBConfiguration")), clazz2, Reflection.method(clazz, "build").invoke(object, new Object[0]));
                    Reflection.invoke(Reflection.method(this.server.getClass(), "start"), this.server, new Object[0]);
                    System.out.println("Started MariaDB4j server");
                    if (file3 != null) {
                        if (file3.exists()) {
                            System.out.println("importing SQL file: " + file3.getAbsolutePath());
                            this.run(file3, this.username, this.password, this.dbName);
                        } else {
                            log.error("Could not load MariaDB4j SQL file, file does not exist: " + file3.getAbsolutePath());
                            System.out.println("Could not load MariaDB4j SQL file, file does not exist: : " + file3.getAbsolutePath());
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.isShuttingDown = false;
    }

    public void run(File file, String string, String string2, String string3) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.run("[MariaDB4j] importing " + file.getAbsolutePath(), fileInputStream, string, string2, string3);
    }

    public void createDB(String string) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Reflection.invoke(Reflection.method(this.server.getClass(), "createDB", String.class), this.server, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void run(String string, InputStream inputStream, String string2, String string3, String string4) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Method method = Reflection.method(this.server.getClass(), "run", String.class, InputStream.class, String.class, String.class, String.class);
                method.setAccessible(true);
                Reflection.invoke(method, this.server, string, inputStream, string2, string3, string4);
            }
            catch (Exception exception) {
                try {
                    System.out.println("[MariaDB4j] Error running SQL: ");
                    System.out.print("    ");
                    System.out.println(exception.getCause().getCause().getMessage());
                }
                catch (Exception exception2) {
                    exception.printStackTrace();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void run(String string, String string2, String string3, String string4) {
        System.out.println("[MariaDB4j] Running SQL command: " + string);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Reflection.invoke(Reflection.method(this.server.getClass(), "run", String.class, String.class, String.class, String.class), this.server, string, string2, string3, string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void stop() throws InterruptedException {
        this.isShuttingDown = true;
        System.out.println("*** Stopping MariaDB server on port " + this.port + " ...");
        try {
            Reflection.invoke(Reflection.method(this.server.getClass(), "stop"), this.server, new Object[0]);
            System.out.println("*** Stopped MariaDB server on port " + this.port);
        }
        catch (Exception exception) {
            System.out.println("*** Error stopping MariaDB server on port " + this.port);
            exception.printStackTrace();
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String string) {
        this.dbName = string;
    }
}

