/*
 * Decompiled with CFR 0.152.
 */
package runwar.options;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import runwar.Server;
import runwar.logging.Logger;
import runwar.options.ConfigParser;
import runwar.options.ServerOptions;

public class CommandLineHandler {
    private static final Options options = new Options();
    private static PosixParser parser;
    private static final String SYNTAX = " java -jar runwar.jar [-war] path/to/war [options]";
    private static final String HEADER = " The runwar lib wraps undertow with more awwsome. Defaults (parenthetical)";
    private static final String FOOTER = " source: https://github.com/cfmlprojects/runwar.git";
    private static Logger log;

    static {
        log = Logger.getLogger("CommandLineHandler");
    }

    public static ServerOptions parseArguments(String[] stringArray) {
        ServerOptions serverOptions = new ServerOptions();
        serverOptions = CommandLineHandler.parseArguments(stringArray, serverOptions);
        return serverOptions;
    }

    public static ServerOptions parseArguments(String[] stringArray, ServerOptions serverOptions) {
        parser = new PosixParser();
        OptionBuilder.withLongOpt("config");
        OptionBuilder.withDescription("config file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        options.addOption(OptionBuilder.create("c"));
        OptionBuilder.withDescription("path to war");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("war"));
        OptionBuilder.withLongOpt("server-name");
        OptionBuilder.withDescription("server name (default)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("name");
        options.addOption(OptionBuilder.create("name"));
        OptionBuilder.withLongOpt("context-path");
        OptionBuilder.withDescription("context path.  (/)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("context");
        options.addOption(OptionBuilder.create("context"));
        OptionBuilder.withDescription("host.  (127.0.0.1)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("host");
        options.addOption(OptionBuilder.create("host"));
        OptionBuilder.withLongOpt("port");
        OptionBuilder.withDescription("port number.  (8088)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("http port");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create('p'));
        OptionBuilder.withLongOpt("stop-port");
        OptionBuilder.withDescription("stop listener port number. (8779)\n");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("port");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create("stopsocket"));
        OptionBuilder.withLongOpt("stop-password");
        OptionBuilder.withDescription("Pasword checked when stopping server\n");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        options.addOption(OptionBuilder.create("password"));
        OptionBuilder.withDescription("stop backgrounded.  Optional stop-port");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("port");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("password");
        OptionBuilder.withValueSeparator(' ');
        options.addOption(OptionBuilder.create("stop"));
        OptionBuilder.withLongOpt("http-enable");
        OptionBuilder.withDescription("Enable HTTP.  Default is true ,unless SSL or AJP are enabled.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("httpenable"));
        OptionBuilder.withLongOpt("ajp-enable");
        OptionBuilder.withDescription("Enable AJP.  Default is false.  When enabled, http is disabled by default.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("ajpenable"));
        OptionBuilder.withLongOpt("urlrewrite-enable");
        OptionBuilder.withDescription("Enable URL Rewriting.  Default is true.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("urlrewriteenable"));
        OptionBuilder.withLongOpt("urlrewrite-file");
        OptionBuilder.withDescription("URL rewriting config file.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path/to/urlrewrite/file");
        options.addOption(OptionBuilder.create("urlrewritefile"));
        OptionBuilder.withLongOpt("ssl-enable");
        OptionBuilder.withDescription("Enable SSL.  Default is false.  When enabled, http is disabled by default.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("sslenable"));
        OptionBuilder.withLongOpt("ssl-port");
        OptionBuilder.withDescription("SSL port.  Disabled if not set.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("port");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create("sslport"));
        OptionBuilder.withLongOpt("ssl-cert");
        OptionBuilder.withDescription("SSL certificate file in x509 (PKS#12) format.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("certificate");
        options.addOption(OptionBuilder.create("sslcert"));
        OptionBuilder.withLongOpt("ssl-key");
        OptionBuilder.withDescription("SSL private key file in DER (PKS#8) format.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("key");
        options.addOption(OptionBuilder.create("sslkey"));
        OptionBuilder.withLongOpt("ssl-keypass");
        OptionBuilder.withDescription("SSL key passphrase.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("passphrase");
        options.addOption(OptionBuilder.create("sslkeypass"));
        OptionBuilder.withLongOpt("ajp-port");
        OptionBuilder.withDescription("AJP port.  Disabled if not set.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("ajp port");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create("ajpport"));
        OptionBuilder.withLongOpt("log-dir");
        OptionBuilder.withDescription("Log directory.  (WEB-INF/logs)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path/to/log/dir");
        options.addOption(OptionBuilder.create("logdir"));
        OptionBuilder.withLongOpt("request-log");
        OptionBuilder.withDescription("Log requests to specified file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("/path/to/log");
        options.addOption(OptionBuilder.create("requestlog"));
        OptionBuilder.withLongOpt("dirs");
        OptionBuilder.withDescription("List of external directories to serve from");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path,path,...");
        options.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("lib-dirs");
        OptionBuilder.withDescription("List of directories to add contents of to classloader");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path,path,...");
        options.addOption(OptionBuilder.create("libdirs"));
        OptionBuilder.withLongOpt("jar");
        OptionBuilder.withDescription("jar to be added to classpath");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("j"));
        OptionBuilder.withLongOpt("background");
        OptionBuilder.withDescription("Run in background (true)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create('b'));
        OptionBuilder.withLongOpt("open-browser");
        OptionBuilder.withDescription("Open default web browser after start (false)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        options.addOption(OptionBuilder.create("open"));
        OptionBuilder.withLongOpt("open-url");
        OptionBuilder.withDescription("URL to open browser to. (http://$host:$port)\n");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("url");
        options.addOption(OptionBuilder.create("url"));
        OptionBuilder.withLongOpt("pid-file");
        OptionBuilder.withDescription("Process ID file.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("pidfile");
        options.addOption(OptionBuilder.create("pidfile"));
        OptionBuilder.withLongOpt("timeout");
        OptionBuilder.withDescription("Startup timout for background process. (50)\n");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("seconds");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create("t"));
        OptionBuilder.withLongOpt("log-level");
        OptionBuilder.withDescription("log level [DEBUG|INFO|WARN|ERROR] (WARN)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("level");
        options.addOption(OptionBuilder.create("level"));
        OptionBuilder.withLongOpt("debug-enable");
        OptionBuilder.withDescription("set log level to debug");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("debug"));
        OptionBuilder.withLongOpt("processname");
        OptionBuilder.withDescription("Process name where applicable");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("name");
        options.addOption(OptionBuilder.create("procname"));
        OptionBuilder.withLongOpt("tray-icon");
        OptionBuilder.withDescription("tray icon and OS X dock icon png image");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("icon"));
        OptionBuilder.withLongOpt("tray-config");
        OptionBuilder.withDescription("tray menu config path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("trayconfig"));
        OptionBuilder.withLongOpt("status-file");
        OptionBuilder.withDescription("status file (started/stopped) path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("statusfile"));
        OptionBuilder.withLongOpt("web-xml-path");
        OptionBuilder.withDescription("full path to default web.xml file for configuring the server");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("webxmlpath"));
        OptionBuilder.withLongOpt("cfengine-name");
        OptionBuilder.withDescription("name of cfml engine, defaults to lucee");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("name");
        options.addOption(OptionBuilder.create("cfengine"));
        OptionBuilder.withLongOpt("cfml-web-config");
        OptionBuilder.withDescription("full path to cfml web context config directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("cfwebconf"));
        OptionBuilder.withLongOpt("cfml-server-config");
        OptionBuilder.withDescription("full path to cfml server context config directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        options.addOption(OptionBuilder.create("cfserverconf"));
        OptionBuilder.withArgName("property=value");
        OptionBuilder.withLongOpt("sysprop");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("system property to set");
        options.addOption(OptionBuilder.create("D"));
        OptionBuilder.withLongOpt("welcome-files");
        OptionBuilder.withDescription("comma delinated list of welcome files used if no web.xml file exists");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("index.cfm,default.cfm,...");
        options.addOption(OptionBuilder.create("welcomefiles"));
        OptionBuilder.withLongOpt("directory-index");
        OptionBuilder.withDescription("enable directory browsing");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("directoryindex"));
        OptionBuilder.withLongOpt("cache-enable");
        OptionBuilder.withDescription("enable static asset cache");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("cache"));
        OptionBuilder.withLongOpt("custom-httpstatus-enable");
        OptionBuilder.withDescription("enable custom HTTP status code messages");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("customstatus"));
        OptionBuilder.withLongOpt("transfer-min-size");
        OptionBuilder.withDescription("Minimun transfer file size to offload to OS. (100)\n");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("transferminsize");
        OptionBuilder.withType(Long.class);
        options.addOption(OptionBuilder.create("transferminsize"));
        OptionBuilder.withLongOpt("sendfile-enable");
        OptionBuilder.withDescription("enable sendfile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("sendfile"));
        OptionBuilder.withLongOpt("gzip-enable");
        OptionBuilder.withDescription("enable gzip");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("gzip"));
        OptionBuilder.withLongOpt("mariadb4j-enable");
        OptionBuilder.withDescription("enable MariaDB4j");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("true|false");
        OptionBuilder.withType(Boolean.class);
        options.addOption(OptionBuilder.create("mariadb4j"));
        OptionBuilder.withLongOpt("mariadb4j-port");
        OptionBuilder.withDescription("enable MariaDB4j");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("port");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create("mariadb4jport"));
        OptionBuilder.withLongOpt("mariadb4j-basedir");
        OptionBuilder.withDescription("base directory.  (temp/mariadb4j)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path/to/base/dir");
        options.addOption(OptionBuilder.create("mariadb4jbasedir"));
        OptionBuilder.withLongOpt("mariadb4j-datadir");
        OptionBuilder.withDescription("data directory.  (temp/mariadb4j/data)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path/to/data/dir");
        options.addOption(OptionBuilder.create("mariadb4jdatadir"));
        OptionBuilder.withLongOpt("mariadb4j-import");
        OptionBuilder.withDescription("SQL file to import.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path/to/sql/file");
        options.addOption(OptionBuilder.create("mariadb4jimport"));
        options.addOption(new Option("h", "help", false, "print this message"));
        options.addOption(new Option("v", "version", false, "print runwar version and undertow version"));
        try {
            Object object;
            Object object2;
            CommandLine commandLine = parser.parse(options, stringArray);
            if (commandLine.hasOption("help")) {
                CommandLineHandler.printUsage("Options", 0);
            }
            if (commandLine.hasOption("version")) {
                Server.printVersion();
                System.exit(0);
            }
            if (commandLine.hasOption("c")) {
                object2 = commandLine.getOptionValue("c");
                log.debug("Loading config from file: " + CommandLineHandler.getFile((String)object2));
                serverOptions = new ConfigParser(CommandLineHandler.getFile((String)object2)).getServerOptions();
            }
            if (commandLine.hasOption("name")) {
                serverOptions.setServerName(commandLine.getOptionValue("name"));
            }
            if (commandLine.hasOption("debug")) {
                object2 = Boolean.valueOf(commandLine.getOptionValue("debug"));
                serverOptions.setDebug((Boolean)object2);
                if (((Boolean)object2).booleanValue()) {
                    serverOptions.setLoglevel("DEBUG");
                }
            }
            if (commandLine.hasOption("level") && commandLine.getOptionValue("level").length() > 0) {
                serverOptions.setLoglevel(commandLine.getOptionValue("level"));
            }
            if (commandLine.hasOption("background")) {
                serverOptions.setBackground(Boolean.valueOf(commandLine.getOptionValue("background")));
            }
            if (commandLine.hasOption("libdirs") && commandLine.getOptionValue("libdirs").length() > 0) {
                object2 = commandLine.getOptionValue("libdirs").split(",");
                String[] stringArray2 = object2;
                int n = ((String[])object2).length;
                int n2 = 0;
                while (n2 < n) {
                    object = stringArray2[n2];
                    File file = new File((String)object);
                    if (!file.exists() || !file.isDirectory()) {
                        CommandLineHandler.printUsage("No such lib directory " + (String)object, 1);
                    }
                    ++n2;
                }
                serverOptions.setLibDirs(commandLine.getOptionValue("libdirs"));
            }
            if (commandLine.hasOption("welcomefiles") && commandLine.getOptionValue("welcomefiles").length() > 0) {
                serverOptions.setWelcomeFiles(commandLine.getOptionValue("welcomefiles").split(","));
            }
            if (commandLine.hasOption("jar")) {
                object2 = new File(commandLine.getOptionValue("jar"));
                if (!((File)object2).exists() || ((File)object2).isDirectory()) {
                    CommandLineHandler.printUsage("No such jar " + object2, 1);
                }
                serverOptions.setJarURL(((File)object2).toURI().toURL());
            }
            if (commandLine.hasOption("timeout")) {
                serverOptions.setLaunchTimeout(((Number)commandLine.getParsedOptionValue("timeout")).intValue() * 1000);
            }
            if (commandLine.hasOption("password")) {
                serverOptions.setStopPassword(commandLine.getOptionValue("password").toCharArray());
            }
            if (commandLine.hasOption("stopsocket")) {
                serverOptions.setSocketNumber(((Number)commandLine.getParsedOptionValue("stopsocket")).intValue());
            }
            if (commandLine.hasOption("war")) {
                object2 = commandLine.getOptionValue("war");
                serverOptions.setWarFile(CommandLineHandler.getFile((String)object2));
            } else if (!commandLine.hasOption("stop") && !commandLine.hasOption("c")) {
                CommandLineHandler.printUsage("Must specify -war path/to/war, or -stop [-stop-socket]", 1);
            }
            if (commandLine.hasOption("D")) {
                object2 = commandLine.getOptionValues("D");
                int n = 0;
                while (n < ((Object)object2).length) {
                    log.debugf("setting system property: %s", String.valueOf(((String)object2[n]).toString()) + '=' + ((String)object2[n + 1]).toString());
                    System.setProperty(((String)object2[n]).toString(), ((String)object2[n + 1]).toString());
                    ++n;
                    ++n;
                }
            }
            if (commandLine.hasOption("webxmlpath")) {
                object2 = commandLine.getOptionValue("webxmlpath");
                object = new File((String)object2);
                if (((File)object).exists()) {
                    serverOptions.setWebXmlFile((File)object);
                } else {
                    throw new RuntimeException("Could not find web.xml! " + (String)object2);
                }
            }
            if (commandLine.hasOption("stop")) {
                serverOptions.setAction("stop");
                object2 = commandLine.getOptionValues("stop");
                if (object2 != null && ((Object)object2).length > 0) {
                    serverOptions.setSocketNumber(Integer.parseInt((String)object2[0]));
                }
                if (object2 != null && ((Object)object2).length >= 1) {
                    serverOptions.setStopPassword(((String)object2[1]).toCharArray());
                }
            } else {
                serverOptions.setAction("start");
            }
            if (commandLine.hasOption("context")) {
                serverOptions.setContextPath(commandLine.getOptionValue("context"));
            }
            if (commandLine.hasOption("host")) {
                serverOptions.setHost(commandLine.getOptionValue("host"));
            }
            if (commandLine.hasOption("p")) {
                serverOptions.setPortNumber(((Number)commandLine.getParsedOptionValue("p")).intValue());
            }
            if (commandLine.hasOption("enableajp")) {
                serverOptions.setEnableAJP(Boolean.valueOf(commandLine.getOptionValue("enableajp")));
            }
            if (commandLine.hasOption("ajpport")) {
                serverOptions.setEnableHTTP(commandLine.hasOption("port")).setEnableAJP(true).setAJPPort(((Number)commandLine.getParsedOptionValue("ajpport")).intValue());
            }
            if (commandLine.hasOption("sslport")) {
                if (!commandLine.hasOption("httpenable")) {
                    serverOptions.setEnableHTTP(false);
                }
                serverOptions.setEnableSSL(true).setSSLPort(((Number)commandLine.getParsedOptionValue("sslport")).intValue());
            }
            if (commandLine.hasOption("sslcert")) {
                serverOptions.setSSLCertificate(CommandLineHandler.getFile(commandLine.getOptionValue("sslcert")));
                if (!commandLine.hasOption("sslkey") || !commandLine.hasOption("sslkey")) {
                    throw new RuntimeException("Using a SSL certificate requires -sslkey /path/to/file and -sslkeypass pass**** arguments!");
                }
            }
            if (commandLine.hasOption("sslkey")) {
                serverOptions.setSSLKey(CommandLineHandler.getFile(commandLine.getOptionValue("sslkey")));
            }
            if (commandLine.hasOption("sslkeypass")) {
                serverOptions.setSSLKeyPass(commandLine.getOptionValue("sslkeypass").toCharArray());
            }
            if (commandLine.hasOption("sslenable")) {
                if (!commandLine.hasOption("httpenable")) {
                    serverOptions.setEnableHTTP(false);
                }
                serverOptions.setEnableSSL(Boolean.valueOf(commandLine.getOptionValue("sslenable")));
            }
            if (commandLine.hasOption("httpenable")) {
                serverOptions.setEnableHTTP(Boolean.valueOf(commandLine.getOptionValue("httpenable")));
            }
            if (commandLine.hasOption("urlrewritefile")) {
                serverOptions.setURLRewriteFile(CommandLineHandler.getFile(commandLine.getOptionValue("urlrewritefile")));
                if (!commandLine.hasOption("urlrewriteenable")) {
                    serverOptions.setEnableURLRewrite(true);
                }
            }
            if (commandLine.hasOption("urlrewriteenable")) {
                serverOptions.setEnableURLRewrite(Boolean.valueOf(commandLine.getOptionValue("urlrewriteenable")));
            }
            if (commandLine.hasOption("logdir")) {
                serverOptions.setLogDir(commandLine.getOptionValue("logdir"));
            } else if (serverOptions.getWarFile() != null) {
                String string;
                object2 = serverOptions.getWarFile();
                object = ((File)object2).isDirectory() && new File((File)object2, "WEB-INF").exists() ? String.valueOf(((File)object2).getPath()) + "/WEB-INF/logs/" : ((string = System.getProperty("cfml.server.config.dir")) == null ? new File(Server.getThisJarLocation().getParentFile(), "engine/cfml/server/log/").getAbsolutePath() : new File(string, "log/").getAbsolutePath());
                serverOptions.setLogDir((String)object);
            }
            if (serverOptions.getWarFile() != null) {
                serverOptions.setCfmlDirs(serverOptions.getWarFile().getAbsolutePath());
            }
            if (commandLine.hasOption("dirs")) {
                serverOptions.setCfmlDirs(commandLine.getOptionValue("dirs"));
            }
            if (commandLine.hasOption("requestlog")) {
                serverOptions.setKeepRequestLog(Boolean.valueOf(commandLine.getOptionValue("requestlog")));
            }
            if (commandLine.hasOption("open-browser")) {
                serverOptions.setOpenbrowser(Boolean.valueOf(commandLine.getOptionValue("open")));
            }
            if (commandLine.hasOption("open-url")) {
                serverOptions.setOpenbrowserURL(commandLine.getOptionValue("open-url"));
            }
            if (commandLine.hasOption("pidfile")) {
                serverOptions.setPidFile(commandLine.getOptionValue("pidfile"));
            }
            if (commandLine.hasOption("processname")) {
                serverOptions.setProcessName(commandLine.getOptionValue("processname"));
            }
            if (commandLine.hasOption("icon")) {
                serverOptions.setIconImage(commandLine.getOptionValue("icon"));
            }
            if (commandLine.hasOption("trayconfig") && commandLine.getOptionValue("trayconfig").length() > 0) {
                serverOptions.setTrayConfig(CommandLineHandler.getFile(commandLine.getOptionValue("trayconfig")));
            }
            if (commandLine.hasOption("statusfile") && commandLine.getOptionValue("statusfile").length() > 0) {
                serverOptions.setStatusFile(CommandLineHandler.getFile(commandLine.getOptionValue("statusfile")));
            }
            if (commandLine.hasOption("cfengine")) {
                serverOptions.setCFEngineName(commandLine.getOptionValue("cfengine"));
            }
            if (commandLine.hasOption("cfserverconf")) {
                serverOptions.setCFMLServletConfigServerDir(commandLine.getOptionValue("cfserverconf"));
            }
            if (commandLine.hasOption("cfwebconf")) {
                serverOptions.setCFMLServletConfigWebDir(commandLine.getOptionValue("cfwebconf"));
            }
            if (commandLine.hasOption("directoryindex")) {
                serverOptions.setDirectoryListingEnabled(Boolean.valueOf(commandLine.getOptionValue("directoryindex")));
            }
            if (commandLine.hasOption("cache")) {
                serverOptions.setCacheEnabled(Boolean.valueOf(commandLine.getOptionValue("cache")));
            }
            if (commandLine.hasOption("customstatus")) {
                serverOptions.setCustomHTTPStatusEnabled(Boolean.valueOf(commandLine.getOptionValue("customstatus")));
            }
            if (commandLine.hasOption("transferminsize")) {
                serverOptions.setTransferMinSize(Long.valueOf(commandLine.getOptionValue("transferminsize")));
            }
            if (commandLine.hasOption("sendfile")) {
                serverOptions.setSendfileEnabled(Boolean.valueOf(commandLine.getOptionValue("sendfile")));
            }
            if (commandLine.hasOption("gzip")) {
                serverOptions.setGzipEnabled(Boolean.valueOf(commandLine.getOptionValue("gzip")));
            }
            if (commandLine.hasOption("mariadb4j")) {
                serverOptions.setMariaDB4jEnabled(Boolean.valueOf(commandLine.getOptionValue("mariadb4j")));
            }
            if (commandLine.hasOption("mariadb4jport") && commandLine.getOptionValue("mariadb4jport").length() > 0) {
                serverOptions.setMariaDB4jPort(Integer.valueOf(commandLine.getOptionValue("mariadb4jport")));
            }
            if (commandLine.hasOption("mariadb4jbasedir") && commandLine.getOptionValue("mariadb4jbasedir").length() > 0) {
                serverOptions.setMariaDB4jBaseDir(new File(commandLine.getOptionValue("mariadb4jbasedir")));
            }
            if (commandLine.hasOption("mariadb4jdatadir") && commandLine.getOptionValue("mariadb4jdatadir").length() > 0) {
                serverOptions.setMariaDB4jDataDir(new File(commandLine.getOptionValue("mariadb4jdatadir")));
            }
            if (commandLine.hasOption("mariadb4jimport") && commandLine.getOptionValue("mariadb4jimport").length() > 0) {
                serverOptions.setMariaDB4jImportSQLFile(new File(commandLine.getOptionValue("mariadb4jimport")));
            }
            if (serverOptions.getLoglevel().equals("DEBUG")) {
                Option[] optionArray = commandLine.getOptions();
                int n = optionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    object2 = optionArray[n3];
                    log.debug(object2);
                    log.debug(((Option)object2).getValue());
                    ++n3;
                }
            }
            return serverOptions;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = exception.getMessage();
            if (string == null) {
                string = "null : " + exception.getStackTrace()[0].toString();
                if (exception.getStackTrace().length > 0) {
                    string = String.valueOf(string) + '\n' + exception.getStackTrace()[1].toString();
                }
            } else {
                string = String.valueOf(exception.getClass().getName()) + " " + string;
            }
            CommandLineHandler.printUsage(string, 1);
            return null;
        }
    }

    static File getFile(String string) {
        File file = new File(string);
        if (!file.exists() || file == null) {
            throw new RuntimeException("File not found: " + string);
        }
        return file;
    }

    static void printUsage(String string, int n) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(new Comparator<Option>(){

            @Override
            public int compare(Option option, Option option2) {
                if (option.getOpt().equals("war")) {
                    return -1;
                }
                if (option2.getOpt().equals("war")) {
                    return 1;
                }
                if (option.getOpt().equals("p")) {
                    return -1;
                }
                if (option2.getOpt().equals("p")) {
                    return 1;
                }
                if (option.getOpt().equals("c")) {
                    return -1;
                }
                if (option2.getOpt().equals("c")) {
                    return 1;
                }
                if (option.getOpt().equals("context")) {
                    return -1;
                }
                if (option2.getOpt().equals("context")) {
                    return 1;
                }
                if (option.getOpt().equals("d")) {
                    return -1;
                }
                if (option2.getOpt().equals("d")) {
                    return 1;
                }
                if (option.getOpt().equals("b")) {
                    return -1;
                }
                if (option2.getOpt().equals("b")) {
                    return 1;
                }
                if (option.getOpt().equals("h")) {
                    return 1;
                }
                if (option2.getOpt().equals("h")) {
                    return -1;
                }
                if (option.getOpt().equals("url")) {
                    return 1;
                }
                if (option2.getOpt().equals("url")) {
                    return -1;
                }
                if (option.getOpt().equals("open")) {
                    return 1;
                }
                if (option2.getOpt().equals("open")) {
                    return -1;
                }
                if (option.getOpt().equals("stopsocket")) {
                    return 1;
                }
                if (option2.getOpt().equals("stopsocket")) {
                    return -1;
                }
                if (option.getOpt().equals("stop")) {
                    return 1;
                }
                if (option2.getOpt().equals("stop")) {
                    return -1;
                }
                return option.getOpt().compareTo(option2.getOpt());
            }
        });
        helpFormatter.setWidth(80);
        helpFormatter.setSyntaxPrefix("USAGE:");
        helpFormatter.setLongOptPrefix("--");
        if (n == 0) {
            helpFormatter.printHelp(80, SYNTAX, String.valueOf(string) + '\n' + HEADER, options, FOOTER, false);
        } else {
            System.out.println("USAGE:   java -jar runwar.jar [-war] path/to/war [options]\n" + string);
        }
        System.exit(n);
    }
}

