/*
 * Decompiled with CFR 0.152.
 */
package runwar.options;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import runwar.LaunchUtil;
import runwar.Server;
import runwar.logging.Logger;
import runwar.options.CommandLineHandler;
import runwar.options.ServerOptions;

public class ConfigParser {
    private static Logger log = Logger.getLogger("RunwarLogger");
    private ServerOptions serverOptions;

    public ConfigParser(File file) {
        this.parseOptions(file);
        if (this.serverOptions != null) {
            this.serverOptions.setConfigFile(file);
        }
    }

    public ServerOptions getServerOptions() {
        return this.serverOptions;
    }

    private ServerOptions parseOptions(File file) {
        JSONObject jSONObject = null;
        String string = "unknown";
        try {
            string = file.getCanonicalPath();
            jSONObject = (JSONObject)JSONValue.parseWithException(LaunchUtil.readFile(file));
        }
        catch (IOException | ParseException exception) {
            System.out.println("Could not load " + string + " : " + exception.getMessage());
            throw new RuntimeException("Could not load " + string + " : " + exception.getMessage());
        }
        if (jSONObject != null) {
            Object object;
            this.serverOptions = new ServerOptions();
            JSONOption jSONOption = new JSONOption(jSONObject);
            if (jSONOption.hasOption("help")) {
                this.printUsage("Options", 0);
            }
            if (jSONOption.hasOption("loglevel")) {
                this.serverOptions.setLoglevel(jSONOption.getOptionValue("loglevel"));
            }
            if (jSONOption.hasOption("name")) {
                this.serverOptions.setServerName(jSONOption.getOptionValue("name"));
            }
            if (jSONOption.hasOption("debug")) {
                object = Boolean.valueOf(jSONOption.getOptionValue("debug"));
                this.serverOptions.setDebug((Boolean)object);
                if (((Boolean)object).booleanValue()) {
                    this.serverOptions.setLoglevel("DEBUG");
                }
                if (jSONOption.hasOption("loglevel")) {
                    System.out.println("Warning:  debug overrides loglevel (both are specified, setting level to DEBUG)");
                }
            }
            if (jSONOption.hasOption("background")) {
                this.serverOptions.setBackground(Boolean.valueOf(jSONOption.getOptionValue("background")));
            }
            if (jSONOption.hasOption("libs")) {
                object = jSONOption.getOptionValue("libs").split(",");
                String[] stringArray = object;
                int n = ((String[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    File file2 = new File(string2);
                    if (!file2.exists() || !file2.isDirectory()) {
                        this.printUsage("No such lib directory " + string2, 1);
                    }
                    ++n2;
                }
                this.serverOptions.setLibDirs(jSONOption.getOptionValue("libs"));
            }
            if (jSONOption.hasOption("welcomefiles")) {
                this.serverOptions.setWelcomeFiles(jSONOption.getOptionValue("welcomefiles").split(","));
            }
            if (jSONOption.hasOption("jar")) {
                object = new File(jSONOption.getOptionValue("jar"));
                try {
                    this.serverOptions.setJarURL(((File)object).toURI().toURL());
                    if (!((File)object).exists() || ((File)object).isDirectory()) {
                        this.printUsage("No such jar " + object, 1);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.printUsage("No such jar " + object, 1);
                    malformedURLException.printStackTrace();
                }
            }
            if (jSONOption.hasOption("timeout")) {
                this.serverOptions.setLaunchTimeout(jSONOption.getParsedOptionValue("timeout").intValue() * 1000);
            }
            if (jSONOption.hasOption("password")) {
                this.serverOptions.setStopPassword(jSONOption.getOptionValue("password").toCharArray());
            }
            if (jSONOption.hasOption("stop-port")) {
                this.serverOptions.setSocketNumber(jSONOption.getParsedOptionValue("stop-port").intValue());
            }
            if (jSONOption.hasOption("war")) {
                object = jSONOption.getOptionValue("war");
                this.serverOptions.setWarFile(this.getFile((String)object));
            } else if (!jSONOption.hasOption("stop") && !jSONOption.hasOption("c")) {
                this.printUsage("Must specify -war path/to/war, or -stop [-stop-socket]", 1);
            }
            if (jSONOption.hasOption("D")) {
                object = jSONOption.getOptionValue("D").split(" ");
                int n = 0;
                while (n < ((Object)object).length) {
                    log.debugf("setting system property: %s", String.valueOf(((String)object[n]).toString()) + '=' + ((String)object[n + 1]).toString());
                    System.setProperty(((String)object[n]).toString(), ((String)object[n + 1]).toString());
                    ++n;
                    ++n;
                }
            }
            if (jSONOption.hasOption("webxmlpath")) {
                object = jSONOption.getOptionValue("webxmlpath");
                File file3 = new File((String)object);
                if (file3.exists()) {
                    this.serverOptions.setWebXmlFile(file3);
                } else {
                    throw new RuntimeException("Could not find web.xml! " + (String)object);
                }
            }
            if (jSONOption.hasOption("stop")) {
                this.serverOptions.setAction("stop");
                object = jSONOption.getOptionValue("stop").split(" ");
                if (object != null && ((Object)object).length > 0) {
                    this.serverOptions.setSocketNumber(Integer.parseInt((String)object[0]));
                }
                if (object != null && ((Object)object).length >= 1) {
                    this.serverOptions.setStopPassword(((String)object[1]).toCharArray());
                }
            } else {
                this.serverOptions.setAction("start");
            }
            if (jSONOption.hasOption("context")) {
                this.serverOptions.setContextPath(jSONOption.getOptionValue("context"));
            }
            if (jSONOption.hasOption("host")) {
                this.serverOptions.setHost(jSONOption.getOptionValue("host"));
            }
            if (jSONOption.hasOption("port")) {
                this.serverOptions.setPortNumber(jSONOption.getParsedOptionValue("port").intValue());
            }
            if (jSONOption.hasOption("ajpport")) {
                this.serverOptions.setEnableHTTP(false).setEnableAJP(true).setAJPPort(jSONOption.getParsedOptionValue("ajpport").intValue());
            }
            if (jSONOption.hasOption("sslport")) {
                this.serverOptions.setEnableHTTP(false).setEnableSSL(true).setSSLPort(jSONOption.getParsedOptionValue("sslport").intValue());
            }
            if (jSONOption.hasOption("sslcert")) {
                this.serverOptions.setSSLCertificate(this.getFile(jSONOption.getOptionValue("sslcert")));
                if (!jSONOption.hasOption("sslkey") || !jSONOption.hasOption("sslkey")) {
                    throw new RuntimeException("Using a SSL certificate requires -sslkey /path/to/file and -sslkeypass pass**** arguments!");
                }
            }
            if (jSONOption.hasOption("sslkey")) {
                this.serverOptions.setSSLKey(this.getFile(jSONOption.getOptionValue("sslkey")));
            }
            if (jSONOption.hasOption("sslkeypass")) {
                this.serverOptions.setSSLKeyPass(jSONOption.getOptionValue("sslkeypass").toCharArray());
            }
            if (jSONOption.hasOption("enableajp")) {
                this.serverOptions.setEnableAJP(Boolean.valueOf(jSONOption.getOptionValue("enableajp")));
            }
            if (jSONOption.hasOption("enablessl")) {
                this.serverOptions.setEnableHTTP(false).setEnableSSL(Boolean.valueOf(jSONOption.getOptionValue("enablessl")));
            }
            if (jSONOption.hasOption("enablehttp")) {
                this.serverOptions.setEnableHTTP(Boolean.valueOf(jSONOption.getOptionValue("enablehttp")));
            }
            if (jSONOption.hasOption("urlrewritefile")) {
                this.serverOptions.setURLRewriteFile(this.getFile(jSONOption.getOptionValue("urlrewritefile")));
            }
            if (jSONOption.hasOption("urlrewriteenable")) {
                this.serverOptions.setEnableURLRewrite(Boolean.valueOf(jSONOption.getOptionValue("urlrewriteenable")));
            }
            if (jSONOption.hasOption("logdir")) {
                this.serverOptions.setLogDir(jSONOption.getOptionValue("logdir"));
            } else if (this.serverOptions.getWarFile() != null) {
                String string3;
                object = this.serverOptions.getWarFile();
                String string4 = ((File)object).isDirectory() && new File((File)object, "WEB-INF").exists() ? String.valueOf(((File)object).getPath()) + "/WEB-INF/logs/" : ((string3 = System.getProperty("cfml.server.config.dir")) == null ? new File(Server.getThisJarLocation().getParentFile(), "server/log/").getAbsolutePath() : new File(string3, "log/").getAbsolutePath());
                this.serverOptions.setLogDir(string4);
            }
            if (this.serverOptions.getWarFile() != null) {
                this.serverOptions.setCfmlDirs(this.serverOptions.getWarFile().getAbsolutePath());
            }
            if (jSONOption.hasOption("dirs")) {
                this.serverOptions.setCfmlDirs(jSONOption.getOptionValue("dirs"));
            }
            if (jSONOption.hasOption("requestlog")) {
                this.serverOptions.setKeepRequestLog(Boolean.valueOf(jSONOption.getOptionValue("requestlog")));
            }
            if (jSONOption.hasOption("open-browser")) {
                this.serverOptions.setOpenbrowser(Boolean.valueOf(jSONOption.getOptionValue("open")));
            }
            if (jSONOption.hasOption("open-url")) {
                this.serverOptions.setOpenbrowserURL(jSONOption.getOptionValue("open-url"));
            }
            if (jSONOption.hasOption("pidfile")) {
                this.serverOptions.setPidFile(jSONOption.getOptionValue("pidfile"));
            }
            if (jSONOption.hasOption("processname")) {
                this.serverOptions.setProcessName(jSONOption.getOptionValue("processname"));
            }
            if (jSONOption.hasOption("trayconfig")) {
                this.serverOptions.setTrayConfig(this.getFile(jSONOption.getOptionValue("trayconfig")));
            }
            if (jSONOption.hasOption("statusfile")) {
                this.serverOptions.setStatusFile(this.getFile(jSONOption.getOptionValue("statusfile")));
            }
            if (jSONOption.hasOption("icon")) {
                this.serverOptions.setIconImage(jSONOption.getOptionValue("icon"));
            }
            if (jSONOption.hasOption("cfengine")) {
                this.serverOptions.setCFEngineName(jSONOption.getOptionValue("cfengine"));
            }
            if (jSONOption.hasOption("cfserverconf")) {
                this.serverOptions.setCFMLServletConfigServerDir(jSONOption.getOptionValue("cfserverconf"));
            }
            if (jSONOption.hasOption("cfwebconf")) {
                this.serverOptions.setCFMLServletConfigWebDir(jSONOption.getOptionValue("cfwebconf"));
            }
            if (jSONOption.hasOption("directoryindex")) {
                this.serverOptions.setDirectoryListingEnabled(Boolean.valueOf(jSONOption.getOptionValue("directoryindex")));
            }
            if (jSONOption.hasOption("cache")) {
                this.serverOptions.setCacheEnabled(Boolean.valueOf(jSONOption.getOptionValue("cache")));
            }
            if (jSONOption.hasOption("customstatus")) {
                this.serverOptions.setCustomHTTPStatusEnabled(Boolean.valueOf(jSONOption.getOptionValue("customstatus")));
            }
            if (jSONOption.hasOption("transferminsize")) {
                this.serverOptions.setTransferMinSize(Long.valueOf(jSONOption.getOptionValue("transferminsize")));
            }
            if (jSONOption.hasOption("sendfile")) {
                this.serverOptions.setSendfileEnabled(Boolean.valueOf(jSONOption.getOptionValue("sendfile")));
            }
            if (jSONOption.hasOption("gzip")) {
                this.serverOptions.setGzipEnabled(Boolean.valueOf(jSONOption.getOptionValue("gzip")));
            }
            if (jSONOption.hasOption("mariadb4j")) {
                this.serverOptions.setMariaDB4jEnabled(Boolean.valueOf(jSONOption.getOptionValue("mariadb4j")));
            }
            if (jSONOption.hasOption("mariadb4jport") && jSONOption.getOptionValue("mariadb4jport").length() > 0) {
                this.serverOptions.setMariaDB4jPort(Integer.valueOf(jSONOption.getOptionValue("mariadb4jport")));
            }
            if (jSONOption.hasOption("mariadb4jbasedir") && jSONOption.getOptionValue("mariadb4jbasedir").length() > 0) {
                this.serverOptions.setMariaDB4jBaseDir(new File(jSONOption.getOptionValue("mariadb4jbasedir")));
            }
            if (jSONOption.hasOption("mariadb4jdatadir") && jSONOption.getOptionValue("mariadb4jdatadir").length() > 0) {
                this.serverOptions.setMariaDB4jDataDir(new File(jSONOption.getOptionValue("mariadb4jdatadir")));
            }
            if (jSONOption.hasOption("mariadb4jimport") && jSONOption.getOptionValue("mariadb4jimport").length() > 0) {
                this.serverOptions.setMariaDB4jImportSQLFile(new File(jSONOption.getOptionValue("mariadb4jimport")));
            }
            if (this.serverOptions.getLoglevel().equals("DEBUG")) {
                object = jSONOption.getOptions().iterator();
                while (object.hasNext()) {
                    log.debug(object.next());
                }
            }
        }
        return this.serverOptions;
    }

    private void printUsage(String string, int n) {
        CommandLineHandler.printUsage(string, n);
    }

    private File getFile(String string) {
        return CommandLineHandler.getFile(string);
    }

    private class JSONOption {
        private JSONObject jsonConfig;

        public JSONOption(JSONObject jSONObject) {
            this.jsonConfig = jSONObject;
        }

        public Number getParsedOptionValue(String string) {
            return Integer.parseInt(this.getOptionValue(string));
        }

        public ArrayList<String> getOptions() {
            Iterator iterator = this.jsonConfig.keySet().iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.add(String.valueOf(string) + "=" + this.jsonConfig.get(string).toString());
            }
            return arrayList;
        }

        public String getOptionValue(String string) {
            if (this.hasOption(string)) {
                return this.jsonConfig.get(string).toString();
            }
            return null;
        }

        public boolean hasOption(String string) {
            return this.jsonConfig.containsKey(string);
        }
    }
}

