/*
 * Decompiled with CFR 0.152.
 */
package runwar.options;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionParser;
import joptsimple.util.DateConverter;

public class HelpFormatterExample {
    public static void main(String[] stringArray) throws Exception {
        OptionParser optionParser = new OptionParser(){
            {
                this.accepts("c").withRequiredArg().ofType(Integer.class).describedAs("count").defaultsTo(1, (Integer[])new Integer[0]);
                this.accepts("q").withOptionalArg().ofType(Double.class).describedAs("quantity");
                this.accepts("d", "some date").withRequiredArg().required().withValuesConvertedBy(DateConverter.datePattern("MM/dd/yy"));
                this.acceptsAll(Arrays.asList("v", "talkative", "chatty"), "be more verbose");
                this.accepts("output-file").withOptionalArg().ofType(File.class).describedAs("file");
                this.acceptsAll(Arrays.asList("h", "?"), "show help").forHelp();
                this.acceptsAll(Arrays.asList("cp", "classpath")).withRequiredArg().describedAs("path1" + File.pathSeparatorChar + "path2:...").ofType(File.class).withValuesSeparatedBy(File.pathSeparatorChar);
                this.nonOptions("files to chew on").ofType(File.class).describedAs("input files");
            }
        };
        optionParser.formatHelpWith(new MyFormatter());
        optionParser.printHelpOn(System.out);
    }

    static class MyFormatter
    implements HelpFormatter {
        MyFormatter() {
        }

        @Override
        public String format(Map<String, ? extends OptionDescriptor> map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (OptionDescriptor optionDescriptor : new HashSet<OptionDescriptor>(map.values())) {
                stringBuilder.append(this.lineFor(optionDescriptor));
            }
            return stringBuilder.toString();
        }

        private String lineFor(OptionDescriptor optionDescriptor) {
            if (optionDescriptor.representsNonOptions()) {
                return String.valueOf(optionDescriptor.argumentDescription()) + '(' + optionDescriptor.argumentTypeIndicator() + "): " + optionDescriptor.description() + System.getProperty("line.separator");
            }
            StringBuilder stringBuilder = new StringBuilder(optionDescriptor.options().toString());
            stringBuilder.append(": description = ").append(optionDescriptor.description());
            stringBuilder.append(", required = ").append(optionDescriptor.isRequired());
            stringBuilder.append(", accepts arguments = ").append(optionDescriptor.acceptsArguments());
            stringBuilder.append(", requires argument = ").append(optionDescriptor.requiresArgument());
            stringBuilder.append(", argument description = ").append(optionDescriptor.argumentDescription());
            stringBuilder.append(", argument type indicator = ").append(optionDescriptor.argumentTypeIndicator());
            stringBuilder.append(", default values = ").append(optionDescriptor.defaultValues());
            stringBuilder.append(System.getProperty("line.separator"));
            return stringBuilder.toString();
        }
    }
}

